# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
DEVCACHE_DEP =  $(INCLUDE_PATH)devcache.h $(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h $(INCLUDE_PATH)memblock.h

MEMBUF_DEP = $(INCLUDE_PATH)membuf.h

MEMBLOCK_DEP = $(INCLUDE_PATH)memblock.h

PROJECT_DEP = $(INCLUDE_PATH)devcache.h $(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h $(INCLUDE_PATH)memblock.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

devcache$(OBJ_EXT):	$(SRC_PATH)devcache.cpp $(DEVCACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)devcache.cpp

membuf$(OBJ_EXT):	$(SRC_PATH)membuf.cpp $(MEMBUF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)membuf.cpp

memblock$(OBJ_EXT):	$(SRC_PATH)memblock.cpp $(MEMBLOCK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)memblock.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	devcache$(OBJ_EXT) membuf$(OBJ_EXT) memblock$(OBJ_EXT)
# ===============================================================
