// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the base 64 encode and decode
routines.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxs_b64.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void InputString(const char *mesg, gxString &s)
{
  cout << mesg;
  char sbuf[255];
  for(int i = 0; i < 255; i++) sbuf[i] = 0;
  cin >> sbuf;
  s = sbuf;
}

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  cout << endl;
  gxString wwwauth, ubuf, pbuf, user, passwd;
  cout << "Base 64 encoding username and password" << endl;
  InputString("Username: ", ubuf);
  InputString("Password: ", pbuf);
  cout << endl;
  
  gxsBasicAuthenticationEncode(ubuf.c_str(), pbuf.c_str(), "Basic", wwwauth);
  cout << wwwauth << endl;
  cout << "Decoding base 64 authentication line" << endl;
  gxsBasicAuthenticationDecode(wwwauth, user, passwd);
  cout << "Username: " << user << endl;
  cout << "Password: " << passwd << endl;
  cout << endl;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
