// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: client.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to the gxStream class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "gxstream.h"

const char *test_block = "The quick brown fox jumps over the lazy dog \
0123456789\n";

void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void PrgMenu()
{
  cout << endl;
  cout << "(a, A)    Add a database block" << endl;
  cout << "(c, C)    Change a database block" << endl;
  cout << "(d, D)    Delete a database block" << endl;
  cout << "(l, L)    Send a client close command" << endl;
  cout << "(h, H, ?) Help (prints this menu)" << endl;
  cout << "(k, K)    Shutdown the server" << endl;
  cout << "(q, Q)    Quit this program" << endl;
  cout << "(r, R)    Request a database block" << endl;
  cout << "(s, S)    Send a raw block of data" << endl;
  cout << "(w, W)    Send an acknowledgment block" << endl;
  cout << endl;
}

void Acknowledge(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Requesting acknowledgment block from the server" << endl;

  if(client.WriteAckBlock() != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  if(client.ReadAckBlock() != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Received an acknowledgment from the server " << endl;
  client.Close();
}

void CloseCommand(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }
  cout << "Closing the connection..." << endl;
  if(client.CloseConnection() != 0)
    cout << client.SocketExceptionMessage() << endl;
  client.Close();
}

void DeleteBlock(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Sending a request to delete a remote block" << endl;
  char *request = "DOG"; // Arbitary block ID
  gxBlockHeader gx;
  gx.block_length = strlen(request);

  if(client.DeleteBlock((char *)request, gx) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void AddBlock(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Sending a request to add a remote block" << endl;

  gxBlockHeader gx;
  gx.block_length = strlen(test_block);

  if(client.AddBlock((char *)test_block, gx) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void ChangeBlock(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Sending a request to change a remote block" << endl;

  char *request = "CAT"; // Arbitary block ID
  gxBlockHeader request_header;
  request_header.block_length = strlen(request);

  gxBlockHeader block_header;
  block_header.block_length = strlen(test_block);

  if(client.ChangeBlock((char *)request, (char *)test_block, request_header,
			block_header) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void ShutDownServer(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Shutting down the server..." << endl;
  if(client.TerminateConnection() != 0) 
    cout << client.SocketExceptionMessage() << endl;
  client.Close();
}

void RequestBlock(int port, char *host)
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Requesting a block from the server" << endl;
  char *request = "FOX"; // Arbitary block ID
  gxBlockHeader request_header;
  request_header.block_length = strlen(request);
  gxBlockHeader requested_block_header;
  request_header.block_length = strlen(request);

  void *block = client.RequestBlock((char *)request, request_header,
				    requested_block_header);
  if(!block) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }
  cout << "Received requested block" << endl;
  cout.write((char *)block, requested_block_header.block_length);
  
  client.Close();
}

void SendBlock(int port, char *host)
// Send a block of data
{
  gxStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Sending a block " << strlen(test_block) << " bytes long..." << endl;
  if(client.WriteBlock((char *)test_block, strlen(test_block)) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }
  client.Close();
}

int main(int argc, char **argv)
{
  if(argc < 3) {
    cerr << "Usage: " << argv[0] << " hostname port" << endl;
    return 1;
  }

  unsigned short port = (unsigned short) atoi(argv[2]);
  char *host = argv[1];

  char key;
  PrgMenu();
  int rv = 1;
  while(rv) {
    if (!cin) {
      ClearInputStream(cin);
      if (!cin) {
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue;
    switch(key) {
      case '?' : PrgMenu(); break;
      case 'h' : case 'H' : PrgMenu(); break;
      case 'q' : case 'Q' : rv = 0; break;

      case 'a' : case 'A' : 
	AddBlock(port, host);
	break;
      case 'c' : case 'C' : 
	ChangeBlock(port, host);
	break;
      case 'd' : case 'D' :  
	DeleteBlock(port, host);
	break;
      case 'k' : case 'K' : 
	ShutDownServer(port, host);
	break;
      case 'r' : case 'R' : 
	RequestBlock(port, host);
	break;
      case 's' : case 'S' : 
	SendBlock(port, host);
	break;
      case 'l' : case 'L' : 
	CloseCommand(port, host);
	break;
      case 'w' : case 'W' : 
	Acknowledge(port, host);
	break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }
 
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
