// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gpersist.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/18/1997
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The Persistent base class is used to define the interface 
that makes an object persistent. 
*/
// ----------------------------------------------------------- //   
#ifndef __GX_DATABASE_PERSISTENT_BASE_HPP__
#define __GX_DATABASE_PERSISTENT_BASE_HPP__

#include "pod.h"

// Object header use to ID objects in the data file
struct gxObjectHeader
{
  gxClassID ClassID;   // Class Identification number
  gxObjectID ObjectID; // Object Identification number
};

// GXD Persistent base class
class gxPersistent
{
public:
  gxPersistent(POD *DB) { Connect(DB); objectaddress = 0; }
  gxPersistent(const POD *DB) { Connect(DB); objectaddress = 0; }
  gxPersistent() { pod = 0; } 

private:
  gxPersistent(const gxPersistent &ob) { }   // Disallow coping
  void operator=(const gxPersistent &ob) { } // Disallow assignment
  
protected: // Derived class interface
  virtual gxDatabaseError Read(FAU object_address) = 0;
  virtual gxDatabaseError Write() = 0;  
  virtual int Find() = 0;
  virtual int Delete() = 0;
  virtual __UWORD__ ObjectLength() = 0;
  
protected: 
  gxDatabaseError WriteObjectHeader(const gxObjectHeader &oh, 
				    FAU object_address = (FAU_t)-1);
  gxDatabaseError ReadObjectHeader(gxObjectHeader &oh, 
				   FAU object_address = (FAU_t)-1);
  gxDatabaseError Connect(POD *DB);
  gxDatabaseError Connect(const POD *DB);
  __UWORD__ StringFileLength(const char *s);
  __UWORD__ StringFileLength(char *s); 
  gxDatabaseError WriteString(const char *s, FAU file_address = (FAU_t)-1);
  gxDatabaseError WriteString(char *s, FAU file_address = (FAU_t)-1);
  char *ReadString(FAU file_address = (FAU_t)-1);
  
  // Index file functions
  int AddKey(DatabaseKeyB &key, DatabaseKeyB &compare_key,
	     unsigned index_number = 0, int flush = 1);
  int FindKey(DatabaseKeyB &key, DatabaseKeyB &compare_key,
	      unsigned index_number = 0, int test_tree = 1);
  int DeleteKey(DatabaseKeyB &key, DatabaseKeyB &compare_key,
		unsigned index_number = 0, int flush = 1);
  
public: // User interface
  int WriteObject(int find = 1);
  int ReadObject(FAU object_address);
  int ReadObject();
  int FindObject() { return Find(); }
  int DeleteObject(FAU object_address);
  int DeleteObject() { return Delete(); }
  FAU ObjectAddress() { return objectaddress; }
  int UsingIndex() { return pod->UsingIndex() == 1; }
  int UsingIndex() const { return pod->UsingIndex() == 1; }
  
protected:
  POD *pod; // Pointer to the current POD manager
  gxObjectID objectaddress; // Data file address of this object
};

#endif // __GX_DATABASE_PERSISTENT_BASE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
