unit UnitM;

// 2 properties
  // Help1.TopicId : string;  (after HH..returns ever '';
  // Help1.LinkId  : string;  (after HH..returns ever '';

// 5 procedure Help1.HHJump;
             //      HHDirect(Sender);
             //      HHTOC;
             //      HHKey(Keyword);  //(:string)
             //      HHQuit; in Form close
             // Apps F1 is also HHJump with active Form as TopicId automaticly
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Menus, ComCtrls, ImgList, ToolWin, StdCtrls, MAUSHelp5;

type
  TFormM = class(TForm)

    Help1      : TMAUSHelp;
    ImageList1 : TImageList;
    MainMenu1  : TMainMenu;

     IFile     : TMenuItem;
      IForm1   : TMenuItem;
      IForm2   : TMenuItem;
      IForm3   : TMenuItem;
      N1       : TMenuItem;
      IExit    : TMenuItem;

     IHelp     : TMenuItem;
      IApps    : TMenuItem;
      IDirect  : TMenuItem;
      N2       : TMenuItem;
      ITOC     : TMenuItem;
      IKey     : TMenuItem;

    ToolBar1   : TToolBar;
     BExit     : TToolButton;
     BApps     : TToolButton;
     BDirect   : TToolButton;
     BTOC      : TToolButton;
     BKey      : TToolButton;
     HomeBtn   : TToolButton;
     MailBtn   : TToolButton;
     S1        : TToolButton;
     S2        : TToolButton;
     S3        : TToolButton;
     Keyword   : TEdit;
                          

    procedure FormClose     (Sender: TObject; var Action: TCloseAction);
    // close Apps
    procedure BExitClick    (Sender: TObject);

    // normally functions
    procedure BAppsClick    (Sender: TObject);
    procedure BDirectClick  (Sender: TObject);
    procedure IHelpClick    (Sender: TObject);
    // additional functions
    procedure BTOCClick     (Sender: TObject);
    procedure BKeyClick     (Sender: TObject);

    // Child's
    procedure IForm1Click   (Sender: TObject);
    procedure IForm2Click   (Sender: TObject);
    procedure IForm3Click   (Sender: TObject);


  private

  public

  end;

var
  FormM: TFormM;

implementation


uses Unit1, Unit2, Unit3;



{$R *.dfm}

// Close -----------------------------------------------------------------------


procedure TFormM.FormClose(Sender: TObject; var Action: TCloseAction);
begin                               // ===================
  Help1.HHQuit;        // <------   // do not forget in D5, in D6,7 do not use
end;                                // ===================

procedure TFormM.BExitClick(Sender: TObject);
begin
  Close;
end;

// normally ====================================================================

// Jump - is the same function as Key F1 ---------------------------------------
                                //======
procedure TFormM.BAppsClick(Sender: TObject);  // also from IApps.Item
begin           // TopidId. by default  = Screen.ActiveForm.Name such F1
  Toolbar1.SetFocus;  // or Form.HelpContext > Help1.StartHelpContext = 'TOPIC' + HelpContext
  Help1.HHJump;       // is there no ActiveForm avaiable or not correct,
end;                  // then set manually for example like these:
                      //    Help1.TopicId := LMDFormDisplay1.ActiveForm.Name;
                      //    Help1.HHJump;
                      // or set manually as 'Constants' like these:
                      //    Help1.TopicId := 'MyTopic';
                      //    Help1.HHJump;

// Note: Toolbar1.SetFocus;
// is for set Screen.ActiveForm. Is there any Childwindow.Visible
// then the Focus where ever of the Childwindow, when the Button is clicked
// and the Help for the Main does not show, but the Help for the activ child.
// These problem is only in MDI-Apps not in SDI-Apps.

// Direct Help -----------------------------------------------------------------

procedure TFormM.BDirectClick(Sender: TObject);  // also from IDirect.Item
begin // is TopicId. by default = ActiveFormName + LinkId. by default = Componentname
      // or Component.HelpContext > Help1.StartHelpContext = 'TOPIC' + HelpContext

  Help1.HHDirect(BDirect); // <--- (Sender) is for Set Btn Down/Up automatic.
end;          //=========  // Note: in these case "BDirect", because event from
                           //       Menu.Item IDirect is also "BDirectClick".
                           //       in other cases set Help1.HHDirect(Sender);

// only for Item IDirect set of Checked

procedure TFormM.IHelpClick(Sender: TObject);
begin
  IDirect.Checked := BDirect.Down;      // only for Checked Direct_Item
end;



// additional ==================================================================

// Table of Contents -----------------------------------------------------------

procedure TFormM.BTOCClick(Sender: TObject); // also from ITOC.Item
begin
  Help1.HHTOC;                      // Change simply to Table of Contents
end;

// Index Tab. ------------------------------------------------------------------

procedure TFormM.BKeyClick(Sender: TObject);  // also from IKey.Item
begin
  Help1.HHKey(Keyword.Text);        // Index .hhk (not automaticly in Topic)
end;



// Child's /////////////////////////////////////////////////////////////////////

procedure TFormM.IForm1Click(Sender: TObject);
begin
  TForm1.Create(self);
end;

procedure TFormM.IForm2Click(Sender: TObject);
begin
  TForm2.Create(self);
end;

procedure TFormM.IForm3Click(Sender: TObject);
begin
  TForm3.Create(self);
end;

end.


