unit Unit1;
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MIDIRead, MIDIWrite, StdCtrls, ComCtrls, ExtCtrls;
type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel; Button1: TButton;
    Panel3: TPanel; UpDown1: TUpDown;   Edit8: TEdit; Label8: TLabel;
    Label9: TLabel; Edit9: TEdit;

    procedure Button1Click(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;
  transpose:integer;
implementation
{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  Tracks,Ticks,trk:word;
  Delta:cardinal;
  SMFType,Status,Byte1,Byte2,Meta:byte;
  InputSMFName, OutputSMFName, MsgString: ansistring;
begin
  if opendialog1.execute then InputSMFName := opendialog1.filename;
  if InputSMFName='' then Abort;
  OutputSMFName:='T.mid';
  ReadSMF(InputSMFName);
        ReadSMFHeader(SMFType,Tracks,Ticks);
        WriteSMFHeader(SMFType,Tracks,Ticks);
  for trk := 1 to Tracks do
  begin
    ReadTrackHeader;
    WriteTrackHeader;
    repeat {until TrackEmpty}
      ReadMIDIEvent(Delta,Status,Byte1,Byte2,Meta,MsgString);
      {Transposition; filtering out drums (channel $9)
      and notes outside the interval 0<=note<=127}
      if (((Status shr 4) in [$8,$9])and((Status and $F)<>$9)) then
      begin
       if (((Byte1+transpose)<0) or ((Byte1+transpose)>127)) then
        begin
        ShowMessage('Cannot transpose: notes get out of the 0-127 range'); Abort;
        end
        else
        Byte1:=Byte1+transpose;
      end;
      if (not(Meta=$2F)) //End of track treated separately//
      then WriteMIDIEvent(Delta,Status,Byte1,Byte2,Meta,MsgString);
      VerifyEndOfTrack;
    until TrackEmpty;
    WriteEndOfTrack; //End of track treated separately//
  end; {trk}
  VerifyEndOfSMF;
WriteSMF(OutputSMFName);
Edit9.Text:='Transposed melody saved in T.MID';
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
Edit9.Text:='Reload input file to transpose';
transpose:=UpDown1.Position;
Edit8.Text:=Format('%d',[transpose]);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
transpose:=0;
Edit8.Text:='0';
end;
end.

