unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, UProt4Delphi, Buttons;

type
  TForm1 = class(TForm)
    Prot4Delphi1: TProt4Delphi;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Edit2: TEdit;
    OkBtn: TBitBtn;
    Label4: TLabel;
    lblRegState: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure ShowActualRegistrationState;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.FormCreate(Sender: TObject);
begin
  // Start protection checking.
  Prot4Delphi1.Start;
  // Show registration code to the user.
  Edit1.Text := Prot4Delphi1.RegistrationCode;
  // Show actual reg state. (Registered/Not Registered)
  ShowActualRegistrationState;
end;



procedure TForm1.ShowActualRegistrationState;
begin
  // Inform the registration state of the program
  if Prot4Delphi1.IsRegistered then
    lblRegState.Caption := 'This program is registered'
  else
  begin
    lblRegState.Caption := 'This program is not registered';
    Label3.Caption := 'Disabled';
    Label3.Font.Color := clBlack;
    Image1.Visible := False;
    Label4.Caption := 'Disabled';
    Label4.Font.Color := clBlack;
    Image2.Visible := False;
    Exit; // Testing supported capabilities has no sense if not registered.
  end;
  // PLEASE NOTE THAT THE USAGE OF UNLOCK LEVELS
  // IS >>>VERY<<< SIMPLE.
  // We just use SupportedCapabilities property.
  if Prot4Delphi1.SupportedCapabilities[1] then
  begin
    Label3.Caption := 'Enabled';
    Label3.Font.Color := clLime;
    Image1.Visible := True;
  end
  else
  begin
    Label3.Caption := 'Disabled';
    Label3.Font.Color := clBlack;
    Image1.Visible := False;
  end;

  if Prot4Delphi1.SupportedCapabilities[2] then
  begin
    Label4.Caption := 'Enabled';
    Label4.Font.Color := clLime;
    Image2.Visible := True;
  end
  else
  begin
    Label4.Caption := 'Disabled';
    Label4.Font.Color := clBlack;
    Image2.Visible := False;
  end;
end;


procedure TForm1.OkBtnClick(Sender: TObject);
begin
  // Set the actual registration key.
  Prot4Delphi1.SetRegistrationKey(Edit2.Text);
  // Show actual registration state.
  ShowActualRegistrationState;
end;

end.
