//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <stdlib.h>
#pragma hdrstop

#include "Unit1.h"
#include "CreateGraphics.hpp"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Randomize();
  RichViewEdit1->LoadRVF(ExtractFilePath(Application->ExeName)+"demo.rvf");
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
// This event occurs when reading RVF files.
// Image file name is stored in the Name parameter.
// This event load this image from the Images subdirectory.
void __fastcall TForm1::RichViewEdit1RVFPictureNeeded(TCustomRichView *Sender,
	AnsiString Name, int Tag, TGraphic *&gr)
{
  Name = ExtractFilePath(Application->ExeName)+"Images\\"+Name;
  TPicture* pic = new TPicture;
  try
  {
    try
    {
      pic->LoadFromFile(Name);
    }
    catch(...)
    {
      pic->Assign(RVStyle1->InvalidPicture);
    }
    gr = GetGraphicCopy(pic->Graphic); // from CreateGraphics unit
    gr->Assign(pic->Graphic);
  }
  catch(...)
  {
  }
  delete pic;
}
//---------------------------------------------------------------------------
// Inserting image.
// If this image is not from the Images subdirectory, copying it there
// (under an unique file name)
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
    try
    {
      TPicture* pic = new TPicture;
      try
      {
        pic->LoadFromFile(OpenDialog1->FileName);
        TGraphic* gr = GetGraphicCopy(pic->Graphic); // from CreateGraphics unit
        gr->Assign(pic->Graphic);
        AnsiString ImageName = ExtractFileName(CopyImageToTheImagesDir(OpenDialog1->FileName, NULL));
        RichViewEdit1->InsertPicture(ImageName, gr, rvvaBaseline);
      }
      catch(...)
      {
      }
      delete pic;
    }
    catch(...)
    {
      Application->MessageBox("Image loading error", "Error", 0);
    }

}
//---------------------------------------------------------------------------
// Copying the file ImageFileName to the images subdirectory (if gr==NULL)
// or saving gr in the images subdirectory.
// Assigning an unique file name.
AnsiString TForm1::CopyImageToTheImagesDir(AnsiString ImageFileName, TGraphic* gr)
{
  AnsiString ImagesDir, NewImageFileName, ImageExt;
  int RandomValue;

  ImageFileName = AnsiLowerCase(ImageFileName);
  ImagesDir = AnsiLowerCase(ExtractFilePath(Application->ExeName)+"Images\\");
  if (ImageFileName.Pos(ImagesDir)!=1)
  {
    NewImageFileName = ImagesDir+ExtractFileName(ImageFileName);
    if (FileExists(NewImageFileName))
    {
      ImageExt = ExtractFileExt(NewImageFileName);
      NewImageFileName = NewImageFileName.SubString(1, NewImageFileName.Length()-ImageExt.Length());
      RandomValue = random(MaxInt);
      while (FileExists(NewImageFileName+IntToStr(RandomValue)+ImageExt))
        RandomValue++;
      NewImageFileName = NewImageFileName+IntToStr(RandomValue)+ImageExt;
    }
    if (!gr)
      CopyFile(ImageFileName.c_str(), NewImageFileName.c_str(), false);
    else
      gr->SaveToFile(NewImageFileName);
    return NewImageFileName;
  }
  else
    return ImageFileName;
}
//---------------------------------------------------------------------------
// Saving all images that not in the images directory
// Such images can appear when loading or pasting files with images
void TForm1::SaveAllUnknownImages(TCustomRVData* RVData)
{
  for (int i=0; i<RVData->ItemCount; i++)
    switch (RVData->GetItemStyle(i))
    {
      case rvsPicture:
      case rvsHotPicture:
      {
        AnsiString ImageFileName = ExtractFilePath(Application->ExeName)+"Images\\"+RVData->GetItemText(i);
        if (!FileExists(ImageFileName))
        {
          TRVVAlign VAlign;
          TGraphic* gr;
          AnsiString s, Ext;
          RVData->GetPictureInfo(i, s, gr, VAlign, Tag);
          Ext = GetGraphicExtension(gr); // from CreateGraphics unit
          RVData->SetItemText(i, ExtractFileName(CopyImageToTheImagesDir("Image."+Ext, gr)));
        }
        break;
      }
      case rvsTable:
      {
        TRVTableItemInfo* table = (TRVTableItemInfo*)(RVData->GetItem(i));
        for (int r=0; r<table->Rows->Count; r++)
          for (int c=0; c<table->Rows->Items[r]->Count; c++)
            if (table->Cells[r][c])
              SaveAllUnknownImages(table->Cells[r][c]->GetRVData());
        break;
      }
    }
}
//---------------------------------------------------------------------------
// Before copying to the clipboard
void __fastcall TForm1::RichViewEdit1Copy(TObject *Sender)
{
  SaveAllUnknownImages(RichViewEdit1->RVData);	
}
//---------------------------------------------------------------------------
// Loading doc
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  if (OpenDialog2->Execute())
  {
    if (!RichViewEdit1->LoadRVF(OpenDialog2->FileName))
      Application->MessageBox("Document loading error", "Error", 0);
    RichViewEdit1->Format();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (SaveDialog1->Execute())
  {
    SaveAllUnknownImages(RichViewEdit1->RVData);
    if (!RichViewEdit1->SaveRVF(SaveDialog1->FileName, false))
      Application->MessageBox("Document saving error", "Error", 0);
  }
}
//---------------------------------------------------------------------------
