unit Unit1;

interface

{------------------------------------------------------------------------------}
{ Important settings:
  rvoTagsArePChars in RichViewEdit1.Options
{------------------------------------------------------------------------------}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RVStyle, RVScroll, RichView, RVEdit, RVTable, CRVData, RVERVData;

type
  TForm1 = class(TForm)
    RichViewEdit1: TRichViewEdit;
    RVStyle1: TRVStyle;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Button3: TButton;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure RichViewEdit1Change(Sender: TObject);
  private
    { Private declarations }
    Freeze: Boolean;
    procedure InsertField(const field, value: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;



implementation

function GetFieldLocation(RootRVData: TCustomRVData; const field: String;
                           var RVData: TCustomRVData;
                           var ItemNo: Integer): Boolean;
var i,r,c: Integer;
    table: TRVTableItemInfo;
begin
  Result := False;
  for i := 0 to RootRVData.ItemCount-1 do
    if RootRVData.GetItemStyle(i)=rvsTable then begin
      table := TRVTableItemInfo(RootRVData.GetItem(i));
      for r := 0 to table.Rows.Count-1 do
        for c := 0 to table.Rows[r].Count-1 do
          if table.Cells[r,c]<>nil then begin
            Result := GetFieldLocation(table.Cells[r,c].GetRVData, field, RVData, ItemNo);
            if Result then
              exit;
          end
      end
    else if PChar(RootRVData.GetItemTag(i)) = field then begin
      ItemNo := i;
      RVData := RootRVData.GetSourceRVData;
      Result := True;
      exit;
    end;
end;

function GetFieldValue(rv: TCustomRichView; const field: String): String;
var ItemNo: Integer;
    RVData: TCustomRVData;
begin
  if GetFieldLocation(rv.RVData, field, RVData, ItemNo) then
    Result := RVData.GetRVData.GetItemTextA(ItemNo)
  else
    Result := '';
end;

procedure SetFieldValue(rv: TCustomRichViewEdit; const field, value: String);
var ItemNo: Integer;
    RVData: TCustomRVData;
    Ctrl: TWinControl;
    AutoSelect: Boolean;
begin
  if GetFieldLocation(rv.RVData, field, RVData, ItemNo) then begin
    if RVData.GetRVData is TRVTableCellData then begin
      ctrl := GetParentForm(rv).ActiveControl;
      TRVTableCellData(RVData).Edit;
      AutoSelect := False;
      if (ctrl<>nil) and (ctrl is TEdit) then begin
        AutoSelect := TEdit(ctrl).AutoSelect;
        TEdit(ctrl).AutoSelect := False;
      end;
      GetParentForm(rv).ActiveControl := ctrl;
      if (ctrl<>nil) and (ctrl is TEdit) then
        TEdit(ctrl).AutoSelect := AutoSelect;
    end;
    if RVData.GetRVData is TRVEditRVData then
      (TRVEditRVData(RVData.GetRVData).RichView as TCustomRichViewEdit).SetItemTextEd(ItemNo, value);
  end;
end;


{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var table: TRVTableItemInfo;
begin
  RichViewEdit1.Clear;
  table := TRVTableItemInfo.CreateEx(1,2,RichViewEdit1.RVData);
  table.Cells[0,0].Clear;
  table.Cells[0,0].AddNL('Name: ',0,1);
  table.Cells[0,0].AddNLTag(Edit1.Text,6,-1,Integer(StrNew('name')));
  table.Cells[0,1].Clear;
  table.Cells[0,1].AddNL('Date: ',0,1);
  table.Cells[0,1].AddNLTag(Edit2.Text,6,-1,Integer(StrNew('date')));
  table.BorderWidth := 1;
  table.CellBorderWidth := 1;  
  RichViewEdit1.AddItem('',table);
  RichViewEdit1.Format;
end;

procedure TForm1.InsertField(const field, value: String);
var StyleNo: Integer;
begin
  if GetFieldValue(RichViewEdit1, field)<>'' then begin
    Application.MessageBox('Field already exists!','', 0);
    exit;
  end;
  StyleNo := RichViewEdit1.CurTextStyleNo;
  RichViewEdit1.CurTextStyleNo := 6;
  RichViewEdit1.InsertStringTag(value, Integer(StrNew(PChar(field))));
  RichViewEdit1.CurTextStyleNo := StyleNo;
  RichViewEdit1.SetFocus;
end;


procedure TForm1.Button1Click(Sender: TObject);

begin
  InsertField('name', Edit1.Text);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  InsertField('date', Edit2.Text);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  RichViewEdit1.ApplyTextStyle(0);
  RichViewEdit1.SetFocus;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    SetFieldValue(RichViewEdit1, 'name', Edit1.Text);
  finally
    Freeze := False;
  end;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    SetFieldValue(RichViewEdit1, 'date', Edit2.Text);
  finally
    Freeze := False;
  end;
end;

procedure TForm1.RichViewEdit1Change(Sender: TObject);
var s: String;
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    s := GetFieldValue(RichViewEdit1, 'name');
    if s<>'' then
      Edit1.Text := s;
    s := GetFieldValue(RichViewEdit1, 'date');
    if s<>'' then
      Edit2.Text := s;
  finally
    Freeze := False;
  end;
end;



end.
