// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RVRTF.pas' rev: 4.00

#ifndef RVRTFHPP
#define RVRTFHPP

#pragma delphiheader begin
#pragma option push -w-
#include <RVRTFErr.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <RVClasses.hpp>	// Pascal unit
#include <RVFuncs.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rvrtf
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TRVRTFPosition { rtf_ts_ContinuePara, rtf_ts_NewLine, rtf_ts_NewPara };
#pragma option pop

class DELPHICLASS TRVRTFReader;
typedef void __fastcall (__closure *TRVRTFNewTextEvent)(TRVRTFReader* Sender, const AnsiString Text, 
	TRVRTFPosition Position);

typedef void __fastcall (__closure *TRVRTFNewUnicodeTextEvent)(TRVRTFReader* Sender, const WideString 
	Text, TRVRTFPosition Position);

#pragma option push -b-
enum TRVRTFPictureType { rtf_pict_EMF, rtf_pict_PNG, rtf_pict_JPEG, rtf_pict_MacPict, rtf_pict_PmMetafile, 
	rtf_pict_WMF, rtf_pict_DIB, rtf_pict_DDB };
#pragma option pop

class DELPHICLASS TRVRTFPicture;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFPicture : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFPictureType FType;
	int FMetafileMapMode;
	int FPicW;
	int FPicH;
	int FWBMWidthBytes;
	
public:
	Classes::TMemoryStream* FData;
	__fastcall TRVRTFPicture(void);
	__fastcall virtual ~TRVRTFPicture(void);
	__property int PicW = {read=FPicW, nodefault};
	__property int PicH = {read=FPicH, nodefault};
	__property TRVRTFPictureType PicType = {read=FType, nodefault};
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFTableEventKind { rvf_tbl_TableStart, rvf_tbl_TableEnd, rvf_tbl_RowEnd, rvf_tbl_CellEnd };
	
#pragma option pop

typedef void __fastcall (__closure *TRVRTFTableEvent)(TRVRTFReader* Sender, TRVRTFTableEventKind WhatHappens
	);

typedef void __fastcall (__closure *TRVRTFNewPictureEvent)(TRVRTFReader* Sender, TRVRTFPicture* RTFPicture
	, Graphics::TGraphic* Graphic, TRVRTFPosition Position);

#pragma option push -b-
enum TRVRTFAlignment { rtf_al_Left, rtf_al_Right, rtf_al_Center, rtf_al_Justify };
#pragma option pop

#pragma option push -b-
enum TRVRTFVAlign { rtf_val_Top, rtf_val_Bottom, rtf_val_Center };
#pragma option pop

#pragma option push -b-
enum TRVRTFSScriptType { rtf_ss_Normal, rtf_ss_Subscript, rtf_ss_Superscript };
#pragma option pop

#pragma option push -b-
enum TRVRTFFontStyleEx { rtf_fs_AllCaps };
#pragma option pop

typedef Set<TRVRTFFontStyleEx, rtf_fs_AllCaps, rtf_fs_AllCaps>  TRVRTFFontStylesEx;

class DELPHICLASS TRVRTFCharProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFCharProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool FHidden;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	int FFontIndex;
	Graphics::TFontStyles FStyle;
	TRVRTFFontStylesEx FStyleEx;
	int FCharScaleX;
	TRVRTFSScriptType FSScriptType;
	int FCharSpacingTw;
	
public:
	__fastcall TRVRTFCharProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFCharProperties* Source);
	__property int Size = {read=FSize, nodefault};
	__property Graphics::TColor Color = {read=FColor, nodefault};
	__property Graphics::TColor BackColor = {read=FBackColor, nodefault};
	__property int FontIndex = {read=FFontIndex, nodefault};
	__property Graphics::TFontStyles Style = {read=FStyle, nodefault};
	__property TRVRTFFontStylesEx StyleEx = {read=FStyleEx, nodefault};
	__property int CharScaleX = {read=FCharScaleX, nodefault};
	__property TRVRTFSScriptType SScriptType = {read=FSScriptType, nodefault};
	__property int CharSpacingTw = {read=FCharSpacingTw, nodefault};
	__property bool Hidden = {read=FHidden, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVRTFCharProperties(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFBorderType { rtf_brdr_None, rtf_brdr_SingleThickness, rtf_brdr_DoubleThickness, rtf_brdr_Shadow, 
	rtf_brdr_Double, rtf_brdr_Dot, rtf_brdr_Dash, rtf_brdr_Hairline, rtf_brdr_DashSmall, rtf_brdr_DotDash, 
	rtf_brdr_DotDotDash, rtf_brdr_Triple, rtf_brdr_ThickThinSmall, rtf_brdr_ThinThickSmall, rtf_brdr_ThinThickThinSmall, 
	rtf_brdr_ThickThinMed, rtf_brdr_ThinThickMed, rtf_brdr_ThinThickThinMed, rtf_brdr_ThickThinLarge, rtf_brdr_ThinThickLarge, 
	rtf_brdr_ThinThickThinLarge, rtf_brdr_Wavy, rtf_brdr_DoubleWavy, rtf_brdr_Striped, rtf_brdr_Emboss, 
	rtf_brdr_Engrave, rtf_brdr_Inset, rtf_brdr_Outset };
#pragma option pop

#pragma option push -b-
enum TRVRTFSide { rtf_side_Left, rtf_side_Top, rtf_side_Right, rtf_side_Bottom };
#pragma option pop

class DELPHICLASS TRVRTFBorderSide;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFBorderSide : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFBorderType FBorderType;
	int FWidthTw;
	Graphics::TColor FColor;
	int FSpaceTw;
	
public:
	void __fastcall Assign(TRVRTFBorderSide* Source);
	__property TRVRTFBorderType BorderType = {read=FBorderType, nodefault};
	void __fastcall Reset(void);
	__property int WidthTw = {read=FWidthTw, nodefault};
	__property Graphics::TColor Color = {read=FColor, nodefault};
	__property int SpaceTw = {read=FSpaceTw, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFBorderSide(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVRTFBorderSide(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFParaBorder;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFParaBorder : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFBorderSide* FSides[4];
	TRVRTFBorderSide* __fastcall GetSides(TRVRTFSide Index);
	
public:
	void __fastcall Assign(TRVRTFParaBorder* Source);
	__fastcall virtual ~TRVRTFParaBorder(void);
	void __fastcall Reset(void);
	__property TRVRTFBorderSide* Sides[TRVRTFSide Index] = {read=GetSides};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFParaBorder(void) : System::TObject() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFParaProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFParaProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FLeftIndentTw;
	int FRightIndentTw;
	int FFirstIndentTw;
	int FSpaceBeforeTw;
	int FSpaceAfterTw;
	TRVRTFAlignment FAlignment;
	TRVRTFParaBorder* FBorder;
	TRVRTFSide FCurBorderSide;
	int FLineSpacing;
	bool FLineSpacingMulti;
	Graphics::TColor FColor;
	int FNestingLevel;
	bool FInTable;
	bool NoTableEv;
	bool NoResetLev;
	TRVRTFParaBorder* __fastcall GetBorder(void);
	
public:
	__fastcall TRVRTFParaProperties(void);
	__fastcall virtual ~TRVRTFParaProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFParaProperties* Source);
	bool __fastcall HasBorder(void);
	__property int LeftIndentTw = {read=FLeftIndentTw, nodefault};
	__property int RightIndentTw = {read=FRightIndentTw, nodefault};
	__property int FirstIndentTw = {read=FFirstIndentTw, nodefault};
	__property int SpaceBeforeTw = {read=FSpaceBeforeTw, nodefault};
	__property int SpaceAfterTw = {read=FSpaceAfterTw, nodefault};
	__property TRVRTFAlignment Alignment = {read=FAlignment, nodefault};
	__property TRVRTFParaBorder* Border = {read=GetBorder};
	__property Graphics::TColor Color = {read=FColor, nodefault};
	__property int LineSpacing = {read=FLineSpacing, nodefault};
	__property bool LineSpacingMulti = {read=FLineSpacingMulti, nodefault};
	__property int NestingLevel = {read=FNestingLevel, nodefault};
	__property bool InTable = {read=FInTable, nodefault};
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFCellMerge { rtf_cm_None, rtf_cm_First, rtf_cm_Merged };
#pragma option pop

class DELPHICLASS TRVRTFCellProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFCellProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFCellMerge FHMerge;
	TRVRTFCellMerge FVMerge;
	bool InvertWidth;
	int FBestWidth;
	Graphics::TColor FColor;
	TRVRTFVAlign FVAlign;
	TRVRTFParaBorder* FBorder;
	TRVRTFSide FCurBorderSide;
	int FRightBoundaryTw;
	
public:
	int BestHeight;
	__fastcall TRVRTFCellProperties(void);
	__fastcall virtual ~TRVRTFCellProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFCellProperties* Source);
	__property TRVRTFCellMerge HMerge = {read=FHMerge, nodefault};
	__property TRVRTFCellMerge VMerge = {read=FVMerge, nodefault};
	__property int BestWidth = {read=FBestWidth, nodefault};
	__property Graphics::TColor Color = {read=FColor, nodefault};
	__property TRVRTFVAlign VAlign = {read=FVAlign, nodefault};
	__property TRVRTFParaBorder* Border = {read=FBorder};
	__property int RightBoundaryTw = {read=FRightBoundaryTw, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TRVRTFCellPropsList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFCellPropsList : public Rvclasses::TRVList 
{
	typedef Rvclasses::TRVList inherited;
	
private:
	HIDESBASE TRVRTFCellProperties* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVRTFCellProperties* Value);
	
public:
	void __fastcall AddNew(void);
	void __fastcall AssignItems(TRVRTFCellPropsList* Source);
	__property TRVRTFCellProperties* Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	#pragma option push -w-inl
	/* TRVList.Destroy */ inline __fastcall virtual ~TRVRTFCellPropsList(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFCellPropsList(void) : Rvclasses::TRVList() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFRowProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFRowProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool InvertWidth;
	int FGapHTw;
	int FLeftTw;
	int FHeightTw;
	int FPaddingTw[4];
	int FSpacingTw[4];
	bool FUsePadding[4];
	bool FUseSpacing[4];
	int FBestWidth;
	TRVRTFAlignment FAlignment;
	TRVRTFParaBorder* FBorder;
	TRVRTFSide FCurBorderSide;
	TRVRTFCellPropsList* FCellProps;
	int __fastcall GetPaddingTw(TRVRTFSide Index);
	int __fastcall GetSpacingTw(TRVRTFSide Index);
	bool __fastcall GetUsePadding(TRVRTFSide Index);
	bool __fastcall GetUseSpacing(TRVRTFSide Index);
	TRVRTFCellProperties* __fastcall GetLastCellProp(void);
	
public:
	bool RichViewSpecial;
	__fastcall TRVRTFRowProperties(void);
	__fastcall virtual ~TRVRTFRowProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFRowProperties* Source);
	__property TRVRTFCellPropsList* CellProps = {read=FCellProps};
	__property int GapHTw = {read=FGapHTw, nodefault};
	__property int LeftTw = {read=FLeftTw, nodefault};
	__property TRVRTFAlignment Alignment = {read=FAlignment, nodefault};
	__property int HeightTw = {read=FHeightTw, nodefault};
	__property int BestWidth = {read=FBestWidth, nodefault};
	__property int PaddingTw[TRVRTFSide Index] = {read=GetPaddingTw};
	__property int SpacingTw[TRVRTFSide Index] = {read=GetSpacingTw};
	__property bool UsePadding[TRVRTFSide Index] = {read=GetUsePadding};
	__property bool UseSpacing[TRVRTFSide Index] = {read=GetUseSpacing};
	__property TRVRTFParaBorder* Border = {read=FBorder};
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFSectionBreakType { rtf_sbk_None, rtf_sbk_Column, rtf_sbk_Even, rtf_sbk_Odd, rtf_sbk_Page 
	};
#pragma option pop

#pragma option push -b-
enum TRVRTFPageNumberFormat { rtf_pg_Decimal, rtf_pg_UpperRoman, rtf_pg_LowerRoman, rtf_pg_UpperLetter, 
	rtf_pg_LowerLetter };
#pragma option pop

class DELPHICLASS TRVRTFSectionProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFSectionProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FColumnCount;
	TRVRTFSectionBreakType FSectionBreakType;
	int FPageNumberXTw;
	int FPageNumberYTw;
	TRVRTFPageNumberFormat FPageNumberFormat;
	
public:
	__fastcall TRVRTFSectionProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFSectionProperties* Source);
	__property int ColumnCount = {read=FColumnCount, nodefault};
	__property TRVRTFSectionBreakType SectionBreakType = {read=FSectionBreakType, nodefault};
	__property int PageNumberXTw = {read=FPageNumberXTw, nodefault};
	__property int PageNumberYTw = {read=FPageNumberYTw, nodefault};
	__property TRVRTFPageNumberFormat PageNumberFormat = {read=FPageNumberFormat, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVRTFSectionProperties(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFDocProperties;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFDocProperties : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FPaperWidthTw;
	int FPaperHeightTw;
	int FLeftMarginTw;
	int FTopMarginTw;
	int FRightMarginTw;
	int FBottomMarginTw;
	int FPageNumberStart;
	bool FFacingPages;
	bool FLandscape;
	
public:
	__fastcall TRVRTFDocProperties(void);
	void __fastcall Reset(void);
	void __fastcall Assign(TRVRTFDocProperties* Source);
	__property int PaperWidthTw = {read=FPaperWidthTw, nodefault};
	__property int PaperHeightTw = {read=FPaperHeightTw, nodefault};
	__property int LeftMarginTw = {read=FLeftMarginTw, nodefault};
	__property int TopMarginTw = {read=FTopMarginTw, nodefault};
	__property int RightMarginTw = {read=FRightMarginTw, nodefault};
	__property int BottomMarginTw = {read=FBottomMarginTw, nodefault};
	__property int PageNumberStart = {read=FPageNumberStart, nodefault};
	__property bool FacingPages = {read=FFacingPages, nodefault};
	__property bool Landscape = {read=FLandscape, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVRTFDocProperties(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRTFrds { rdsNorm, rdsSkip, rdsFontTable, rdsStyleSheet, rdsColorTable, rdsStyleSheetEntry, rdsPict, 
	rdsField, rdsFldInst };
#pragma option pop

#pragma option push -b-
enum TRTFris { risNorm, risBin, risHex };
#pragma option pop

#pragma option push -b-
enum TRTFIPROP { ipropBold, ipropItalic, ipropUnderline, ipropStrike, ipropCharScaleX, ipropCharSpacing, 
	ipropSScript, ipropAllCaps, ipropFontSize, ipropTextColor, ipropTextBackColor, ipropSL, ipropSLMult, 
	ipropLeftInd, ipropRightInd, ipropFirstInd, ipropCols, ipropPgnX, ipropPgnY, ipropXaPage, ipropYaPage, 
	ipropXaLeft, ipropXaRight, ipropYaTop, ipropYaBottom, ipropPgnStart, ipropSbk, ipropPgnFormat, ipropFacingp, 
	ipropLandscape, ipropJust, ipropPard, ipropPlain, ipropSectd, ipropF, ipropDefF, ipropSpaceBefore, 
	ipropSpaceAfter, ipropParaBorderType, ipropParaBorderSide, ipropParaBorderWidth, ipropParaBorderColor, 
	ipropParaBorderSpace, ipropParaColor, ipropAnsiCodePage, ipropU, ipropUC, ipropPage, ipropField, ipropFldInst, 
	ipropFldRslt, ipropHidden, ipropRed, ipropGreen, ipropBlue, ipropFontFamily, ipropFCharset, ipropS, 
	ipropCS, ipropDS, ipropSBasedOn, irpropSNext, ipropAdditive, ipropSHidden, ipropPicW, ipropPicH, ipropWBMWidthBytes, 
	ipropPictureType, ipropMetafile, ipropRowEnd, ipropCellEnd, ipropInTbl, ipropItap, ipropTRowD, ipropRowAlign, 
	ipropTRGapH, ipropTRLeft, ipropTRRowHeight, ipropTRPaddL, ipropTRPaddR, ipropTRPaddT, ipropTRPaddB, 
	ipropTRPaddFL, ipropTRPaddFR, ipropTRPaddFT, ipropTRPaddFB, ipropTRSpdL, ipropTRSpdR, ipropTRSpdT, 
	ipropTRSpdB, ipropTRSpdFL, ipropTRSpdFR, ipropTRSpdFT, ipropTRSpdFB, ipropTRwWidth, ipropTRftsWidth, 
	ipropCLVMerge, ipropCLHMerge, ipropCLwWidth, ipropCLftsWidth, ipropCLColor, ipropCLVertAl, ipropCellX, 
	ipropTRBorderSide, ipropCLBorderSide, ipropNoTableEv, ipropNoResetLev, ipropRVCellBestWidth, ipropRVCellBestHeight, 
	ipropRVTableBestWidth, ipropMax };
#pragma option pop

#pragma option push -b-
enum TRTFACTN { actnSpec, actnByte, actnWord };
#pragma option pop

#pragma option push -b-
enum TRTFPROPTYPE { propChp, propPap, propSep, propDop };
#pragma option pop

#pragma pack(push, 4)
struct TRTFpropmod
{
	TRTFACTN actn;
	TRTFPROPTYPE prop;
	int offset;
} ;
#pragma pack(pop)

#pragma option push -b-
enum TRTFIPFN { ipfnBin, ipfnHex, ipfnSkipDest };
#pragma option pop

#pragma option push -b-
enum TRTFIDEST { idestPict, idestSkip, idestFontTable, idestStyleSheet, idestColorTable, idestStyleSheetParaStyle, 
	idestStyleSheetCharStyle, idestStyleSheetSectStyle, idestField, idestFldInst, idestFldRslt, idestNestedTableProps 
	};
#pragma option pop

#pragma option push -b-
enum TRVRTFKeywordType { rtf_kwd_Char, rtf_kwd_Dest, rtf_kwd_Prop, rtf_kwd_Spec };
#pragma option pop

#pragma option push -b-
enum TRVRTFKeywordAffect { rtf_af_None, rtf_af_CharProp, rtf_af_ParaProp, rtf_af_BothProp };
#pragma option pop

#pragma pack(push, 4)
struct TRVRTFsymbol
{
	AnsiString Keyword;
	int DefValue;
	bool UseDef;
	TRVRTFKeywordType Kwd;
	int Idx;
	TRVRTFKeywordAffect AffectTo;
} ;
#pragma pack(pop)

typedef TRVRTFsymbol *PRVRTFsymbol;

#pragma option push -b-
enum TRVRTFStyleSheetType { rtf_sst_Char, rtf_sst_Par, rtf_sst_Sect };
#pragma option pop

class DELPHICLASS TRVRTFStyleSheetEntry;
class DELPHICLASS TRVRTFReaderState;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFStyleSheetEntry : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFParaProperties* FParaProps;
	TRVRTFCharProperties* FCharProps;
	bool FAdditive;
	bool FHidden;
	int FNumber;
	TRVRTFStyleSheetType FStyleType;
	TRVRTFStyleSheetEntry* FBasedOn;
	TRVRTFStyleSheetEntry* FNext;
	AnsiString FName;
	
public:
	__fastcall TRVRTFStyleSheetEntry(void);
	__fastcall virtual ~TRVRTFStyleSheetEntry(void);
	void __fastcall Assign(TRVRTFReaderState* Source);
	__property TRVRTFParaProperties* ParaProps = {read=FParaProps};
	__property TRVRTFCharProperties* CharProps = {read=FCharProps};
	__property bool Additive = {read=FAdditive, nodefault};
	__property bool Hidden = {read=FHidden, nodefault};
	__property int Number = {read=FNumber, nodefault};
	__property TRVRTFStyleSheetType StyleType = {read=FStyleType, nodefault};
	__property TRVRTFStyleSheetEntry* BasedOn = {read=FBasedOn};
	__property TRVRTFStyleSheetEntry* Next = {read=FNext};
	__property AnsiString Name = {read=FName};
};

#pragma pack(pop)

class DELPHICLASS TRVRTFStyleSheet;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFStyleSheet : public Rvclasses::TRVList 
{
	typedef Rvclasses::TRVList inherited;
	
private:
	HIDESBASE TRVRTFStyleSheetEntry* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVRTFStyleSheetEntry* Value);
	void __fastcall AddPara(int Number);
	
public:
	TRVRTFStyleSheetEntry* __fastcall GetEntry(int Number);
	__property TRVRTFStyleSheetEntry* Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	#pragma option push -w-inl
	/* TRVList.Destroy */ inline __fastcall virtual ~TRVRTFStyleSheet(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFStyleSheet(void) : Rvclasses::TRVList() { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFFontFamily { rtf_ff_Default, rtf_ff_Roman, rtf_ff_Swiss, rtf_ff_Modern, rtf_ff_Script, rtf_ff_Decorative, 
	rtf_ff_Symbol, rtf_ff_BiDi };
#pragma option pop

class DELPHICLASS TRVRTFFont;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFFont : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int Number;
	AnsiString Name;
	TRVRTFFontFamily Family;
	Graphics::TFontCharset Charset;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFFont(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVRTFFont(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFFontList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFFontList : public Rvclasses::TRVList 
{
	typedef Rvclasses::TRVList inherited;
	
private:
	HIDESBASE TRVRTFFont* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVRTFFont* Value);
	
public:
	int __fastcall GetFontIndex(int Number);
	HIDESBASE void __fastcall Add(int Number);
	__property TRVRTFFont* Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	#pragma option push -w-inl
	/* TRVList.Destroy */ inline __fastcall virtual ~TRVRTFFontList(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFFontList(void) : Rvclasses::TRVList() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRTFColorList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFColorList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	HIDESBASE Graphics::TColor __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const Graphics::TColor Value);
	void __fastcall ResetLast(void);
	void __fastcall SetLastRed(int Value);
	void __fastcall SetLastGreen(int Value);
	void __fastcall SetLastBlue(int Value);
	void __fastcall Finalize(void);
	
public:
	HIDESBASE void __fastcall Add(void);
	__property Graphics::TColor Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TRVRTFColorList(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRTFColorList(void) : Classes::TList() { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVRTFCurrentBorderType { rtf_bt_Para, rtf_bt_Row, rtf_bt_Cell };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFReaderState : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TRVRTFCharProperties* FCharProps;
	TRVRTFParaProperties* FParaProps;
	TRVRTFSectionProperties* FSectProps;
	TRVRTFDocProperties* FDocProps;
	TRVRTFRowProperties* FRowProps;
	TRVRTFCurrentBorderType FCurrentBorderType;
	TRTFrds rds;
	TRTFris ris;
	AnsiString FFieldCode;
	bool FFieldPictureIncluded;
	void __fastcall ChangeFontStyle(Graphics::TFontStyle fs, int Val);
	TRVRTFRowProperties* __fastcall GetRowProps(void);
	TRVRTFBorderSide* __fastcall GetCurrentBorderSide(void);
	
public:
	__fastcall TRVRTFReaderState(void);
	__fastcall virtual ~TRVRTFReaderState(void);
	void __fastcall Assign(TRVRTFReaderState* Source);
	void __fastcall Reset(void);
	__property TRVRTFParaProperties* ParaProps = {read=FParaProps};
	__property TRVRTFCharProperties* CharProps = {read=FCharProps};
	__property TRVRTFSectionProperties* SectProps = {read=FSectProps};
	__property TRVRTFDocProperties* DocProps = {read=FDocProps};
	__property TRVRTFRowProperties* RowProps = {read=GetRowProps};
	__property AnsiString FieldCode = {read=FFieldCode};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRTFReader : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Classes::TStream* Stream;
	int StreamSize;
	int InputStringIndex;
	AnsiString Text;
	AnsiString InputString;
	WideString TextW;
	char LastChar;
	bool UseLastChar;
	TRVRTFNewTextEvent FOnNewText;
	TRVRTFNewUnicodeTextEvent FOnNewUnicodeText;
	TRVRTFNewPictureEvent FOnNewPicture;
	TRVRTFTableEvent FOnTable;
	TRVRTFStyleSheet* FStyleSheet;
	TRVRTFFontList* FFontTable;
	TRVRTFColorList* FColorTable;
	TRVRTFReaderState* FRTFState;
	TRVRTFPicture* FPicture;
	unsigned FDefCodePage;
	unsigned FCodePage;
	int SkipAnsiCount;
	int SkipNext;
	Classes::TNotifyEvent FOnRequiredPageBreak;
	int CurrentNestingLevel;
	int __fastcall FindKeyword(const AnsiString Keyword);
	
protected:
	TRVRTFPosition Position;
	int cGroup;
	Rvclasses::TRVList* SaveList;
	int cbBin;
	int lParam;
	Byte PicHexVal;
	bool PicHexStrt;
	bool fSkipDestIfUnk;
	TextFile fpIn;
	Rvrtferr::TRVRTFErrorCode __fastcall EndGroupAction(TRTFrds rds);
	Rvrtferr::TRVRTFErrorCode __fastcall TranslateKeyword(const AnsiString Keyword, int param, bool fParam
		);
	Rvrtferr::TRVRTFErrorCode __fastcall ParseSpecialProperty(TRTFIPROP iprop, int val);
	Rvrtferr::TRVRTFErrorCode __fastcall ChangeDest(TRTFIDEST idest, int Val);
	Rvrtferr::TRVRTFErrorCode __fastcall ParseSpecialKeyword(TRTFIPFN ipfn);
	Rvrtferr::TRVRTFErrorCode __fastcall ApplyPropChange(TRTFIPROP iprop, int val);
	Rvrtferr::TRVRTFErrorCode __fastcall Parse(void);
	Rvrtferr::TRVRTFErrorCode __fastcall PushRtfState(void);
	Rvrtferr::TRVRTFErrorCode __fastcall PopRtfState(void);
	Rvrtferr::TRVRTFErrorCode __fastcall ParseRtfKeyword(void);
	Rvrtferr::TRVRTFErrorCode __fastcall ParseChar(char ch);
	Rvrtferr::TRVRTFErrorCode __fastcall FlushOutput(TRVRTFPosition &NextPosition);
	Rvrtferr::TRVRTFErrorCode __fastcall OutputChar(char ch, bool ACheckTableEnd, bool ACheckTable);
	Rvrtferr::TRVRTFErrorCode __fastcall InsertExternalPicture(void);
	Rvrtferr::TRVRTFErrorCode __fastcall OutputWideChar(wchar_t ch);
	void __fastcall UngetC(void);
	char __fastcall GetC(void);
	bool __fastcall IsEOF(void);
	Rvrtferr::TRVRTFErrorCode __fastcall DoNewText(TRVRTFPosition Position, TRVRTFPosition &NextPosition
		);
	Rvrtferr::TRVRTFErrorCode __fastcall DoNewPicture(Graphics::TGraphic* gr);
	void __fastcall DoTable(TRVRTFTableEventKind WhatHappens);
	void __fastcall CheckTable(bool AllowEnd);
	
public:
	__fastcall virtual TRVRTFReader(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVRTFReader(void);
	void __fastcall Clear(void);
	Rvrtferr::TRVRTFErrorCode __fastcall ReadFromStream(Classes::TStream* AStream);
	Rvrtferr::TRVRTFErrorCode __fastcall ReadFromFile(const AnsiString AFileName);
	WideString __fastcall AnsiToUnicode(const AnsiString s, unsigned CodePage);
	AnsiString __fastcall UnicodeToAnsi(const WideString s);
	__property TRVRTFStyleSheet* StyleSheet = {read=FStyleSheet};
	__property TRVRTFFontList* FontTable = {read=FFontTable};
	__property TRVRTFColorList* ColorTable = {read=FColorTable};
	__property TRVRTFReaderState* RTFState = {read=FRTFState};
	
__published:
	__property TRVRTFNewTextEvent OnNewText = {read=FOnNewText, write=FOnNewText};
	__property TRVRTFNewUnicodeTextEvent OnNewUnicodeText = {read=FOnNewUnicodeText, write=FOnNewUnicodeText
		};
	__property TRVRTFNewPictureEvent OnNewPicture = {read=FOnNewPicture, write=FOnNewPicture};
	__property TRVRTFTableEvent OnTable = {read=FOnTable, write=FOnTable};
	__property Classes::TNotifyEvent OnRequiredPageBreak = {read=FOnRequiredPageBreak, write=FOnRequiredPageBreak
		};
	__property unsigned DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Rvrtf */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvrtf;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RVRTF
