unit RVGif;

interface

{$DEFINE USEGIFIMAGE}
// Use this define if you want to enable Gif support
// with Anders Melander's TGifImage
// http://www.melander.dk/delphi/gifimage/

implementation

{$IFDEF USEGIFIMAGE}

uses GifImage, Graphics, RVFuncs;

procedure MyAfterImportGraphic(Graphic: TGraphic);
begin
  if Graphic is TGIFImage then
    TGIFImage(Graphic).DrawOptions := TGIFImage(Graphic).DrawOptions-[goAnimate]+[goTransparent];
end;
{------------------------------------------------------------------------------}
// Required for all Delphi/C++Builder, except from D6
// I do not know how to convert this function to C++ code
function MyCreateGraphics(GraphicClass: TGraphicClass): TGraphic;
begin
  if GraphicClass=TGIFImage then  begin
    Result := TGIFImage.Create;
    end
  else
    Result := GraphicClass.Create;
end;
{------------------------------------------------------------------------------}
initialization
  TPicture.RegisterFileFormat('gif','Gif Image',TGifImage);
  RV_CreateGraphics := MyCreateGraphics;
  RV_AfterImportGraphic := MyAfterImportGraphic;
  
{$ENDIF}


end.
