/*********************************************************
* Stickies : E-Mail Note Installer Program  Version 1.6  *
* Written by Steven De Toni                              *
**********************************************************/
#include <windows.h>
#include <ddeml.h>
#include <dde.h>
#include <stdio.h>
#include <string.h>

#include "ddemlfuncs.h"         // DDE connections strings
#include "filefuncs.h"          // export modes
#include "sticky.h"             // sticky data structure
#include "stickyinstaller.h"

// Global Variables
HANDLE HInst         = NULL;
char*  PStickyData   = NULL;
int    StickyDataLen = 0; 

// GLobal DDE server
DWORD DDEHandle = NULL;
HSZ   HDDEService;
HSZ   HDDETopic;
HSZ   HDDEItem;
HCONV HConv     = NULL; // Client connection


// ---------------------------------------------------------------------------

BOOL ExportStickyRecord (char* pFileName, int mode)
{
    FILE* outFile = fopen (pFileName, "wb");

    if (outFile == NULL)
        return FALSE;

    // Save the contents of the sticky to a file 
    switch (mode)
    {
        case RECORDMODE:           
            // Output the data ...
            fwrite (PStickyData, StickyDataLen, 1, outFile);
            break;

        case TEXTMODE:
        default:            
        
            StickyRec* pRec = (StickyRec*) ((char*)PStickyData+strlen(EXPORTVERSION16));
            char*      pStr  = PStickyData+strlen(EXPORTVERSION16)+sizeof(StickyRec);

            // Output the title ...
            if (strlen(pRec->winCaption) > 0)
            {
                fprintf (outFile, "%s\r\n", pRec->winCaption);

                for (int idx = 0; pRec->winCaption[idx] != '\0'; idx++)
                    fprintf (outFile, "-");

                fprintf (outFile, "\r\n");
            }

            // Output the body                        
            fprintf (outFile, "%s", pStr);
    }

    fclose (outFile);
    return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SaveAsStickyRec (char* pFileName)
{
    const char* pExt = ".exp";

    _strlwr (pFileName);
    if (strlen (pFileName) < strlen (pExt))
        return FALSE;

    
    for (int chkIdx = strlen(pExt)-1, fIdx = strlen(pFileName)-1; chkIdx >= 0; chkIdx--, fIdx--)
    {
        if (pExt[chkIdx] != pFileName[fIdx])
            return FALSE;
    }

    return TRUE;
}

// ----------------------------------------------------------------------------

int ExportStickyFile (void)
{
    const int       maxFile       = 1024;
    const char*     pFileTypes    = "Save As Sticky Record File\0*.exp\0"
                                    "Save As Text File\0*.txt\0\0";
    char            Errstr[256]   = "GetSaveFileName returned Error #";
    OPENFILENAME    fileSelect;
    DWORD           Errval;         // Error value
    char            buf[5];         // Error buffer
    char            pFileName[maxFile];

    if (PStickyData == NULL)
        return -1;

    // Reset file select structure
    memset (&fileSelect, 0, sizeof (fileSelect));

    fileSelect.hwndOwner         = NULL;
    fileSelect.lStructSize       = sizeof(OPENFILENAME);
    fileSelect.lpstrFilter       = (LPSTR)pFileTypes;  
    fileSelect.lpstrCustomFilter = NULL;
    fileSelect.nFilterIndex      = 1;
    fileSelect.lpstrFile         = (LPSTR)pFileName;
    fileSelect.nMaxFile          = maxFile;
    fileSelect.lpstrFileTitle    = "";           
    fileSelect.nMaxFileTitle     = 0;
    fileSelect.lpstrInitialDir   = ".\\";            
    fileSelect.lpstrTitle        = "Select File Type To Export";
    fileSelect.Flags             = OFN_HIDEREADONLY  | OFN_OVERWRITEPROMPT | 
                                   OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR;
    fileSelect.lpstrDefExt       = "*.exp";

    if(GetSaveFileName(&fileSelect) != TRUE)
    {
        Errval = CommDlgExtendedError();

        if (Errval != 0)    // 0 value means user selected Cancel
        {
            sprintf(buf,"%ld",Errval);
            strcat(Errstr,buf);
            MessageBox(NULL,Errstr,"- WARNING - Something Weird Ocurred!", MB_OK | MB_ICONSTOP);
        }

        return -1;
    }

    if (SaveAsStickyRec (pFileName) != FALSE)
    {
        if (ExportStickyRecord (pFileName, RECORDMODE) == FALSE)
            return -1;
    }
    else
    {
        if (ExportStickyRecord (pFileName, TEXTMODE) == FALSE)
            return -1;
    }

    return 0;
}

// ----------------------------------------------------------------------------

BOOL DDE_InitClient (void)
{        
    UINT errCode = DdeInitialize (&DDEHandle, (PFNCALLBACK)DDECallback, APPCMD_CLIENTONLY, 0L);
    if (errCode != 0)
    {
        char errTxt[32];

        sprintf (errTxt, "DDE Server Failed, error code = %d", errCode);

        MessageBox (NULL, "ERROR Initialising DDE Server.\r\n"
                          "Server communication is through e-mail is not available.",
                          errTxt, MB_ICONSTOP | MB_OK);
        return FALSE;
    }
    else
    {
        HDDEService = DdeCreateStringHandle (DDEHandle, DDE_SERVICE, CP_WINANSI);
        HDDETopic   = DdeCreateStringHandle (DDEHandle, DDE_TOPIC,   CP_WINANSI);
        HDDEItem    = DdeCreateStringHandle (DDEHandle, DDE_ITEM,    CP_WINANSI);

        DdeNameService (DDEHandle, HDDEService, (HSZ) NULL, DNS_REGISTER);
    }

    return TRUE;
}

// ----------------------------------------------------------------------------

// return values;
// 0  : o.k read of data, PStickData is now not null
// -1 : read error
int LoadStickyData (void)
{
    char  chkBuff[32];
    char  versionID[32];
    int   versionLen = strlen (EXPORTVERSION16);
    int   fileLen    = 0;   
    int   filePos    = 0;
    FILE* pInFile    = NULL;
    int   idx;

    // encrypt version identifier
    strcpy (versionID, EXPORTVERSION16);
    for (idx = 0; idx < versionLen; idx++)
        versionID[idx] = ~versionID[idx] ;

    // open file to start the searching ....
    if ((pInFile = fopen (__argv[0], "rb")) == NULL)
    {
        MessageBox (NULL, "ERROR: Unable to open sticky installer file.\r\n"
                          "Unable to continue installation.",
                          "Installer Read ERROR!", MB_OK);
        return -1;
    }

    // Move to the end of the file and work backwords ...
    fseek (pInFile, 0, SEEK_END);
    fileLen = ftell(pInFile);
    fseek (pInFile, 0, SEEK_SET);

    // Slow but sure memory test
    // Do a read ahead read 
    fread (chkBuff, versionLen, 1, pInFile);    
    for(;;)
    {   
        // Compare memory 
        if ((memcmp (chkBuff, versionID, versionLen)) == 0)
            break;

        // move memory down 1 and tack byte read from file onto
        // the end of the buffer and test again...
        memcpy (chkBuff, chkBuff+1, versionLen-1);
        if (fread (chkBuff+(versionLen-1), 1, 1, pInFile) <= 0)
        {
            filePos = fileLen;
            break;
        }        
    }

    if (filePos >= fileLen)
    {
        MessageBox (NULL, "Installer program was unable to identify\r\n"
                          "Sticky note data hunk.\r\n"
                          "Request another copy of the sticky from the\r\n"
                          "originator.\r\n\r\n"
                          "Sticky Installer is unable to continue.",
                          "Sticky Installer File Search ERROR!",
                          MB_ICONSTOP | MB_OK);
        fclose (pInFile);
        return -1;
    }
    
    // allocate memory 
    StickyDataLen = (fileLen - ftell(pInFile)) + versionLen + 1;

    if ((PStickyData = new char [StickyDataLen]) == NULL)
    {
        MessageBox (NULL, "Memeory allocation error\r\n"
                          "Sticky installer is unable to continue.",
                          "Sticky Installer Memory Allocation ERROR!",
                          MB_ICONSTOP | MB_OK);

        fclose (pInFile);
        return -1;
    }

    // load the rest of the data ...
    strcpy (PStickyData, EXPORTVERSION16);
    fread  (PStickyData + versionLen, (StickyDataLen - versionLen), 1, pInFile);

    // Clean up
    fclose (pInFile);

    return 0;
}

// ----------------------------------------------------------------------------

// return values:
//  0 : O.k transaction
// -1 : DDE not initialised
// -2 : DDE Communication terminated pre-maturaly.
// -3 : No connection
int DDE_Transaction (void)
{    
    HDDEDATA    hData = NULL;
    DWORD       transResult;
    const char* clipboardFormat = "Sticky Data";
    UINT        clipFmtHandle   = 0;

    if ((clipFmtHandle = RegisterClipboardFormat(clipboardFormat)) == 0)
    {
        MessageBox (NULL, "Unable to obtain clipboard format information.\r\n",
                          "Internal Error", MB_ICONSTOP | MB_OK);
        return -1;
    }

    if (DDEHandle == NULL)
        return -1;

    HConv = DdeConnect (DDEHandle, HDDEService, HDDETopic, (PCONVCONTEXT) NULL);

    // Connect to server
    if (HConv == NULL)
    {
        OutputDebugString ("Clnt: Unsuccessful connection.");
        
        int responce = 
        MessageBox (NULL, "DDE Communication To Stickies Application Unsuccessful.\r\n"
                          "This can be due to the Stickies application:\r\n"
                          "        * Currently not running.\r\n"
                          "        * Not installed.\r\n\r\n"
                          "To obtain the lastest version of the Stickies application go to\r\n\r\n"
                          "http://www.geocities.com/SiliconValley/Horizon/2691\r\n\r\n"
                          "Do you wish to export sticky record to a sticky export file?",
                          "Stickies Server Connection Error", MB_ICONINFORMATION | MB_YESNO | MB_TOPMOST);

        if (responce == IDYES)
            return ExportStickyFile ();

        return -3;
    }
    else
        OutputDebugString ("Clnt: Successful connection.");

    if (HConv != NULL)
    {
        if (PStickyData == NULL)
            return -1;

        // Send Data to server
        hData = DdeCreateDataHandle (DDEHandle, 
                                     (BYTE*)PStickyData,  
                                     StickyDataLen, 
                                     0L, 
                                     HDDEItem, 
                                     clipFmtHandle, 
                                     0L);

        if (hData != NULL)
            hData = DdeClientTransaction ((LPBYTE)hData, (DWORD)-1, 
                                          HConv, HDDEItem, 
                                          clipFmtHandle, XTYP_POKE, 
                                          TIMEOUT_ASYNC, 
                                          &transResult);
        else   
            OutputDebugString ( "Could not create data handle." );

        delete[] PStickyData;
        PStickyData = NULL;
    }
    else
    {
        MessageBox (NULL, "Connection between Stickies application was terminated\r\n"
                          "before transaction could be completed.",
                          "Transaction aborted",
                          MB_ICONSTOP | MB_OK);

        OutputDebugString ("Clnt: Transaction could not complete.");
    }

 
    // Disconnect from server
    if (HConv != NULL)
    {
        DdeDisconnect (HConv);
        HConv = NULL;
        OutputDebugString ("Clnt: Disconnected from server.");
    }

    return 0;
}

// ----------------------------------------------------------------------------

void DDE_UninitClient (void)
{
    if (DDEHandle != NULL)
    {
        DdeFreeStringHandle (DDEHandle, HDDEService);
        DdeFreeStringHandle (DDEHandle, HDDETopic);
        DdeFreeStringHandle (DDEHandle, HDDEItem);
        DdeUninitialize     (DDEHandle);
    }
}

// ----------------------------------------------------------------------------

HDDEDATA CALLBACK DDECallback (WORD wType, WORD wFmt,      HCONV hConv,   HSZ   hsz1,
                               HSZ  hsz2,  HDDEDATA hData, DWORD dwData1, DWORD dwData2)
{
    switch (wType)
    {
        case XTYP_DISCONNECT:
            HConv = NULL;
            OutputDebugString ( "The server forced a disconnect." );
            return (HDDEDATA) NULL;
    }
    return (HDDEDATA) NULL;
}

// ----------------------------------------------------------------------------

int WINAPI WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
    static char szAppName[] = "Stickies Installer";

    HInst = hInstance;

    DDE_InitClient ();

    if (LoadStickyData () == 0)
    {
        // Copy sticky info over....
        if (DDE_Transaction () == 0)
            MessageBox (NULL, "Sticky note transfer completed without errors.",
                              "Sticky upload o.k", MB_ICONINFORMATION | MB_OK);
    }

    // Shutdown DDE client
    DDE_UninitClient ();

    return 0;
}