#ifdef UNICODE
error(NOT DESIGNED FOR UNICODE)
#endif

#ifndef WIN32
error(DESIGNED FOR WIN32 ONLY)
#endif

#ifdef __cplusplus
extern "C"
{
#endif

struct str_ima_handle { int unused; }; 
typedef struct str_ima_handle FAR * HIMA;

#define WIMAAPI WINAPI

#ifndef TYPEDISKH
typedef enum
{
  NOTHING=0,
  USED,
  ALL,
  BEGINFLOPPY
} CHOICEAPP;
#endif


#ifndef _INC_DISK

#ifndef MAXLFN
#define MAXLFN 256
#endif

typedef struct
{
  char nom[8];
  char ext[3];
  char szCompactName[13];
  BYTE bAttr;

  BYTE dir_CreateMSec;
  WORD dir_CreateDate;
  WORD DosTime;
  WORD DosDate;

  BOOL fIsSubDir;
  BOOL fSel; // for private use of client app.
  BOOL fLfnEntry;
  DWORD dwSize;
  UINT uiPosInDir;
  DWORD dwLocalisation;
  DWORD dwTrueSize;
  char longname[MAXLFN];
  WORD dir_CreateTime;
  WORD dir_LastAccessDate;
} DIRINFO;
typedef DIRINFO* LPDIRINFO; // for info, huge in win16 WinImage
#endif


#ifndef SORT_NONE
#define SORT_NONE 72
#define SORT_NAME 73
#define SORT_EXT  74
#define SORT_SIZE 75
#define SORT_DATE 76
#endif

#ifndef CDM_ROOT
#define CDM_ROOT  50
#define CDM_UPPER 51
#define CDM_ENTRY 52 // use ChszDir
#endif


typedef enum
{
  NO_FLOPPY=0,
  FLOPPY_360,
  FLOPPY_12M,
  FLOPPY_720,
  FLOPPY_144,
  FLOPPY_288,
  LDISK_REMOVABLE,
  LDISK_HARDDISK,
  LDISK_CDROM,
  FLOPPY_LS120
} DRIVEINFO;

// HWND_NO_PROGRESS : hWnd parameter to ReadImaFile or WriteImaFile to have no
//  WinImage progress bar window
#define HWND_NO_PROGRESS ((HWND)INVALID_HANDLE_VALUE)

// CreateMemFatHima : Create an Image Object.
// you need call ReadImaFile, ReadFloppy or MakeEmptyImage
HIMA WIMAAPI CreateMemFatHima();

// CreateMemHfsHima : Create an Image Object for Mac floppy.
// you need call ReadImaFile, ReadFloppy
// extract, inject... cannot be used
HIMA WIMAAPI CreateMemHfsHima();

// CreateMemHfsHima : Create an Image Object by loading CDRom ISO image
//  lpFn : Filename of .ISO file
//  inject,...cannot be used
HIMA WIMAAPI CreateCDIsoIma(LPCSTR lpFn);

// OpenFatLargeFile : Open a large disk image (hard disk image)
//  hWnd : parent window for progress window
//  lpFn : FileName
//  dwPosFileBegin : position in file (usualy 0)
//  dwPosFileBegin : position in file, high (usualy 0), for file > 4GB
//  fReadOnlyAsked : if the file must be opened in read-only mode
HIMA WIMAAPI OpenFatLargeFile(HWND hWnd,LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);

// DeleteIma : Delete an Image Object.
void WIMAAPI DeleteIma(HIMA);

// Read an image file (.IMA or .IMZ)
//  hWnd : parent window for progress window
//  lpFn : FileName
//  lpfCompr : pointer to Boolean (will receive TRUE if file is compressed)
//  dwPosFileBegin : position in file (usualy 0, except in WLZ)
BOOL WIMAAPI ReadImaFile(HIMA hIma,HWND hWnd,LPCSTR lpFn,
                         LPBOOL lpfCompr,DWORD dwPosFileBegin);

// WriteImaFile : WriteCompressed image
//  hWnd : parent window for progress window
//  lpFn : FileName
//  fTruncate : TRUE if you want truncate unused part of image
//  fCompress : TRUE if you want compress
//  iLevelCompress : used is fCompress is TRUE, level of compress (1 to 9)
//  dwPosBeginWrite : position in file (usualy 0)
//  lpNameInCompr : alternate name in compressed file (can be NULL)
BOOL WIMAAPI WriteImaFile(HIMA hIma,HWND hWnd,LPCSTR lpFn,BOOL fTruncate,
                          BOOL fCompress,int iLevelCompress,
                          DWORD dwPosBeginWrite,LPCSTR lpNameInCompr);

//  ReadFloppy : Read a floppy
//  hWnd : parent window for progress window
//  bFloppy : Floppy to read (0 for A:)
//  caRead : USED, or ALL (ALL if you want read unused part of floppy)
BOOL WIMAAPI ReadFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caRead);

// WriteFloppy : Write a floppy
//  hWnd : parent window for progress window
//  bFloppy : Floppy to write (0 for A:)
//  caFormat : NOTHING or ALL (ALL for format)
//  caWrite : USED or ALL
//  caCompare : NOTHING, USED or ALL
//  fCheckDiskBeforeWrite : if you want check disk is empty
BOOL WIMAAPI WriteFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caFormat,
                        CHOICEAPP caWrite,CHOICEAPP caCompare,
                        BYTE fCheckDiskBeforeWrite);

// Create a directory in the image
//  lpDir : Directory name
BOOL WIMAAPI MkDir(HIMA hIma,LPCSTR lpDir);

// Change current directory by name
//  lpDir : Directory name
BOOL WIMAAPI ChszDir(HIMA hIma,LPCSTR lpDir);

// Change current directory by mode
//  bMode : CDM_ROOT or CDM_UPPER (equiv. to cd \ and cd ..)
BOOL WIMAAPI ChDir(HIMA hIma,BYTE bMode);

// Change current directory by mode
//  bMode : CDM_ROOT or CDM_UPPER or CDM_ENTRY (equiv. to cd \ and cd ..)
BOOL WIMAAPI ChDirPos(HIMA hIma,BYTE bMode,DWORD dwPosDir);

// InjectFile : Inject a file in floppy
//  lpFn : file to inject
//  lpDwSize : Pointer to DWORD that will receive the size. Can be NULL.
//  lpTooBig : Pointer to BOOL, become TRUE if file too big to be injected
//      (if InjectFile return FALSE). Can be NULL.
//  lpNameWhenInjected : if not NULL, contain a new name in the image
//      (if the file must have another name when injected). Can be NULL.
BOOL WIMAAPI InjectFile(HIMA hIma,LPCSTR lpFn,
                        LPDWORD lpDwSize,LPBOOL lpTooBig,
                        LPCSTR lpNameWhenInjected);

// MakeEmptyImage : make an empty image
// iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K
//                  0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-))
BOOL WIMAAPI MakeEmptyImage(HIMA hIma,int iNoTypeDisk);

// InitWimaSdk : Init the DLL and use hinstdll for resource
#define DEBENUSTD "ENU"
#define BASEENUSTD (10000)
BOOL WIMAAPI InitWimaSdk(HINSTANCE hinstdll,LPCSTR lpDeb,WORD wBase);

// GetCurDir : Get the name of current directory
//  lpBuf : buffer that will receive the name
//  uiMaxSize : the size of buffer
BOOL WIMAAPI GetCurDir(HIMA hIma,LPSTR lpBuf,UINT uiMaxSize);

// GetNbEntryCurDir : Get the number of entry of cur directory
DWORD WIMAAPI GetNbEntryCurDir(HIMA hIma);

// GetDirInfo : Get info about the entry of cur directory
//  LPDIRINFO : array of DIRINFO that will receive the info
//                  (use GetNbEntryCurDir for know the size needed)
//  bSort :     specify how the file must be sort
//          (SORT_NONE, SORT_NAME, SORT_EXT, SORT_SIZE or SORT_DATE)
BOOL WIMAAPI GetDirInfo(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);

// Sort : Resort the array obtained by GetDirInfo
BOOL WIMAAPI Sort(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);

// GetLabel : Get the label of Image
//  lpBuf : will receive the label
BOOL WIMAAPI GetLabel(HIMA hIma,LPSTR lpBuf);

// SetLabel : Set the label of Image
//  lpBuf : contain the new label
BOOL WIMAAPI SetLabel(HIMA hIma,LPCSTR lpBuf);

// ExtractFile : Extract one file
//  uiPosDir :  The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  lpPath :    Path where extract the file
//  lpFullName: will receive the exact full name of created file. Can be NULL
BOOL WIMAAPI ExtractFile(HIMA hIma,UINT uiPosDir,LPCSTR lpPath,LPSTR lpFullName);

// CheckSpaceForFile : Check you've space for inject a file of dwSize bytes
BOOL WIMAAPI CheckSpaceForFile(HIMA hIma,DWORD dwSize);

// to know if an inject is possible but need replace
//  lpFn : contain the name of file to be injected
//  lpDwSize : will receive the size of old file with same name. Can be NULL
//  lpNameWhenInjected : if not NULL, contain a new name in the image
//  lpShortName : will receive the short (8) name of file in image. Can be NULL
//  lpShortExt  : will receive the short (3) ext of file in image. Can be NULL
//      (if the file must have another name when injected)
BOOL WIMAAPI IfInjectPossibleButNeedReplace(HIMA hIma,LPCSTR lpFn,
         LPDWORD lpDwSize,LPSTR lpShortName,
         LPSTR lpShortExt,LPCSTR lpNameWhenInjected);

// RmDir : Remove a directory
//  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
//                  the file
BOOL WIMAAPI RmDir(HIMA hIma,UINT uiPosDir);

// DeleteFileNameExt
BOOL WIMAAPI DeleteFileNameExt(HIMA hIma,LPCSTR lpNom,LPCSTR lpExt,BOOL fRealDel);


// RenameFile :    Extract one file
//  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  lpNewLongName: The new name of the file
BOOL RenameFile(HIMA hIma,UINT uiPosDir,LPCSTR lpNewLongName);


// ChangeDateAndAttribute :    Extract one file
//  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  *lpbNewAttr:   Contain the new attribute of the file (or NULL to no change)
//  *lpNewDosDate,
//  *lpNewDosTime: Contain the Modified Date and Time (or NULL to no change)
//  *lpbNewdir_CreateMSec,*lpwNewdir_CreateTime,*lpwNewdir_CreateDate
//                 Contain the Created Date and Time (or NULL to no change)
//  *lpwNewdir_LastAccessDate : Contain the Last Access Date (or NULL...)
BOOL ChangeDateAndAttribute(HIMA hIma,UINT uiPosDir,LPBYTE lpbNewAttr,
                                    LPWORD lpNewDosDate,LPWORD lpNewDosTime,
                                    LPBYTE lpbNewdir_CreateMSec,
                                    LPWORD lpwNewdir_CreateTime,LPWORD lpwNewdir_CreateDate,
                                    LPWORD lpwNewdir_LastAccessDate);


// ReadData : Direct read data in image.
//  dwPos :  begin position
//  dwSize : number of byte to copy (size of buffer)
//  lpBuf :  buffer that will receive data
BOOL WIMAAPI ReadData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);

// WriteData : Direct write data in image. Be carreful, WI don't refresh dir!
//  dwPos :  begin position
//  dwSize : number of byte to copy (size of buffer)
//  lpBuf :  buffer that contain data
BOOL WIMAAPI WriteData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPCSTR lpBuf);
/* */

//
// GetFatImaSizeFileName : Get information about UNCOMPRESSED Fat image
//   lpfn :          FileName
//   lpdwSize :      Will receive the size of the image, 32 bits low part of 64 bit data
//   lpdwSize!high : Will receive the size of the image, 32 bits high part of 64 bit data
//   lpfIsBigFat :   Boolean pointer, will receive TRUE if this is a large image (>2.88MB), not floppy image
//   lpdwPosInFile : Will receive the position of the image
BOOL WIMAAPI GetFatImaSizeFileName(LPCSTR lpFn,LPDWORD lpdwSize,LPDWORD lpdwSizeHigh,LPBOOL lpfIsBigFat,LPDWORD lpdwPosInFile);

// GetDriveInfo : Get info about drive type
//  bDrive : number of driver (0 = 'A:', 1 = 'B:')
//  return the kind of drive
DRIVEINFO WIMAAPI GetDriveInfo(BYTE bDrive);

#ifdef __cplusplus
}
#endif  /* __cplusplus */
