/* FoldersTree control by Extreme Code Software(TM).
 * Copyright (C) 2001. All rights reserved.
 * This is not freeware. For restriction of use see the license. */

#ifndef ECODE_FLDTREE_H_
#define ECODE_FLDTREE_H_

#include <windows.h>
#include <commctrl.h>
#include <shlobj.h>
#include <shellapi.h>

#ifdef ECODE_FLDTREE_STATIC_LIB
    #define ECODE_EXPORT_IMPORT_
#else
    #ifdef ECODE_BUILD_FLDTREE_PROJECT_
        #define ECODE_EXPORT_IMPORT_ __declspec(dllexport)
    #else
        #define ECODE_EXPORT_IMPORT_ __declspec(dllimport)
    #endif
#endif

#define ECODE_APIENTRY ECODE_EXPORT_IMPORT_ /*__declspec(nothrow)*/ WINAPI

#ifdef __cplusplus
extern "C" {
#endif

#define ECODE_E_TREEVIEW MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,0x200)

/* Initialization/destruction */

HRESULT ECODE_APIENTRY FoldersTree_InitClass(void);
HRESULT ECODE_APIENTRY FoldersTree_DestroyClass(void);

HRESULT ECODE_APIENTRY FoldersTree_Init(HWND hwnd);
HRESULT ECODE_APIENTRY FoldersTree_Destroy(HWND hwnd);

#if 0
typedef void (CALLBACK *FoldersTree_error_handler_t)(HWND hwnd, DWORD code);
void ECODE_APIENTRY FoldersTree_SetErrorHandler(FoldersTree_error_handler_t error_handler);
#endif // 0

/* Windows messages */

LRESULT ECODE_APIENTRY FoldersTree_ProcessNotificationMessage(NMHDR *hdr);

/* Operations on the whole control */

HRESULT ECODE_APIENTRY FoldersTree_SetData(HWND hwnd, void *ptr);
HRESULT ECODE_APIENTRY FoldersTree_GetData(HWND hwnd, void **pptr);

typedef BOOL (CALLBACK *FoldersTree_filter_func_t)(HWND hwnd, IShellFolder *folder, const ITEMIDLIST *folder_pidl, const ITEMIDLIST *pidl);
HRESULT ECODE_APIENTRY FoldersTree_SetFilterFunctionA(HWND hwnd, FoldersTree_filter_func_t filter);
HRESULT ECODE_APIENTRY FoldersTree_GetFilterFunctionA(HWND hwnd, FoldersTree_filter_func_t *filter);

HRESULT ECODE_APIENTRY FoldersTree_SetFilterFlags(HWND hwnd, DWORD flags);
HRESULT ECODE_APIENTRY FoldersTree_GetFilterFlags(HWND hwnd, DWORD *flags);

/* Operations with individual items */

HRESULT ECODE_APIENTRY FoldersTree_BlessItem(HWND hwnd, HTREEITEM hItem);
HRESULT ECODE_APIENTRY FoldersTree_InsertFileSimple(HWND hwnd, HTREEITEM hParent, HTREEITEM hInsertAfter, const ITEMIDLIST *pidl, HTREEITEM *hNewItem);

HRESULT ECODE_APIENTRY FoldersTree_SetItemData(HWND hwnd, HTREEITEM hItem, void *ptr);
HRESULT ECODE_APIENTRY FoldersTree_GetItemData(HWND hwnd, HTREEITEM hItem, void **pptr);

//HRESULT FoldersTree_NewFileUpdate(HWND hwnd, HTREEITEM hParent, const ITEMIDLIST *abs_pidl);
//HRESULT ECODE_APIENTRY FoldersTree_InsertFile(
//    HWND hwnd, HTREEITEM hParent, const ITEMIDLIST *abs_pidl, HTREEITEM *newItem);
//HRESULT ECODE_APIENTRY FoldersTree_ChangeFile(HWND hwnd, HTREEITEM hItem, const ITEMIDLIST *pidl);
//HRESULT ECODE_APIENTRY FoldersTree_DeleteItem(HWND hwnd, HTREEITEM hItem);
//HRESULT ECODE_APIENTRY FoldersTree_UpdateItem(HWND hwnd, HTREEITEM hItem); // mainly for internal use
//HRESULT ECODE_APIENTRY FoldersTree_InsertContentsOfFolder(HWND hwnd, HTREEITEM hParent, IShellFolder *folder);
HRESULT ECODE_APIENTRY FoldersTree_GetPIDL(HWND hwnd, HTREEITEM hItem, ITEMIDLIST **pidl);
HRESULT ECODE_APIENTRY FoldersTree_FindItemWithPIDL(HWND hwnd, HTREEITEM hStartItem, const ITEMIDLIST *pidl, HTREEITEM *hItem);

HRESULT ECODE_APIENTRY FoldersTree_Update(HWND hwnd, HTREEITEM hStartItem);

#ifdef __cplusplus
} // extern "C"
#endif

#ifndef ECODE_BUILD_FLDTREE_PROJECT_
  #undef ECODE_APIENTRY
#endif

#endif // ECODE_FLDTREE_H_
