// MainFrm.h : interface of the CMainFrame class
//
// Copyright (c) 2000 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

/////////////////////////////////////////////////////////////////////////////

#include "Control.h"
#include "Search.h"
#include "Prop.h"
#include "CalcDlg.h"

class CMainFrame : public CMDIFrameWnd
{
    DECLARE_DYNAMIC(CMainFrame)
public:
    CMainFrame();

// Attributes
public:

// Operations
public:
    void AddSearchHistory(const CString &);
    void LoadSearchHistory(CHexEditApp *aa);
    void SaveSearchHistory(CHexEditApp *aa);
    void AddHexHistory(const CString &);
    void AddDecHistory(const CString &);
    void StatusBarText(const char *mess = NULL);
    void bar_context(CPoint point);
    void SaveFrameOptions();

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CMainFrame)
    public:
    virtual BOOL PreTranslateMessage(MSG* pMsg);
    protected:
    virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
    //}}AFX_VIRTUAL

// Implementation
public:
    virtual ~CMainFrame();
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext& dc) const;
#endif

public:
    // Control Bars
    CDlgBar  m_wndToolBar;
    CDlgBar  m_wndEditBar;
    CStatBar m_wndStatusBar;

    // ToolBar bitmap buttons
    CBitmapButton bb_file_open_;
    CBitmapButton bb_file_save_;
    CBitmapButton bb_file_print_;
    CBitmapButton bb_edit_cut_;
    CBitmapButton bb_edit_copy_;
    CBitmapButton bb_edit_paste_;
    CBitmapButton bb_edit_undo_;

    CBitmapButton bb_autofit_;
    CBitmapButton bb_font_inc_;
    CBitmapButton bb_font_dec_;
    CBitmapButton bb_addr_toggle_;
    CBitmapButton bb_char_toggle_;
    CBitmapButton bb_asc_ebc_;
    CBitmapButton bb_control_;
    CBitmapButton bb_graphic_toggle_;
    CBitmapButton bb_allow_mods_;
    CBitmapButton bb_edit_rec_;
    CBitmapButton bb_edit_play_;

    // EditBar bitmap buttons
    CBitmapButton bb_mark_;
    CBitmapButton bb_goto_mark_;
    CBitmapButton bb_search_back_;
    CBitmapButton bb_search_forw_;
#ifdef ENCOM
    CBitmapButton bb_rs_back_;
    CBitmapButton bb_rs_forw_;
#endif

    // EditBar edit controls (within combo controls)
    CHexEditControl hec_hex_addr_;      // Edit for hex address
    CDecEditControl dec_dec_addr_;      // Edit for decimal address
    CSearchEditControl sec_search_;     // Edit for searches

    // Modeless dilaogs
    CHexFindDialog *pfind_;
    CPropSheet *pprop_;                 // Pointer to (modeless) prop sheet
    CCalcDlg *pcalc_;                   // Ptr to calculator dlg

// Generated message map functions
// protected:
public:
    afx_msg void OnInitMenu(CMenu* pMenu);
    //{{AFX_MSG(CMainFrame)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnClose();
    afx_msg void OnEditFind();
    afx_msg void OnUpdateEditFind(CCmdUI* pCmdUI);
    afx_msg void OnEditFind2();
    afx_msg void OnEditGoto();
    afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
    afx_msg void OnCalculator();
    //}}AFX_MSG
    afx_msg void OnWindowNew();
    afx_msg BOOL OnMDIWindowCmd(UINT nID);
    afx_msg void OnSysCommand(UINT nID, LONG lParam);
    afx_msg BOOL OnBarCheck(UINT nID);
    afx_msg void OnUpdateViewToolbar(CCmdUI* pCmdUI);
    afx_msg void OnViewToolbar();
    afx_msg void OnUpdateViewEditbar(CCmdUI* pCmdUI);
    afx_msg void OnViewEditbar();
    afx_msg void OnContextHelp();   // for Shift+F1 help
    afx_msg void OnHelpFinder();
    afx_msg void OnHelp();
    afx_msg LRESULT OnCommandHelp(WPARAM, LPARAM);
    afx_msg void OnChangeAddrHex();
    afx_msg void OnSelAddrHex();
    afx_msg void OnChangeAddrDec();
    afx_msg void OnSelAddrDec();
    afx_msg void OnUpdateOccurrences(CCmdUI *pCmdUI);
    afx_msg void OnUpdateAddrHex(CCmdUI *pCmdUI);
    afx_msg void OnUpdateAddrDec(CCmdUI *pCmdUI);
    afx_msg void OnUpdateValues(CCmdUI *pCmdUI);
    afx_msg void OnUpdateReadonly(CCmdUI *pCmdUI);
    afx_msg void OnUpdateOvr(CCmdUI *pCmdUI);
    afx_msg void OnUpdateRec(CCmdUI *pCmdUI);
	afx_msg LONG OnOpenMsg(UINT wParam, LONG lParam);

    afx_msg LONG OnFindDlgMess(WPARAM wParam, LPARAM lParam);
    afx_msg LRESULT OnReturn(WPARAM, LPARAM);

    DECLARE_MESSAGE_MAP()
private:
    CString last_mess_;     // Last status bar message received with refresh off
};

/////////////////////////////////////////////////////////////////////////////
