package ishitai.oopad;

import java.io.*;
import java.awt.*;
import ishitai.bots.*;

/**
 * TXTdata.java
 *
 *
 * Created: Wed Sep 01 21:09:04 1999
 *
 * @author Richard Harris
 * @version 1.0
 * changes
 * 3.5.00 using ghost frame instead of editor's
 * 3.5.00 cancelled open retains old file
 * 3.5.00 added readOnly() and showLicense()
 */
public class TXTdata implements Data {
   private Frame frame = new Frame();
   private String file_name = null;
   private FileReader in = null;
   private FileWriter out = null;
   private File file = null;
   private ExcepBot ebot = BotFactory.getExcepBot();

   public TXTdata(){
      //center the ghost frame on the screen
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = new Dimension(500, 600);
      if (frameSize.height > screenSize.height)
         frameSize.height = screenSize.height;
      if (frameSize.width > screenSize.width)
         frameSize.width = screenSize.width;
      frame.setLocation((screenSize.width - frameSize.width) / 2,
             ((screenSize.height - frameSize.height) / 2) - 
             (screenSize.height / 15));
   }

	/**
	 * Accessor to path+name of the file connected to this data
	 */
   public String getFilename(){
      return file_name;
   }
   
   /**
   * Accessor to readOnly.  
   */
   public boolean readOnly(){
      return !file.canWrite();
   }

	/**
	 * Opens the file and loads it into a String
	 */
   public String open(){
      String[] tmp = getFile(FileDialog.LOAD);
      String filename = tmp[0];
      if (filename.compareTo("") == 0){
			//cancelled open; retain current file 3.5.00
			return "";
      }
      String directory = tmp[1];
      return _open(directory, filename);
   }
   
   public String showLicense(){
      return _open(null, "license.txt");
   }
   
   private String _open(String dir, String name){
      try{
			file = new File(dir, name);
      }catch(NullPointerException npe01){
			ebot.dump(npe01);
      }
      file_name = dir + name; 
      if (!file.exists()){
			try{
				file.createNewFile();
			}catch(IOException ioe2){
				ebot.dump(ioe2);
			}
			//return an new empty file
			return ""; 
      }else{
			try{
				in = new FileReader(file);
			}catch(FileNotFoundException fnfe02){
				ebot.dump(fnfe02);
			}
			StringBuffer tmpBfr = new StringBuffer();
			char[] buff = new char[4096];
			int nch;
			try{
				while ((nch = in.read(buff, 0, buff.length)) != -1) {
					tmpBfr.append(buff, 0, buff.length);
					buff = null;
					buff = new char[4096];
				}      
			}catch(IOException ioe04){
				ebot.dump(ioe04);
			}
			//return the whole file
			return(new String(tmpBfr));
      }
   }

	/**
	 * Writes the contents of the editor's textarea to
	 * the file.
	 *
	 * @param textfile The String from the TextArea.
	 */
   public void write(String textfile){
      if (file == null){
	 String[] tmpArray = getFile(FileDialog.SAVE);
	 String filename = tmpArray[0];
	 if (filename.compareTo("") == 0){
	    file_name = "No file";
	    return;
	 }
	 String directory = tmpArray[1];
	 try{
	    file = new File(directory, filename);
	 }catch(NullPointerException npe01){
	    ebot.dump(npe01);
	 }
	 if (!file.exists()){
	    try{
	       file.createNewFile();
	    }catch(IOException ioe2){
	       ebot.dump(ioe2);
	    }
	 }
	 file_name = directory + filename;
      }
      try{
	 out = new FileWriter(file);
      }catch(IOException ie){
	 ebot.dump(ie);
      }
      char[] tmp = textfile.toCharArray();
      try{
	 out.write(tmp, 0, tmp.length);
	 out.close();
      }catch(IOException ioe01){
	 ebot.dump(ioe01);
      }
   }

	/**
	 * Cleans up the resources used by this class.
	 */
   public void close(){
      try{
	 if(in != null){
	    in.close();
	 }
	 if(out != null){
	    out.close();
	 }
	 file = null;
      }catch(Exception e){
	 ebot.dump(e);
      }
   }

   private String[] getFile(int MODE){
      String[] returnVal = {"", ""};
      FileDialog fileDialog = new FileDialog(frame);
      fileDialog.setMode(MODE);
      fileDialog.show();

      String filename = fileDialog.getFile();
      if (filename == null) {
	 return returnVal;
      } else {
	 returnVal[0] = filename;
	 returnVal[1] = fileDialog.getDirectory();
      }
      return returnVal;
   }

} // TXTdata