/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class SRFrame
extends Frame
implements ActionListener {
    protected Label l = new Label("*               Text Area               *", 1);
    protected SPDReader sr;
    private Bookmark currentBkmk;
    Thread displayThread;
    private SRPrefs prefs;
    private Frame prefsFrame;
    private String prefsFileName = "SRPrefs.prf";

    public SRFrame() {
        this.add(this.l);
        File file = new File(this.prefsFileName);
        if (file.exists() && file.canRead() && file.canWrite()) {
            this.prefs = this.loadPrefs(file);
        } else {
            this.prefs = new SRPrefs();
            this.l.setText("Please view the readme.txt file");
        }
        this.update();
        this.setMenuBar(this.makeMenuBar());
        this.setResizable(true);
        this.pack();
        ((Component)this).setSize(this.prefs.getWindowSize());
        ((Component)this).setLocation(this.prefs.getScreenLocation());
        this.show();
    }

    private void openTextFile() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open Text File", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            try {
                File file = new File(string2, string);
                this.currentBkmk = new Bookmark(file, 0);
                this.sr = new SPDReader(file, this.currentBkmk.getLocation(), this.prefs.getCharsPerLine());
                this.l.setText("");
                return;
            }
            catch (Exception exception) {
                this.l.setText("Error: " + exception);
                return;
            }
        }
    }

    private void openBookmark() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open Bookmark", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            try {
                File file = new File(string2, string);
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.currentBkmk = (Bookmark)objectInputStream.readObject();
                objectInputStream.close();
                this.sr = this.currentBkmk.isFile() ? new SPDReader(this.currentBkmk.getFile(), this.currentBkmk.getLocation(), this.prefs.getCharsPerLine()) : new SPDReader(this.currentBkmk.getCharArray(), this.currentBkmk.getLocation(), this.prefs.getCharsPerLine());
                this.l.setText("");
                return;
            }
            catch (Exception exception) {
                this.l.setText("File doesn't seem to be a bookmark!");
                return;
            }
        }
    }

    private void saveBookmark(Bookmark bookmark) {
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            if (bookmark.isFile()) {
                fileOutputStream = new FileOutputStream(String.valueOf(bookmark.getFile()) + ".bmk");
            } else if (bookmark.isCharArray()) {
                object = new FileDialog((Frame)this, "Save Bookmark As", 1);
                ((Dialog)object).show();
                File file = new File(((FileDialog)object).getDirectory(), ((FileDialog)object).getFile());
                fileOutputStream = new FileOutputStream(file);
            }
            object = new ObjectOutputStream(fileOutputStream);
            ((ObjectOutputStream)object).writeObject(bookmark);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            this.l.setText("Error: " + iOException);
            return;
        }
    }

    private void startReading() {
        if (this.currentBkmk == null) {
            this.l.setText("You must first open or paste a text file");
            return;
        }
        this.l.setText("");
        this.sr.setCurrentPosition(this.currentBkmk.getLocation());
        if (this.displayThread != null && this.displayThread.isAlive()) {
            this.displayThread.resume();
            return;
        }
        this.displayThread = new 1();
        this.displayThread.start();
    }

    private void stopReading() {
        if (this.displayThread != null) {
            this.displayThread.suspend();
            this.currentBkmk.setLocation(this.sr.getCurrentPosition());
        }
    }

    private void nextLine() {
        if (this.currentBkmk != null) {
            this.l.setText(this.sr.getLine(this.prefs.getCharsPerLine()));
        }
    }

    private void prevLine() {
        if (this.currentBkmk != null) {
            this.sr.setCurrentPosition(this.sr.getCurrentPosition() - 2 * this.prefs.getCharsPerLine());
            this.l.setText(this.sr.getLine(this.prefs.getCharsPerLine()));
        }
    }

    private void goFaster() {
        if (this.prefs.getDelay() > 10) {
            this.prefs.setDelay(this.prefs.getDelay() - 10);
        }
    }

    private void goSlower() {
        this.prefs.setDelay(this.prefs.getDelay() + 10);
    }

    private void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            char[] cArray = string.toCharArray();
            this.currentBkmk = new Bookmark(cArray, 0);
            this.sr = new SPDReader(this.currentBkmk.getCharArray(), this.currentBkmk.getLocation(), this.prefs.getCharsPerLine());
            this.l.setText("");
            return;
        }
        catch (Exception exception) {
            this.l.setText("Error: " + exception);
            return;
        }
    }

    private void update() {
        this.setTitle(this.prefs.getWindowTitle());
        this.l.setFont(this.prefs.getFont());
        this.l.setBackground(this.prefs.getBkgColor());
        this.l.setForeground(this.prefs.getFgColor());
    }

    private MenuBar makeMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Open New");
        menuItem.setActionCommand("OpenNew");
        menuItem.addActionListener(this);
        menuItem.setShortcut(new MenuShortcut(111));
        MenuItem menuItem2 = new MenuItem("Open Bookmark");
        menuItem2.setActionCommand("OpenBookmark");
        menuItem2.addActionListener(this);
        menuItem2.setShortcut(new MenuShortcut(98));
        MenuItem menuItem3 = new MenuItem("Save Bookmark");
        menuItem3.setActionCommand("SaveBookmark");
        menuItem3.addActionListener(this);
        menuItem3.setShortcut(new MenuShortcut(115));
        MenuItem menuItem4 = new MenuItem("Start");
        menuItem4.setActionCommand("Start");
        menuItem4.addActionListener(this);
        menuItem4.setShortcut(new MenuShortcut(103));
        MenuItem menuItem5 = new MenuItem("Stop");
        menuItem5.setActionCommand("Stop");
        menuItem5.addActionListener(this);
        menuItem5.setShortcut(new MenuShortcut(112));
        MenuItem menuItem6 = new MenuItem("Exit");
        menuItem6.setActionCommand("Exit");
        menuItem6.addActionListener(this);
        menuItem6.setShortcut(new MenuShortcut(120));
        MenuItem menuItem7 = new MenuItem("Next Line");
        menuItem7.setActionCommand("NextLine");
        menuItem7.addActionListener(this);
        menuItem7.setShortcut(new MenuShortcut(110));
        MenuItem menuItem8 = new MenuItem("Previous Line");
        menuItem8.setActionCommand("PrevLine");
        menuItem8.addActionListener(this);
        menuItem8.setShortcut(new MenuShortcut(108));
        menu.add(menuItem);
        menu.add(menuItem2);
        menu.add(menuItem3);
        menu.addSeparator();
        menu.add(menuItem4);
        menu.add(menuItem5);
        menu.addSeparator();
        menu.add(menuItem7);
        menu.add(menuItem8);
        menu.addSeparator();
        menu.add(menuItem6);
        menuBar.add(menu);
        Menu menu2 = new Menu("Edit");
        MenuItem menuItem9 = new MenuItem("Paste");
        menuItem9.setActionCommand("Paste");
        menuItem9.addActionListener(this);
        menuItem9.setShortcut(new MenuShortcut(118));
        MenuItem menuItem10 = new MenuItem("Faster");
        menuItem10.setActionCommand("Faster");
        menuItem10.addActionListener(this);
        menuItem10.setShortcut(new MenuShortcut(102));
        MenuItem menuItem11 = new MenuItem("Slower");
        menuItem11.setActionCommand("Slower");
        menuItem11.addActionListener(this);
        menuItem11.setShortcut(new MenuShortcut(100));
        MenuItem menuItem12 = new MenuItem("Preferences");
        menuItem12.setActionCommand("Preferences");
        menuItem12.addActionListener(this);
        menu2.add(menuItem9);
        menu2.addSeparator();
        menu2.add(menuItem10);
        menu2.add(menuItem11);
        menu2.addSeparator();
        menu2.add(menuItem12);
        menuBar.add(menu2);
        Menu menu3 = new Menu("Help");
        MenuItem menuItem13 = new MenuItem("Topics");
        menuItem13.setActionCommand("Topics");
        menuItem13.addActionListener(this);
        MenuItem menuItem14 = new MenuItem("About");
        menuItem14.setActionCommand("About");
        menuItem14.addActionListener(this);
        menu3.add(menuItem13);
        menu3.addSeparator();
        menu3.add(menuItem14);
        menuBar.add(menu3);
        return menuBar;
    }

    SRPrefs loadPrefs(File file) {
        SRPrefs sRPrefs = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            sRPrefs = (SRPrefs)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            this.l.setText("Error: " + exception.getMessage());
        }
        return sRPrefs;
    }

    void savePrefs(SRPrefs sRPrefs, String string) {
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(sRPrefs);
                objectOutputStream.flush();
                objectOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                return;
            }
        }
    }

    void frameExit() {
        this.prefs.setScreenLocation(this.getLocationOnScreen());
        this.prefs.setWindowSize(this.getSize());
        this.savePrefs(this.prefs, this.prefsFileName);
        System.exit(0);
    }

    private void tellAbout() {
        Dialog dialog = new Dialog(this, "About SpeedReader:", true);
        dialog.setLayout(new BorderLayout(10, 10));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label("Version: "));
        panel.add(new Label("2.1"));
        panel.add(new Label("Author: "));
        panel.add(new Label("Joshua Twait"));
        panel.add(new Label("email: "));
        panel.add(new Label("jspeedreader@yahoo.com"));
        dialog.add((Component)panel, "North");
        Button button = new Button("OK");
        button.addActionListener(new 2(dialog));
        dialog.add((Component)button, "South");
        dialog.pack();
        dialog.show();
    }

    private void showHelpFile() {
        Dialog dialog = new Dialog(this, "Help File", false);
        dialog.setLayout(new BorderLayout(10, 10));
        TextArea textArea = new TextArea(25, 65);
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setEditable(false);
        try {
            File file = new File("readme.txt");
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            int n = 0;
            while (n < (int)file.length()) {
                n += fileReader.read(cArray, n, (int)file.length() - n);
            }
            textArea.append(String.valueOf(cArray));
        }
        catch (Exception exception) {
            textArea.append("Couldn't find readme.txt file: " + exception + "\n\nIf you haven't already, please expand the help file:" + "\n\n   jar -xf SpeedReader.jar readme.txt");
        }
        dialog.add((Component)textArea, "North");
        Button button = new Button("OK");
        button.addActionListener(new 3(dialog));
        dialog.add((Component)button, "South");
        dialog.pack();
        dialog.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Exit")) {
            this.frameExit();
            return;
        }
        if (string.equals("OpenNew")) {
            this.openTextFile();
            return;
        }
        if (string.equals("OpenBookmark")) {
            this.openBookmark();
            return;
        }
        if (string.equals("SaveBookmark")) {
            this.saveBookmark(this.currentBkmk);
            return;
        }
        if (string.equals("Start")) {
            this.startReading();
            return;
        }
        if (string.equals("Stop")) {
            this.stopReading();
            return;
        }
        if (string.equals("NextLine")) {
            this.nextLine();
            return;
        }
        if (string.equals("PrevLine")) {
            this.prevLine();
            return;
        }
        if (string.equals("Paste")) {
            this.paste();
            return;
        }
        if (string.equals("Faster")) {
            this.goFaster();
            return;
        }
        if (string.equals("Slower")) {
            this.goSlower();
            return;
        }
        if (string.equals("Topics")) {
            this.showHelpFile();
            return;
        }
        if (string.equals("About")) {
            this.tellAbout();
            return;
        }
        if (string.equals("Preferences")) {
            this.prefsFrame = this.prefs.makeFrame(this);
            ((Component)this.prefsFrame).setVisible(true);
            return;
        }
        if (string.equals("PrefsFrameOK")) {
            this.update();
            this.prefsFrame.dispose();
            return;
        }
        if (string.equals("PrefsFrameCancel")) {
            this.prefsFrame.dispose();
        }
    }

    private final class 1
    extends Thread {
        public void run() {
            try {
                Thread.sleep(1000L);
                while (!SRFrame.this.sr.atEnd()) {
                    SRFrame.this.l.setText(SRFrame.this.sr.getLine(SRFrame.this.prefs.getCharsPerLine()));
                    if (SRFrame.this.prefs.delayLongWords() && SRFrame.this.l.getText().length() > SRFrame.this.prefs.getCharsPerLine() + 5) {
                        Thread.sleep(2 * SRFrame.this.prefs.getDelay());
                        continue;
                    }
                    Thread.sleep(SRFrame.this.prefs.getDelay());
                }
                Thread.sleep(2000L);
                SRFrame.this.l.setText("Finished!");
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements ActionListener {
        private final /* synthetic */ Dialog val$d;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$d.dispose();
        }

        /* synthetic */ 2(Dialog dialog) {
            this.val$d = dialog;
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ Dialog val$d;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$d.dispose();
        }

        /* synthetic */ 3(Dialog dialog) {
            this.val$d = dialog;
        }
    }
}

