/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GIntersectDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "intersect.gif";
    public static final Dimension ICONDIM = new Dimension(120, 56);
    private TextField[] p;
    private TextField intersection;
    private GButton getOneButton;
    private String defaultIntersection;
    private GSolid solid;

    public GIntersectDialog(GFrame gFrame, GSolid gSolid, GProblem gProblem, int n, Object[] objectArray) {
        super(gFrame, "Intersect Lines");
        this.helpTopic = "draw intersection";
        this.solid = gSolid;
        this.p = new TextField[4];
        int n2 = 0;
        while (n2 < 4) {
            this.p[n2] = new TextField(3);
            this.p[n2].setFont(gFrame.labelFont);
            ++n2;
        }
        this.intersection = new TextField(3);
        this.intersection.setFont(gFrame.labelFont);
        this.getOneButton = new GButton("Get One");
        this.getOneButton.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(gProblem, n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Mark the intersection of lines labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 2;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p[3], gridBagConstraints);
        this.dataPanel.add(this.p[3]);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.p[2], gridBagConstraints);
        this.dataPanel.add(this.p[2]);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        Label label2 = new Label("Assign label to the intersection:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.intersection, gridBagConstraints);
        this.dataPanel.add(this.intersection);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.getOneButton.setFont(GDialog.buttonFont);
        gridBagLayout.setConstraints(this.getOneButton, gridBagConstraints);
        this.dataPanel.add(this.getOneButton);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase(), this.p[3].getText().toUpperCase(), this.intersection.getText().toUpperCase()};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
        ((TextComponent)this.p[2]).setText((String)objectArray[2]);
        ((TextComponent)this.p[3]).setText((String)objectArray[3]);
        ((TextComponent)this.intersection).setText((String)objectArray[4]);
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase(), this.p[3].getText().toUpperCase(), this.intersection.getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("") || stringArray[2].equals("") || stringArray[3].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to end point");
            return false;
        }
        if (stringArray[0].equals(stringArray[1])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[0]) + stringArray[1] + " is no line");
            return false;
        }
        if (stringArray[2].equals(stringArray[3])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[2]) + stringArray[3] + " is no line");
            return false;
        }
        if (stringArray[4].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to intersection");
            return false;
        }
        String string = this.solid.drawIntersection(stringArray);
        if (string != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string);
            return false;
        }
        return true;
    }

    public void set(GProblem gProblem, int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Intersect Lines in Solid " + this.solid.getLabel());
            this.defaultIntersection = gProblem.supplyLabel();
            GEdgeList gEdgeList = this.solid.getSelectedEdges();
            if (gEdgeList.getDim() > 1) {
                GEdgeNode gEdgeNode = gEdgeList.getHead();
                GEdge gEdge = gEdgeNode.getEdge();
                GEdge gEdge2 = gEdgeNode.getNext().getEdge();
                ((TextComponent)this.p[0]).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p[1]).setText(gEdge.getTail().getLabel());
                ((TextComponent)this.p[2]).setText(gEdge2.getHead().getLabel());
                ((TextComponent)this.p[3]).setText(gEdge2.getTail().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        if (n != 2) {
            ((TextComponent)this.intersection).setText(this.defaultIntersection);
        }
        this.result = this.onOk() ? 0 : 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.getOneButton) {
            if (this.defaultIntersection == null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "No more labels available");
                return;
            }
            ((TextComponent)this.intersection).setText(this.defaultIntersection);
        }
    }
}

