/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapReferralContext;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.Control;

public final class LdapReferralException
extends javax.naming.ldap.LdapReferralException {
    private int handleReferrals;
    private Hashtable envprops;
    private String nextName;
    private Control[] reqCtls;
    private Vector referrals = null;
    private int nextReferral = 0;
    private boolean foundEntry = false;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    LdapReferralException nextRefEx = null;

    LdapReferralException(Name name, Object object, Name name2, String string, Hashtable hashtable, String string2, int n, Control[] controlArray) {
        super(string);
        this.setResolvedName(name);
        this.setResolvedObj(object);
        this.setRemainingName(name2);
        this.envprops = hashtable;
        this.nextName = string2;
        this.handleReferrals = n;
        this.reqCtls = n == 1 ? controlArray : null;
    }

    public Context getReferralContext() throws NamingException {
        return this.getReferralContext(this.envprops, null);
    }

    public Context getReferralContext(Hashtable hashtable) throws NamingException {
        return this.getReferralContext(hashtable, null);
    }

    public Context getReferralContext(Hashtable hashtable, Control[] controlArray) throws NamingException {
        LdapReferralContext ldapReferralContext = new LdapReferralContext(this, hashtable, controlArray, this.reqCtls, this.nextName, this.skipThisReferral, this.handleReferrals);
        ldapReferralContext.setHopCount(this.hopCount + 1);
        if (this.skipThisReferral) {
            this.skipThisReferral = false;
        }
        return ldapReferralContext;
    }

    public Object getReferralInfo() {
        if (this.referrals != null && this.nextReferral < this.referrals.size()) {
            return this.referrals.elementAt(this.nextReferral);
        }
        return null;
    }

    void setReferralInfo(Vector vector, boolean bl) {
        this.referrals = vector;
    }

    String getNextReferral() throws ReferralException {
        if (!this.foundEntry && this.referrals != null && this.nextReferral < this.referrals.size()) {
            return (String)this.referrals.elementAt(this.nextReferral++);
        }
        if (this.nextRefEx != null) {
            throw this.nextRefEx;
        }
        return null;
    }

    LdapReferralException appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        if (ldapReferralException == null) {
            if (this.foundEntry || this.nextReferral >= this.referrals.size()) {
                return this.nextRefEx;
            }
            return this;
        }
        if (!ldapReferralException.hasMoreReferrals()) {
            return this;
        }
        if (!this.foundEntry && this.nextReferral < this.referrals.size()) {
            if (this.nextRefEx == null) {
                this.nextRefEx = ldapReferralException;
            } else {
                ldapReferralException.nextRefEx = this.nextRefEx;
                this.nextRefEx = ldapReferralException;
            }
            return this;
        }
        if (this.nextRefEx != null) {
            ldapReferralException.nextRefEx = this.nextRefEx;
        }
        return ldapReferralException;
    }

    boolean hasMoreReferrals() {
        if (this.foundEntry) {
            return this.nextRefEx != null;
        }
        return this.nextReferral < this.referrals.size() || this.nextRefEx != null;
    }

    public void retryReferral() {
        if (this.nextReferral > 0) {
            --this.nextReferral;
        }
    }

    public boolean skipReferral() {
        this.skipThisReferral = true;
        try {
            this.getNextReferral();
        }
        catch (ReferralException referralException) {
            // empty catch block
        }
        return this.hasMoreReferrals();
    }

    void setHopCount(int n) {
        this.hopCount = n;
    }

    void setNameResolved(boolean bl) {
        this.foundEntry = bl;
    }
}

