/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        WaveFileFormat waveFileFormat = null;
        int n = 12;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n);
        n2 = dataInputStream.readInt();
        n3 = this.rllong(dataInputStream);
        n5 = dataInputStream.readInt();
        if (n3 <= 0) {
            n3 = -1;
            n4 = -1;
        } else {
            n4 = n3 + 8;
        }
        if (n2 != 1380533830 || n5 != 1463899717) {
            dataInputStream.reset();
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        audioFormat = new AudioFormat(-1.0f, -1, -1, true, false);
        waveFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, n4, audioFormat, -1);
        dataInputStream.reset();
        return waveFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        audioFormat = this.getFMT(bufferedInputStream, audioFileFormat.getFormat());
        audioFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, audioFileFormat.getByteLength(), audioFormat, -1);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        audioFormat = this.getFMT(bufferedInputStream, audioFileFormat.getFormat());
        audioFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, audioFileFormat.getByteLength(), audioFormat, -1);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        int n;
        DataInputStream dataInputStream = null;
        int n2 = 0;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        audioFileFormat = this.getAudioFileFormat(inputStream);
        dataInputStream = new DataInputStream(inputStream);
        audioFormat = this.getFMT(dataInputStream, audioFileFormat.getFormat());
        try {
            while (true) {
                int n3 = dataInputStream.readInt();
                n2 += 4;
                if (n3 != 1684108385) {
                    n = this.rllong(dataInputStream);
                    n2 += 4;
                    if (n % 2 > 0) {
                        ++n;
                    }
                    n2 += dataInputStream.skipBytes(n);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n = this.rllong(dataInputStream);
        n2 += 4;
        return new AudioInputStream(dataInputStream, audioFormat, n / audioFormat.getFrameSize());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    private AudioFormat getFMT(InputStream inputStream, AudioFormat audioFormat) throws UnsupportedAudioFileException, IOException {
        int n = 0;
        int n2 = 0;
        short s = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        try {
            while (true) {
                int n3 = dataInputStream.readInt();
                n += 4;
                if (n3 != 1718449184) {
                    n2 = this.rllong(dataInputStream);
                    n += 4;
                    if (n2 % 2 > 0) {
                        ++n2;
                    }
                    n += dataInputStream.skipBytes(n2);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n2 = this.rllong(dataInputStream);
        int n4 = (n += 4) + n2;
        s = this.rlshort(dataInputStream);
        n += 2;
        if (s == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (s == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (s == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short s2 = this.rlshort(dataInputStream);
        n += 2;
        long l = this.rllong(dataInputStream);
        n += 4;
        long l2 = this.rllong(dataInputStream);
        n += 4;
        short s3 = this.rlshort(dataInputStream);
        n += 2;
        short s4 = this.rlshort(dataInputStream);
        n += 2;
        if (s4 == 8 && encoding == AudioFormat.Encoding.PCM_SIGNED) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (n2 % 2 != 0) {
            ++n2;
        }
        if (n4 > n) {
            n += dataInputStream.skipBytes(n4 - n);
        }
        return new AudioFormat(encoding, l, s4, s2, s4 * s2 / 8, l, false);
    }
}

