/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.Win32GraphicsConfig;

public class Win32GraphicsDevice
extends GraphicsDevice {
    int screen;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    int defaultPixID = -1;
    private Vector nonDefaultGCs;

    public Win32GraphicsDevice(int n) {
        this.screen = n;
    }

    public int getType() {
        return 0;
    }

    public int getScreen() {
        return this.screen;
    }

    public String getIDstring() {
        return "\\Display" + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            int n = this.getMaxConfigs(this.screen);
            this.defaultPixID = this.getDefaultPixID(this.screen);
            Vector vector = new Vector(n);
            if (this.defaultPixID == 0) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, this.defaultPixID);
                vector.addElement(this.defaultConfig);
            } else {
                int n2 = 1;
                while (n2 <= n) {
                    if (this.isPixFmtSupported(n2, this.screen)) {
                        if (n2 == this.defaultPixID) {
                            this.defaultConfig = Win32GraphicsConfig.getConfig(this, n2);
                            vector.addElement(this.defaultConfig);
                        } else {
                            vector.addElement(Win32GraphicsConfig.getConfig(this, n2));
                        }
                    }
                    ++n2;
                }
            }
            this.configs = new GraphicsConfiguration[vector.size()];
            vector.copyInto(this.configs);
        }
        return this.configs;
    }

    protected native int getMaxConfigs(int var1);

    protected native boolean isPixFmtSupported(int var1, int var2);

    protected native int getDefaultPixID(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            this.defaultPixID = this.getDefaultPixID(this.screen);
            this.defaultConfig = Win32GraphicsConfig.getConfig(this, this.defaultPixID);
        }
        return this.defaultConfig;
    }

    public String toString() {
        return "Win32GraphicsDevice[screen=" + this.screen + "]";
    }

    public void displayModeChanged() {
        this.defaultConfig = null;
        this.defaultPixID = this.getDefaultPixID(this.screen);
        this.configs = null;
        this.invalidateGCs();
    }

    public synchronized void addNonDefaultGC(WeakReference weakReference) {
        if (weakReference.get() instanceof Component) {
            if (this.nonDefaultGCs == null) {
                this.nonDefaultGCs = new Vector(1);
            }
            this.nonDefaultGCs.addElement(weakReference);
        }
    }

    private void invalidateGCs() {
        if (this.nonDefaultGCs != null) {
            Enumeration enumeration = this.nonDefaultGCs.elements();
            while (enumeration.hasMoreElements()) {
                WeakReference weakReference = (WeakReference)enumeration.nextElement();
                Object object = weakReference.get();
                if (object == null || !(object instanceof Component)) continue;
                Component component = (Component)object;
                this.resetComponentGC(component);
                ComponentPeer componentPeer = component.getPeer();
                if (componentPeer == null) continue;
                this.resetPeerGC(componentPeer);
            }
        }
    }

    private native void resetComponentGC(Component var1);

    private native void resetPeerGC(ComponentPeer var1);
}

