/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class DSign
extends Canvas {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int LINE = 3;
    protected int bevel;
    protected Color background;
    protected Color foreground;
    protected Color dark;
    protected Color light;
    protected int width;
    protected int height;
    protected Insets insets = new Insets(1, 1, 1, 1);

    public DSign() {
        this(3);
    }

    public DSign(int n) {
        this.bevel = n;
    }

    public void setBevel(int n) {
        this.bevel = n;
    }

    public void SetInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets GetInsets() {
        return this.insets;
    }

    public void setBackground(Color color) {
        this.background = color;
        this.light = color.brighter();
        this.dark = color.darker();
        this.repaint();
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        graphics.setColor(this.background);
        graphics.fillRect(1, 1, this.width - 2, this.height - 2);
        this.drawBorder(graphics, 0, 0, this.width - 1, this.height - 1);
    }

    protected void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.bevel) {
            case 1: {
                graphics.setColor(this.light);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.dark);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 2: {
                graphics.setColor(this.dark);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.light);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 3: {
                graphics.setColor(this.foreground);
                graphics.drawRect(n, n2, n3, n4);
                break;
            }
            case 0: {
                break;
            }
        }
    }
}

