/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.NoSuchElementException;

public class VectorLong {
    public long[] elementData;
    public int elementCount;
    public int capacityIncrement;
    public int index = 0;

    public VectorLong(int n, int n2) {
        this.elementData = new long[n];
        this.capacityIncrement = n2;
    }

    public VectorLong(int n) {
        this(n, 1);
    }

    public VectorLong() {
        this(16);
    }

    public final synchronized void copyInto(long[] lArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            lArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        long l = this.elementData.length;
        if ((long)this.elementCount < l) {
            long[] lArray = this.elementData;
            this.elementData = new long[this.elementCount];
            VectorLong.copy(lArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            long[] lArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new long[n3];
            VectorLong.copy(lArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = 0L;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(long l) {
        return this.indexOf(l, 0) >= 0;
    }

    public final int indexOf(long l) {
        return this.indexOf(l, 0);
    }

    public final synchronized int indexOf(long l, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (l != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(long l) {
        return this.lastIndexOf(l, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(long l, int n) {
        for (int i = n; i >= 0; --i) {
            if (l != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized long elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" >= ").append(this.elementCount))));
        }
        return this.elementData[n];
    }

    public final synchronized long firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized long lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(long l, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" >= ").append(this.elementCount))));
        }
        this.elementData[n] = l;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" >= ").append(this.elementCount))));
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            VectorLong.copy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0L;
    }

    public final synchronized void insertElementAt(long l, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" > ").append(this.elementCount))));
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorLong.copy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = l;
        ++this.elementCount;
    }

    public final synchronized void addElement(long l) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = l;
    }

    public final synchronized boolean removeElement(long l) {
        int n = this.indexOf(l);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0L;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(new Long(this.elementData[i]).toString());
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void copyFrom(long[] lArray) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this.elementData[i] = lArray[i];
        }
    }

    public void copyFrom(VectorLong vectorLong) {
        int n = vectorLong.size();
        for (int i = 0; i < n; ++i) {
            this.elementData[i] = vectorLong.elementAt(i);
        }
    }

    public static void copy(long[] lArray, long[] lArray2, int n) {
        for (int i = 0; i < n; ++i) {
            lArray2[i] = lArray[i];
        }
    }

    public static void copy(long[] lArray, int n, long[] lArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            lArray2[i + n2] = lArray[i + n];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public long nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("LongEnumerator");
    }
}

