#include <stdio.h>
#include <string.h>
#define DEC(c)  (((c) - ' ') & 077)
static char outname[200];
int ReadDataLine(FILE *f,char *buf)
{
        int c,i;

        i=0;
        while ((c=fgetc(f)) != EOF) {
                if (c == '\n') break;
                if (c != '\r') {
                        buf[i++] = c;
                }
        }
        buf[i] = 0;
        return(c == EOF ? 0 : 1);
}

static char *uudecode (FILE *f)
{
  register int n;
  register char ch, *p;
  char buf[2 * BUFSIZ];
  FILE *out;

  do {
          if (!ReadDataLine(f,buf)) return(NULL);
  }
  while (strncmp(buf,"begin",5));
  p = buf + 6;
  while (*p && (*p == ' '|| *p == '0' || *p == '6')) p++; 
  strcpy(outname,p);
  /* Create output file and set mode.  */ 
  out = fopen(outname,"wb");
  /* For each input line:  */
  while (1)
    {
        if (!ReadDataLine(f,buf)) break;
        if (!strncmp(buf,"end\r\n",5)) break;
          p = buf;

      /* N is used to avoid writing out all the characters at the end of
         the file.  */

      n = DEC (*p);
      if (n <= 0)
        break;
      for (++p; n > 0; p += 4, n -= 3)
        {
          if (n >= 3)
            {
              ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4; 
              fputc(ch,out);
              ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2; 
              fputc (ch,out);
              ch = DEC (p[2]) << 6 | DEC (p[3]);
              fputc (ch,out);
            }
          else
            {
              if (n >= 1)
                {
                  ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4; 
                  fputc (ch,out);
                }
              if (n >= 2)
                {
                  ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2; 
                  fputc (ch,out);
                }
            }
        }
    }

  fclose(out);
  return outname;
}

int main(int argc,char *argv[])
{
        FILE *f;

        if (argc <= 1) {
                printf("Usage: %s <input file>\n",argv[0]); 
                return(1);
        }
        f = fopen(argv[1],"rb");
        if (f == NULL) {
                printf("I can't find %s\n",argv[1]); 
                return(1);
        }
        uudecode(f);
        fclose(f);
        printf("Result decoded in %s\n",outname); 
        return(0);
}