/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.OutputStream;

public class PdfEncryptor
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    int[] myXref;

    protected PdfEncryptor(PdfReader pdfReader, OutputStream outputStream) throws DocumentException {
        super(new PdfDocument(), outputStream);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
    }

    public static void encrypt(PdfReader pdfReader, OutputStream outputStream, byte[] byArray, byte[] byArray2, int n2, boolean bl) throws DocumentException, IOException {
        PdfEncryptor pdfEncryptor = new PdfEncryptor(pdfReader, outputStream);
        pdfEncryptor.setEncryption(byArray, byArray2, n2, bl);
        pdfEncryptor.go();
    }

    public static void encrypt(PdfReader pdfReader, OutputStream outputStream, boolean bl, String string, String string2, int n2) throws DocumentException, IOException {
        PdfEncryptor pdfEncryptor = new PdfEncryptor(pdfReader, outputStream);
        pdfEncryptor.setEncryption(bl, string, string2, n2);
        pdfEncryptor.go();
    }

    protected void go() throws DocumentException, IOException {
        Object object;
        this.body = new PdfWriter.PdfBody(this.HEADER.length, this, true);
        this.os.write(this.HEADER);
        PdfObject[] pdfObjectArray = this.reader.xrefObj;
        this.myXref = new int[pdfObjectArray.length];
        int n2 = 1;
        int n3 = 1;
        while (n3 < pdfObjectArray.length) {
            if (pdfObjectArray[n3] != null) {
                this.myXref[n3] = n2++;
            }
            ++n3;
        }
        this.file.reOpen();
        int n4 = 1;
        while (n4 < pdfObjectArray.length) {
            if (pdfObjectArray[n4] != null) {
                this.addToBody(pdfObjectArray[n4]);
            }
            ++n4;
        }
        this.file.close();
        PdfIndirectReference pdfIndirectReference = null;
        PdfLiteral pdfLiteral = null;
        if (this.crypto != null) {
            object = this.body.add(this.crypto.getEncryptionDictionary());
            ((PdfIndirectObject)object).writeTo(this.os);
            pdfIndirectReference = ((PdfIndirectObject)object).getIndirectReference();
            pdfLiteral = this.crypto.getFileID();
        }
        this.os.write(this.body.getCrossReferenceTable());
        object = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference2 = new PdfIndirectReference(0, this.myXref[((PRIndirectReference)object).getNumber()]);
        PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
        PdfIndirectReference pdfIndirectReference3 = null;
        if (pRIndirectReference != null) {
            pdfIndirectReference3 = new PdfIndirectReference(0, this.myXref[pRIndirectReference.getNumber()]);
        }
        PdfWriter.PdfTrailer pdfTrailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfLiteral);
        this.os.write(pdfTrailer.toPdf(this));
        this.os.close();
    }

    int getNewObjectNumber(PdfReader pdfReader, int n2, int n3) {
        return this.myXref[n2];
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.file;
    }
}

