/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;

public class PDFObject
implements PDFConstants {
    protected PDF pdf;
    private PDFByteWriter out;
    private String open;
    private boolean ok;

    PDFObject(PDF pdf, PDFByteWriter writer, int objectNumber, int generationNumber) throws IOException {
        this.pdf = pdf;
        this.out = writer;
        this.out.println(objectNumber + " " + generationNumber + " obj");
        this.out.indent();
        this.ok = true;
    }

    void close() throws IOException {
        this.out.outdent();
        this.out.println("endobj");
        this.out.println();
        this.ok = false;
    }

    public void entry(int number) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter: 'PDFObject' was closed");
        }
        this.out.println(number);
    }

    public void entry(Object[] objs) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter: 'PDFObject' was closed");
        }
        this.out.print("[");
        int i2 = 0;
        while (i2 < objs.length) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(objs[i2]);
            ++i2;
        }
        this.out.printPlain("]");
        this.out.println();
    }

    PDFDictionary openDictionary() throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDictionary";
        PDFDictionary dictionary = new PDFDictionary(this.pdf, this.out, this);
        return dictionary;
    }

    void close(PDFDictionary dictionary) throws IOException {
        dictionary.close();
        this.open = null;
    }

    PDFStream openStream(String name, String[] encode) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFStream' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFStream";
        PDFStream stream = new PDFStream(this.pdf, this.out, name, this, encode);
        return stream;
    }

    void close(PDFStream stream) throws IOException {
        stream.close();
        this.open = null;
    }

    PDFDocInfo openDocInfo(PDF pdf) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDocInfo' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDocInfo";
        PDFDocInfo info = new PDFDocInfo(pdf, this.out, this);
        return info;
    }

    PDFCatalog openCatalog(PDF pdf, PDFRef pageTree) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFCatalog' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFCatalog";
        PDFCatalog catalog = new PDFCatalog(pdf, this.out, this, pageTree);
        return catalog;
    }

    PDFPageTree openPageTree(PDF pdf, PDFRef parent) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFPageTree' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFPageTree";
        PDFPageTree tree = new PDFPageTree(pdf, this.out, this, parent);
        return tree;
    }

    PDFPage openPage(PDF pdf, PDFRef parent) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFPage' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFPage";
        PDFPage page = new PDFPage(pdf, this.out, this, parent);
        return page;
    }

    PDFViewerPreferences openViewerPreferences(PDF pdf) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFViewerPreferences' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFViewerPreferences";
        PDFViewerPreferences prefs = new PDFViewerPreferences(pdf, this.out, this);
        return prefs;
    }

    PDFOutlineList openOutlineList(PDF pdf, PDFRef first, PDFRef last) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFOutlineList' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFOutlineList";
        PDFOutlineList list = new PDFOutlineList(pdf, this.out, this, first, last);
        return list;
    }

    PDFOutline openOutline(PDF pdf, PDFRef parent, String title, PDFRef prev, PDFRef next) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFOutline' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFOutline";
        PDFOutline outline = new PDFOutline(pdf, this.out, this, parent, title, prev, next);
        return outline;
    }
}

