/** \file 3D_World.h
    3D World.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_3D_WORLD
#define H_3D_WORLD

#include <WO_Collision.h>

#pragma comment(lib, "lib3D.lib")

/** This class provides maintenance for 3D Objects.
    It moves them, renders them and checks for events, which
    are sent to them. */
class World3D : public Collidable_World
{
public:
  World3D();
  ~World3D();

  /** These methods override the ones defined in WO_World.h */

  /** this checks to make sure that any Object added to a World3D
      is derived from Object3D.  Returns -1 if dynamic_cast fails. */
  virtual long add(Object* O);

  /** This verifies that the view passed to render() is a View3D.
      If not, it returns non-zero to skip rendering. */
  virtual long preRender(View& view);

  /** This implementation calls the view's postObjectRender() 
      after each object is rendered.*/
  virtual long postObjectRender(World_Object* O, View& view);

  long status() { return m_Status; }

protected:
  long m_Status;
};

#endif // H_3D_WORLD