//	TankFight.h
// SubFunction code for TankFight.cpp
// Controls all drawing commands and functions.
// Modifies EZGDI drawing functions.


#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

const double DEG = .0174532925;    	// Degree Constant
const double PI = 3.141592654;      // Pi Constant
const int MaxX = 640;					// Screen X Width
const int MaxY = 480;               // Screen X Width


// Declare global color constant
	COLORREF BGCol = BLACK;      	// color of the outlines



// Objects
struct strObj                    // This structure is used by the User Tank and
{											// the Enemy Units.
 	int objTyp; 		// Object Type. {0=Not in use,1=User Tank,2=Bomber...}
   double x;			// X Position.
   double y;      	// Y Position.
   double lx;			// Last X Position.
   double ly;      	// Last Y Position.
   double vx; 			// X Velocity.
   double vy; 			// Y Velocity.
   int angle;			// Object angle of rotation.
   int langle;			// Last Object angle of rotation.
   int hp;				// Object Hit Points.
   double lhp;			// Last Object Hit Points.
   int sp;				// Object Shield Points.
   double lsp;			// Last Object Shield Points.
   float scale;		// Last Object Scale.
   float lscale;		// Object Scale.
	int Gangle;			// Gun Angle.
	int lGangle;		// Last Gun Angle.
   int Gwait;			// Reload time.
   bool onGrnd;      // On the Ground??
   int smoke;			// Time 'till next smoke
   bool dead;			// Is object dead??
   int Gfx;				// Graphic currently displayed
   int lGfx;			// Last Graphic currently displayed
   bool PlaneSpin;	// Is Plane Spinning when dead?
};

// Bullets
struct strBul        // This structure is Used by the Bullets and Debris.
{
   double x;			// X Position.
   double y;      	// Y Position.
   double lx;			// Last X Position.
   double ly;      	// Last Y Position.
   int bulTyp; 		// Bullet Type. {0=Not in use,1=Debris,2=UserShot...}
   double vx; 			// X Velocity.
   double vy; 			// Y Velocity.
   int angle;			// Object angle of rotation.
   int langle;			// Last Object angle of rotation.
   float scale;		// Last Object Scale.
   float lscale;		// Object Scale.
   double grav;		// Gravity Factor.
   int dmg;				// Damage Inflicted.
   double grow;		// Amount of growth of Bullet's Scale.
   int EnTarget;		// Enemy Targeted.
};

struct strEx         // This structure is used by the Explosions.
{
   double x;			// X Position.
   double y;      	// Y Position.
   double lx;			// Last X Position.
   double ly;     	// Last Y Position.
   int xsize;     	// X Size of Explosion.
   int lxsize;     	// Last X Size of Explosion.
   int ysize;     	// Y Size of Explosion.
   int lysize;     	// Last Y Size of Explosion.
   int exTyp; 		   // Explosion Type. {0=Not in use,1=Regular,2=Cloud}
   double vx; 			// X Velocity.
   double vy; 			// Y Velocity.
};


// Lines
struct strLine{		// This is the Line structure
	int x1,x2;        // Two x coordinants
   int y1,y2;        // Two y coordinants
   COLORREF color;   // Line color
};

// Object Graphics
struct strGFXObj{    // Objects are drawn from < 20 Lines.
	strLine Ln[20];	// 20 Lines.
   int lnum;         // Number of Lines Used (to prevent needless drawing).
};

// Levels
struct strLevel{     // Level Structure
	int hgt[65];      // 65 Hights creates a bumpy terrain.
	int lhgt[65];		// Last Terrain (for Terrain Modifications during gamplay).
};

// Messages
struct strMsg{       // Message Structure
	int x;            // X Position.
   int y;            // Y Position.
   char* ch;         // Message String.
   int Rev;          // Revolutions that occurred.
   bool active;		// Is Msg active?
   int msgTyp;       // Type of action that msg produces(1=blinking,2=rising..)
};
///////////////////////////////////////////////////////////////////////////////
void Rotate (int &x, int &y, double angle)
// This Function rotates a point.
// The Coordinates (x,y) and angle are given.
// Output is the newly rotated Coordinates (x,y).
{
	double degree;							// Point will be rotated by angle + degree
   double dist;                     // Point Distance (Pythagorean Thm.)
   if (y==0) degree = 90*DEG;      	// Error Checking (divide by zero).
   else degree = (2.*PI) + atan(double(x)/double(y));
   											// In case of Divide by Zero
   if (y<0) degree+=PI;             // If y is negative, add 180 degrees.
   if (y==0 && x<=0) degree-=PI;    // If y is 0, subtract 180 degrees
   degree = degree/DEG;             // convert to degree format.
   angle += degree;                 // angle + degree is final angle.
   dist = sqrt(x*x + y*y);          // find linear distance (Pythagorean Thm.)

   x = dist * sin( angle * DEG );  	// calculate new x,
   y = dist * cos( angle * DEG );   // and new y coordinants.
}

////////////////////////////////////////////////////////////////////////////////
void Line (int x1,int y1,int x2,int y2,COLORREF color)
// This Function draws a COLORED line.
{
	SetColorRGB(color);             			// set color
	DrawLine(x1,MaxY - y1,x2,MaxY - y2);   // Draw Line reversing the Y co.
}
////////////////////////////////////////////////////////////////////////////////
void Pixel (int x,int y,COLORREF color)
// This Function draws a COLORED Pixel.
{
	SetColorRGB(color);
	SetPixel(x,MaxY - y);                  // Draw Pixel reversing the Y co.
}
////////////////////////////////////////////////////////////////////////////////
COLORREF GetPix (int x,int y)
// This Function returns pixel color at x,y
{
	return GetPixel(x,MaxY - y);           // Get Pixel reversing the Y co.
}


////////////////////////////////////////////////////////////////////////////////
void DrawObj(strGFXObj Obj,int x,int y,int angle,float scale, double dir)
// Thif Function draws an object and rotates it.
{
	int x1,y1,x2,y2;                       // temp variables.
   if ((dir == 0) || (dir == 1)) dir = 1; // error checking (devide by zero).
   else dir = -abs(dir)/dir;              // make direction 1 or -1.
	for(int i=1;i<=Obj.lnum;i++)           // for loop for all Lines
   {
   	x1 = Obj.Ln[i].x1 * scale * dir;    // fill in the temp variables
      x2 = Obj.Ln[i].x2 * scale * dir;    // with the Line values
      y1 = Obj.Ln[i].y1 * scale;          // relative to the direction
      y2 = Obj.Ln[i].y2 * scale;          // and the scale.
      if (!angle == 0){                   // If angle is not 0,
      	Rotate(x1,y1,angle);             // Rotate the line coordinants.
      	Rotate(x2,y2,angle);
      }
   	Line(x1+x,y1+y,x2+x,y2+y,Obj.Ln[i].color); 	// FINALY, draw the line.
   }
}
////////////////////////////////////////////////////////////////////////////////
void ClrObj(strGFXObj Obj,int x,int y,int angle,float scale, double dir)
// Thif Function erases the object.
{
	int x1,y1,x2,y2;                        // temp variables.
   if ((dir == 0) || (dir == 1)) dir = 1;  // error checking (devide by zero).
   else dir = -abs(dir)/dir;               // make direction 1 or -1.
   for(int i=1;i<=Obj.lnum;i++)            // for loop for all Lines
   {
   	x1 = Obj.Ln[i].x1 * scale * dir;     // fill in the temp variables
      x2 = Obj.Ln[i].x2 * scale * dir;     // with the Line values
      y1 = Obj.Ln[i].y1 * scale;           // relative to the direction
      y2 = Obj.Ln[i].y2 * scale;           // and the scale.
      if (!angle == 0){                    // If angle is not 0,
      	Rotate(x1,y1,angle);              // Rotate the line coordinants.
      	Rotate(x2,y2,angle);
      }
   	Line(x1+x,y1+y,x2+x,y2+y,BGCol);       		// FINALY, Erase the line.
   }

}
////////////////////////////////////////////////////////////////////////////////
void Circle (int x1,int y1,int x2,int y2,COLORREF color)
// This Function draws a COLORED circle.
{
	SetColorRGB(color);                      // Set the color
	Ellipse(x1,MaxY - y1,x2,MaxY - y2);      // Draw Ellipse reversing the Y co.
	SetColorRGB(BGCol);
}
////////////////////////////////////////////////////////////////////////////////
void Rect (int x1,int y1,int x2,int y2,COLORREF col)
// This Function draws a COLORED Rectangle.
{
	SetColorRGB(col);                      // Set the color
	Rectangle(x1,MaxY - y1,x2,MaxY - y2);    // Draw Rectangle reversing the Y co
	SetColorRGB(BGCol);
}
////////////////////////////////////////////////////////////////////////////////
void Text (int x1,int y1,char ch[],COLORREF color)
// This Function draws COLORED text.
{
	SetColorRGB(color);                      // Set the color
   PutText(ch,x1,MaxY - y1);                // Draw Text reversing the Y co
	SetColorRGB(BGCol);
}

