//----------------------------------------------------------
#include <vcl\vcl.h>
#include <checks.h>
#pragma hdrstop

#include "FrmMatl.h"
#include "D3dUtil.h"
//----------------------------------------------------------
#pragma resource "*.dfm"
TMaterialForm *MaterialForm;
//----------------------------------------------------------
__fastcall TMaterialForm::TMaterialForm(TComponent* Owner) :
  TForm(Owner) {
}//---------------------------------------------------------
__fastcall TMaterialForm::~TMaterialForm() {
  if (IRMMaterial) IRMMaterial->Release();
}//---------------------------------------------------------
void __fastcall TMaterialForm::SetNone() {
  if (IRMMaterial) IRMMaterial->Release();
  IRMMaterial = NULL;
  Caption = "Material: No Selection";
  EnableControls(false);
}//---------------------------------------------------------
void __fastcall TMaterialForm::Manage(void* object) {
  FObject = NULL;
  if (IRMMaterial) IRMMaterial->Release();
  IRMMaterial = NULL;
  AnsiString cname = RMClassName(object);
  if (cname == "Frame") {
     Caption = "Frame Material Mode";
     FObject = object;
     EnableControls(false);
     laMatMode->Enabled = true;
     MatModeCombo->Enabled = true;
     MatModeCombo->ItemIndex =
                         ASFRAME(object)->GetMaterialMode();
  }
  else
  if (cname == "Face") {
     ASFACE(object)->GetMaterial(&IRMMaterial);
     Caption = "Face Material";
     FObject = object;
     GetMaterialData();
  }
  else
  if (cname == "Builder") {
     LPDIRECT3DRMFACE IFace = NULL;
     LPDIRECT3DRMFACEARRAY IFaces = NULL;
     ASBUILDER(object)->GetFaces(&IFaces);
     if (IFaces && IFaces->GetSize())
        IFaces->GetElement(0, &IFace);
     if (IFaces) IFaces->Release();
     if (IFace) {
        IFace->GetMaterial(&IRMMaterial);
        IFace->Release();
        Caption = "Builder Material";
        FObject = object;
        GetMaterialData();
     } else SetNone();
  }
  else SetNone();
}//---------------------------------------------------------
void __fastcall TMaterialForm::GetMaterialData() {
  if (!Visible) return;
  DecimalSeparator = '.';
  if (!IRMMaterial) {
     EnableControls(false);
     if (FObject) btnNew->Enabled = true;
     return;
  }
  IsReading = true;
  EnableControls(true);
  btnNew->Enabled = false;
  if (!IsFrame(FObject)) MatModeCombo->Enabled = false;
  //      
  //  :
  /*
  LPDIRECT3DMATERIAL IMaterial = NULL;
  IRMMaterial->QueryInterface(IID_IDirect3DMaterial,
                                       (void**) &IMaterial);
  if (IMaterial) {
     D3DMATERIAL Mat;
     IMaterial->GetMaterial(&Mat);
     D3DCOLORVALUE diffuse = Mat.diffuse;
     D3DCOLORVALUE ambient = Mat.ambient;
     IMaterial->Release();
  }*/

  IRMMaterial->GetEmissive(&EmR, &EmG, &EmB);
  IRMMaterial->GetSpecular(&SpR, &SpG, &SpB);
  Power = IRMMaterial->GetPower();

  tbEmR->Position = EmR*tbEmR->Max;
  laEmR->Caption  = FloatToStrF(EmR, ffFixed, 15, 3);
  tbEmG->Position = EmG*tbEmG->Max;
  laEmG->Caption  = FloatToStrF(EmG, ffFixed, 15, 3);
  tbEmB->Position = EmB*tbEmB->Max;
  laEmB->Caption  = FloatToStrF(EmB, ffFixed, 15, 3);
  EmissiveShape->Brush->Color =
     TColor(RGB(int(255*EmR), int(255*EmG), int(255*EmB)));
  tbSpR->Position = SpR*tbSpR->Max;
  laSpR->Caption  = FloatToStrF(SpR, ffFixed, 15, 3);
  tbSpG->Position = SpG*tbSpG->Max;
  laSpG->Caption  = FloatToStrF(SpG, ffFixed, 15, 3);
  tbSpB->Position = SpB*tbSpB->Max;
  laSpB->Caption  = FloatToStrF(SpB, ffFixed, 15, 3);
  SpecularShape->Brush->Color =
     TColor(RGB(int(255*SpR), int(255*SpG), int(255*SpB)));
  edPower->Text = FloatToStrF(Power, ffFixed, 15, 3);
  IsReading = false;
}//---------------------------------------------------------
void __fastcall TMaterialForm::MaterialChanged(TObject*) {
  if (IsReading || !IRMMaterial) return;

  EmR = float(tbEmR->Position) / tbEmR->Max;
  EmG = float(tbEmG->Position) / tbEmG->Max;
  EmB = float(tbEmB->Position) / tbEmB->Max;
  SpR = float(tbSpR->Position) / tbSpR->Max;
  SpG = float(tbSpG->Position) / tbSpG->Max;
  SpB = float(tbSpB->Position) / tbSpB->Max;
  IRMMaterial->SetEmissive(EmR, EmG, EmB);
  IRMMaterial->SetSpecular(SpR, SpG, SpB);
  try {
     DecimalSeparator = '.';
     Power = edPower->Text.ToDouble();
     IRMMaterial->SetPower(Power);
  } catch (Exception &exception) {
     Application->ShowException(&exception);
  }

  AnsiString cname = RMClassName(FObject);
  if (cname == "Builder") {
     ASBUILDER(FObject)->SetMaterial(IRMMaterial);
     IRMMaterial->Release(); IRMMaterial = NULL;
  }
  else
  if (cname == "Face") {
     ASFACE(FObject)->SetMaterial(IRMMaterial);
     IRMMaterial->Release(); IRMMaterial = NULL;
  }

  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TMaterialForm::edPowerKeyPress(TObject*,
  char &Key)
{
  if (Key == VK_RETURN) MaterialChanged(this);
}//---------------------------------------------------------
void __fastcall TMaterialForm::EnableControls(bool enable) {
  for (int i = 0; i < ComponentCount; i++) {
     TControl *Control =
            dynamic_cast<TControl*>(Components[i]);
     if (Control) Control->Enabled = enable;
  }
}//---------------------------------------------------------
void __fastcall TMaterialForm::FormActivate(TObject*) {
  GetMaterialData();
}//---------------------------------------------------------
void __fastcall TMaterialForm::btnNewClick(TObject *) {
  if (IRMMaterial) return;
  LPDIRECT3DRM IRM;
  Direct3DRMCreate(&IRM);
  if (IRM) {
     IRM->CreateMaterial(0, &IRMMaterial);
     GetMaterialData();
     IRM->Release();
  }
}//---------------------------------------------------------
void __fastcall TMaterialForm::FormKeyDown(TObject*,
  WORD &Key, TShiftState)
{
  if (Key == VK_ESCAPE) Close();
}//---------------------------------------------------------
void __fastcall TMaterialForm::MatModeComboClick(TObject*) {
  ASFRAME(FObject)->SetMaterialMode(
                D3DRMMATERIALMODE(MatModeCombo->ItemIndex));
  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TMaterialForm::EmissiveShapeMouseDown(
    TObject*, TMouseButton , TShiftState, int, int)
{
  ColorDlg->Color = EmissiveShape->Brush->Color;
  if (!ColorDlg->Execute()) return;
  EmissiveShape->Brush->Color = ColorDlg->Color;
  tbEmR->Position = GetRValue(ColorToRGB(ColorDlg->Color));
  tbEmG->Position = GetGValue(ColorToRGB(ColorDlg->Color));
  tbEmB->Position = GetBValue(ColorToRGB(ColorDlg->Color));
  MaterialChanged(this);
}//---------------------------------------------------------
void __fastcall TMaterialForm::SpecularShapeMouseDown(
    TObject*, TMouseButton, TShiftState, int, int)
{
  ColorDlg->Color = SpecularShape->Brush->Color;
  if (!ColorDlg->Execute()) return;
  SpecularShape->Brush->Color = ColorDlg->Color;
  tbSpR->Position = GetRValue(ColorToRGB(ColorDlg->Color));
  tbSpG->Position = GetGValue(ColorToRGB(ColorDlg->Color));
  tbSpB->Position = GetBValue(ColorToRGB(ColorDlg->Color));
  MaterialChanged(this);
}//---------------------------------------------------------
