//----------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FrmTextr.h"
#include "D3dUtil.h"
//----------------------------------------------------------
#pragma resource "*.dfm"
TTextureForm *TextureForm;
//----------------------------------------------------------
__fastcall TTextureForm::TTextureForm(TComponent* Owner) :
  TForm(Owner) {
}//---------------------------------------------------------
__fastcall TTextureForm::~TTextureForm() {
  RELEASE(IRMTexture);
}//---------------------------------------------------------
void __fastcall TTextureForm::SetNone() {
  RELEASE(IRMTexture);
  Caption   = "Texture: No Selection";
  EnableControls(false);
}//---------------------------------------------------------
void __fastcall TTextureForm::Manage(void* object) {
  FObject = NULL;
  RELEASE(IRMTexture);
  AnsiString cname = RMClassName(object);
  if (cname == "Texture") {
     IRMTexture = ASTEXTURE(object);
     IRMTexture->AddRef();
     Caption = "Texture Properties";
     FObject = object;
     GetTextureData();
  }
  else
  if (cname == "Face") {
     ASFACE(object)->GetTexture(&IRMTexture);
     Caption = "Face Texture";
     FObject = object;
     GetTextureData();
  }
  else
  if (cname == "Frame") {
     ASFRAME(object)->GetTexture(&IRMTexture);
     Caption = "Frame Texture";
     FObject = object;
     GetTextureData();
  }
  else
  if (cname == "Builder") {
     LPDIRECT3DRMFACE IFace = NULL;
     LPDIRECT3DRMFACEARRAY IFaces = NULL;
     ASBUILDER(object)->GetFaces(&IFaces);
     if (IFaces) {
        if (IFaces->GetSize())
           IFaces->GetElement(0, &IFace);
        IFaces->Release();
     }
     if (IFace) {
        IFace->GetTexture(&IRMTexture);
        IFace->Release();
        Caption = "Builder Texture";
        FObject = object;
        GetTextureData();
     } else SetNone();
  }
  else SetNone();
}//---------------------------------------------------------
void __fastcall TTextureForm::GetTextureData() {
  if (!Visible) return;
  DecimalSeparator = '.';
  if (!IRMTexture) {
     EnableControls(false);
     return;
  }
  IsReading = true;
  EnableControls(true);
  //   :
  Colors = IRMTexture->GetColors();
  Shades = IRMTexture->GetShades();
  Transparency = IRMTexture->GetDecalTransparency();
  TransColor = IRMTexture->GetDecalTransparentColor();
  IRMTexture->GetDecalOrigin(&OriginX, &OriginY);
  DecalScale = IRMTexture->GetDecalScale();
  IRMTexture->GetDecalSize(&DecalWidth, &DecalHeight);
  //     :
  edColors->Text    = IntToStr(Colors);
  edShades->Text    = IntToStr(Shades);
  cbTransparent->Checked = Transparency;
  edOriginX->Text   = IntToStr(OriginX);
  edOriginY->Text   = IntToStr(OriginY);
  cbScaled->Checked = DecalScale;
  edWidth->Text     = FloatToStrF(DecalWidth,ffFixed,15,3);
  edHeight->Text    = FloatToStrF(DecalHeight,ffFixed,15,3);
  D3DVALUE r = D3DRMColorGetRed(TransColor);
  D3DVALUE g = D3DRMColorGetGreen(TransColor);
  D3DVALUE b = D3DRMColorGetBlue(TransColor);
  tbRed->Position     = tbRed->Max   * r;
  tbGreen->Position   = tbGreen->Max * g;
  tbBlue->Position    = tbBlue->Max  * b;
  laR->Caption        = FloatToStrF(r, ffFixed, 15, 3);
  laG->Caption        = FloatToStrF(g, ffFixed, 15, 3);
  laB->Caption        = FloatToStrF(b, ffFixed, 15, 3);
  laTexPath->Caption  = RMName(IRMTexture);
  laTexPath->Hint     = laTexPath->Caption;
  Shape->Brush->Color =
            TColor(RGB(int(255*r), int(255*g), int(255*b)));
  IsReading = false;
}//---------------------------------------------------------
void __fastcall TTextureForm::TextureChanged(TObject*) {
  if (IsReading || !IRMTexture) return;

  try {
     //     :
     DecimalSeparator = '.';
     Colors       = edColors->Text.ToInt();
     Shades       = edShades->Text.ToInt();
     Transparency = cbTransparent->Checked;
     OriginX      = edOriginX->Text.ToInt();
     OriginY      = edOriginY->Text.ToInt();
     DecalScale   = cbScaled->Checked;
     DecalWidth   = edWidth->Text.ToDouble();
     DecalHeight  = edHeight->Text.ToDouble();
     D3DVALUE r   = float(tbRed->Position)   / tbRed->Max;
     D3DVALUE g   = float(tbGreen->Position) / tbGreen->Max;
     D3DVALUE b   = float(tbBlue->Position)  / tbBlue->Max;
     TransColor   = D3DRMCreateColorRGB(r, g, b);
     //   :
     IRMTexture->SetColors(Colors);
     IRMTexture->SetShades(Shades);
     IRMTexture->SetDecalTransparency(Transparency);
     IRMTexture->SetDecalTransparentColor(TransColor);
     IRMTexture->SetDecalOrigin(OriginX, OriginY);
     IRMTexture->SetDecalScale(DecalScale);
     IRMTexture->SetDecalSize(DecalWidth, DecalHeight);
     //    :
     AssignTexture(IRMTexture);
  }  catch (Exception &exception) {
     Application->ShowException(&exception);
  }
  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TTextureForm::EditorsKeyPress(TObject*,
  char &Key)
{
  if (Key == VK_RETURN) TextureChanged(this);
}//---------------------------------------------------------
void __fastcall TTextureForm::EnableControls(bool enable) {
  for (int i = 0; i < ComponentCount; i++) {
     TControl *Control =
                     dynamic_cast<TControl*>(Components[i]);
     if (Control) Control->Enabled = enable;
  }
  btnOpen->Enabled = true;
  if (FObject && IsTexture(FObject)) {
     btnOpen->Enabled   = false;
     btnReload->Enabled = false;
     btnRemove->Enabled = false;
  }
}//---------------------------------------------------------
void __fastcall TTextureForm::FormActivate(TObject*) {
  GetTextureData();
}//---------------------------------------------------------
void __fastcall TTextureForm::FormKeyDown(TObject*,
  WORD &Key, TShiftState)
{
  if (Key == VK_ESCAPE) Close();
}//---------------------------------------------------------
void __fastcall TTextureForm::AssignTexture(
  LPDIRECT3DRMTEXTURE ITex)
{
  if (!FObject) return;
  AnsiString cname = RMClassName(FObject);
  if (cname == "Face") ASFACE(FObject)->SetTexture(ITex);
  else
  if (cname=="Builder")ASBUILDER(FObject)->SetTexture(ITex);
  else
  if (cname == "Frame")ASFRAME(FObject)->SetTexture(ITex);
  if (ITex) ITex->Release();
  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TTextureForm::btnRemoveClick(TObject*) {
  AssignTexture(NULL);
}//---------------------------------------------------------
void __fastcall TTextureForm::btnOpenClick(TObject*) {
  if (!FObject) return;
  if (!OpenDlg->Execute()) return;
  LPDIRECT3DRM IRM = NULL;
  Direct3DRMCreate(&IRM);
  if (!IRM) return;

  RELEASE(IRMTexture);
  HRESULT hr = IRM->LoadTexture(OpenDlg->FileName.c_str(),
                                               &IRMTexture);
  if (HR_FAILED(hr)) {
     Application->MessageBox("Could't load texture",
                          "Load error", MB_ICONEXCLAMATION);
     RELEASE(IRMTexture);
  }
  RELEASE(IRM);
  AssignTexture(IRMTexture);
}//---------------------------------------------------------
void __fastcall TTextureForm::btnReloadClick(TObject*) {
  if (!FObject) return;
  LPDIRECT3DRM IRM = NULL;
  Direct3DRMCreate(&IRM);
  if (!IRM) return;

  RELEASE(IRMTexture);
  HRESULT hr = IRM->LoadTexture(laTexPath->Caption.c_str(),
                                               &IRMTexture);
  if (HR_FAILED(hr)) {
     Application->MessageBox("Could't reload texture",
                          "Load error", MB_ICONEXCLAMATION);
     RELEASE(IRMTexture);
  }
  RELEASE(IRM);
  //       
  //     :
  TextureChanged(this);
}//---------------------------------------------------------
void __fastcall TTextureForm::ShapeMouseDown(
    TObject*, TMouseButton, TShiftState, int, int)
{
  ColorDlg->Color = Shape->Brush->Color;
  if (!ColorDlg->Execute()) return;
  Shape->Brush->Color = ColorDlg->Color;
  tbRed->Position   =GetRValue(ColorToRGB(ColorDlg->Color));
  tbGreen->Position =GetGValue(ColorToRGB(ColorDlg->Color));
  tbBlue->Position  =GetBValue(ColorToRGB(ColorDlg->Color));
  TextureChanged(this);
}//---------------------------------------------------------
