/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.CIFF;
import photoorganizer.formats.Exif;
import photoorganizer.formats.JFXX;
import photoorganizer.renderer.HashPropTableModel;
import photoorganizer.renderer.PropertiesTableModel;

public class PropertiesPanel
extends JTabbedPane {
    public PropertiesPanel(BasicJpeg basicJpeg) {
        AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
        if (abstractImageInfo instanceof Exif) {
            this.insertTab("Main", null, new JScrollPane(new JTable(new PropertiesTableModel((Exif)abstractImageInfo))), "Main image IFD", 0);
            this.insertTab("Thumbnail", null, new JScrollPane(new JTable(new PropertiesTableModel((Exif)abstractImageInfo, false))), "Thumbnail image IFD", 1);
        } else if (abstractImageInfo instanceof JFXX) {
            this.insertTab("Picture", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractImageInfo).getPictureInfo()))), "[Picture info]", 0);
            this.insertTab("Camera", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractImageInfo).getCameraInfo()))), "[Camera info]", 1);
            this.insertTab("Diagnostic", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractImageInfo).getDiagInfo()))), "[Diag info]", 2);
        } else if (abstractImageInfo instanceof CIFF) {
            this.insertTab("Heap", null, new JScrollPane(new JTable(new HashPropTableModel(((CIFF)abstractImageInfo).getProperties()))), "CIFF Heap", 0);
        }
    }

    public void setProperties(BasicJpeg basicJpeg) {
    }

    public static void showProperties(BasicJpeg basicJpeg, Controller controller) {
        JFrame jFrame = new JFrame("Properties of " + basicJpeg.getLocationName());
        jFrame.getContentPane().add(new PropertiesPanel(basicJpeg));
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
        ((Frame)jFrame).setIconImage(controller.getMainIcon());
    }
}

