// WinPlot3DP.cpp : implementation of the WinPlot3DP class
// Concrete plotting class derived from Plot3DZ abstract class

#include "stdafx.h"
#include "plot3DP.h"
#include "..\common\winplot3d.h"
#include "..\common\PlotCalc.h"

#ifndef	_WINPLOT3DP_H_
#define	_WINPLOT3DP_H_	1	// avoid re-including

/////////////////////////////////////////////////////////////////////////////
class WinPlot3DP : public WinPlot3D, public Plot3DP
{
public:
	WinPlot3DP()
	{
		m_pXPlotCalc = new PlotCalc;
		m_pYPlotCalc = new PlotCalc;
		m_pZPlotCalc = new PlotCalc;
		m_pRPlotCalc = new PlotCalc;
		m_pGPlotCalc = new PlotCalc;
		m_pBPlotCalc = new PlotCalc;
	}
	~WinPlot3DP()
	{
		delete m_pXPlotCalc;
		delete m_pYPlotCalc;
		delete m_pZPlotCalc;
		delete m_pRPlotCalc;
		delete m_pGPlotCalc;
		delete m_pBPlotCalc;
	}

	// map to WinPlot3D
	virtual void MoveTo(int xv,int yv) { WinMoveTo(xv,yv);    }
	virtual void DrawTo(int xv,int yv) { WinDrawTo(xv,yv);    }
	virtual void ColorTo(long color)   { WinColorTo(color);   }
	virtual void SetPixelColor(int xv,int yv,long color) { WinSetPixelColor(xv,yv,color);  }
	virtual void PlotText(AXIS_PLOT_INFO* pAxisInfo,double degrees,
		int xv,int yv,CString text)    { WinPlotText(pAxisInfo,degrees,xv,yv,text);   }

	// call back routines
	virtual void cbBegPlot()           { WinBegPlot();        }
	virtual void cbEndPlot()           { WinEndPlot();        }
	virtual void cbCheckUserAbort()    { if (IsAbortRequested()) DoAbort(); }

	// must defined these
	virtual double XParametric(double u,double v) { return( m_pXPlotCalc->Calc(u,v) ); }
	virtual double YParametric(double u,double v) { return( m_pYPlotCalc->Calc(u,v) ); }
	virtual double ZParametric(double u,double v) { return( m_pZPlotCalc->Calc(u,v) ); }

	// color info
	virtual double RedColor(double u,double v)
	{
		double c=m_pRPlotCalc->Calc(u,v);
		if(c<PLOT3D_MIN_COLOR)
		   c=PLOT3D_MIN_COLOR;
		if(c>PLOT3D_MAX_COLOR)
		   c=PLOT3D_MAX_COLOR;
		return(c);
	}
	virtual double GreenColor(double u,double v)
	{
		double c=m_pGPlotCalc->Calc(u,v);
		if(c<PLOT3D_MIN_COLOR)
		   c=PLOT3D_MIN_COLOR;
		if(c>PLOT3D_MAX_COLOR)
		   c=PLOT3D_MAX_COLOR;
		return(c);
	}
	virtual double BlueColor(double u,double v)
	{
		double c=m_pBPlotCalc->Calc(u,v);
		if(c<PLOT3D_MIN_COLOR)
		   c=PLOT3D_MIN_COLOR;
		if(c>PLOT3D_MAX_COLOR)
		   c=PLOT3D_MAX_COLOR;
		return(c);
	}

	PlotCalc* m_pXPlotCalc;  // X Equation Calculator
	PlotCalc* m_pYPlotCalc;  // Y Equation Calculator
	PlotCalc* m_pZPlotCalc;  // Z Equation Calculator
	PlotCalc* m_pRPlotCalc;  // R Equation Calculator
	PlotCalc* m_pGPlotCalc;  // G Equation Calculator
	PlotCalc* m_pBPlotCalc;  // B Equation Calculator

	CString m_surface_name;
};

#endif	// _WINPLOT3DP_H_

// ------------------------------  end WinPlot3DP.H  ----------------------------

