unit GLE2000P;
{ Print Unit  Version 3.1  31st December 1999
  Controls printer output. Tested with H.P. Deskjet and
  Cannon BJC-240 Printers }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin,GLE2000T;

type
  TPrintForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    SpinButton1: TSpinButton;
    SpinButton2: TSpinButton;
    Label4: TLabel;
    Label5: TLabel;
    Edit3: TEdit;
    SpinButton3: TSpinButton;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Label6: TLabel;
    procedure SpinButton1DownClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure SpinButton2DownClick(Sender: TObject);
    procedure SpinButton2UpClick(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure SpinButton3DownClick(Sender: TObject);
    procedure SpinButton3UpClick(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PrintForm: TPrintForm;
  TopMargin,LeftMargin,ImageScale:double;
  PrintFullPage:Boolean;

implementation

{$R *.DFM}

uses GLE2000D;

var  TMargin,LMargin,IScale:double;

procedure TPrintForm.SpinButton1DownClick(Sender: TObject);
var s1:string;
begin
     TMargin:= TMargin-0.1;
     If TMargin<0.2 then TMargin:= 0.2;
     If TMargin>30.0 then TMargin:= 30.0;
     Str(TMargin:6:2,s1);
     Edit1.Text:= s1;
end;

procedure TPrintForm.FormCreate(Sender: TObject);
begin
   PrintForm.Color:= Parchment;
   TopMargin:= 2.5;
   TMargin:= 2.5;
   LeftMargin:= 1.2;
   LMargin:= 2.5;
   ImageScale:= 1.0;
   IScale:= 1.0;
   PrintFullpage:= True;
end;

procedure TPrintForm.SpinButton1UpClick(Sender: TObject);
var s1:string;
begin
     TMargin:= TMargin+0.1;
     If TMargin<0.2 then TMargin:= 0.2;
     If TMargin>30.0 then TMargin:= 30.0;
     Str(TMargin:6:2,s1);
     Edit1.Text:= s1;
end;

procedure TPrintForm.Button2Click(Sender: TObject);
{Rejects settings}
begin
     PrintForm.Hide;
end;

procedure TPrintForm.Button1Click(Sender: TObject);
{Accepts settings}
begin
   TopMargin:= TMargin;
   LeftMargin:= Lmargin;
   ImageScale:= IScale;
   if CheckBox1.Checked then PrintFullpage:= True else PrintFullPage:= False;
   PrintForm.Hide
end;

procedure TPrintForm.Edit1Change(Sender: TObject);
var code:integer;
    s1:string;
begin
  str(TMargin:6:2,s1);
  Val(Edit1.Text,TMargin,Code);
  If TMargin<0.2 then TMargin:= 0.2;
  If TMargin>30.0 then TMargin:= 30.0;
end;

procedure TPrintForm.SpinButton2DownClick(Sender: TObject);
var s1:string;
begin
     LMargin:= LMargin-0.1;
     If LMargin<0.2 then LMargin:= 0.2;
     If LMargin>30.0 then LMargin:= 30.0;
     Str(LMargin:6:2,s1);
     Edit2.Text:= s1;
end;

procedure TPrintForm.SpinButton2UpClick(Sender: TObject);
var s1:string;
begin
     LMargin:= LMargin+0.1;
     If LMargin<0.2 then LMargin:= 0.2;
     If LMargin>30.0 then LMargin:= 30.0;
     Str(LMargin:6:2,s1);
     Edit2.Text:= s1;
end;

procedure TPrintForm.Edit2Change(Sender: TObject);
var code:integer;
    s1:string;
begin
  str(LMargin:6:2,s1);
  Val(Edit2.Text,LMargin,Code);
  If LMargin<0.2 then LMargin:= 0.2;
  If LMargin>30.0 then LMargin:= 30.0;
end;

procedure TPrintForm.SpinButton3DownClick(Sender: TObject);
var s1:string;
begin
     IScale:= IScale-0.1;
     If IScale<0.2 then IScale:= 0.2;
     If IScale>5.0 then IScale:= 5.0;
     Str(IScale:6:2,s1);
     Edit3.Text:= s1;
end;

procedure TPrintForm.SpinButton3UpClick(Sender: TObject);
var s1:string;
begin
     IScale:= IScale+0.1;
     If IScale<0.2 then IScale:= 0.2;
     If IScale>5.0 then IScale:= 5.0;
     Str(IScale:6:2,s1);
     Edit3.Text:= s1;

end;

procedure TPrintForm.Edit3Change(Sender: TObject);
var code:integer;
    s1:string;
begin
  str(IScale:6:2,s1);
  Val(Edit3.Text,IScale,Code);
  If IScale<0.2 then IScale:= 0.2;
  If IScale>5.0 then IScale:= 5.0;
end;

end.
