//	<><><><><><><><><><><><><>  WinPlotReg.cpp  <><><><><><><><><><><><><><> */
//		
// ----------------------------------------------------
//
// Windows Registry Routines
//
// ----------------------------------------------------

#include "stdafx.h"
#include "WinPlotReg.H"

//
// all routines return 0 if ok
//
// -----------------------------------------------------------------------------
//                 Open Registry Routine
// -----------------------------------------------------------------------------
int OpenReg(const char* keystr,int create,HKEY* phkey)
{
	int rc;
	rc = RegOpenKeyEx(HKEY_LOCAL_MACHINE,keystr,0,KEY_QUERY_VALUE,phkey);
	if (rc != ERROR_SUCCESS && create)
	{
		// Attempt to create the key
		DWORD dwDisposition;
		rc = RegCreateKeyEx(HKEY_LOCAL_MACHINE,keystr,0,NULL,REG_OPTION_NON_VOLATILE,
			KEY_ALL_ACCESS,NULL,phkey,&dwDisposition);
	}
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int CloseReg(HKEY hkey)
{
	int rc;
	rc = RegCloseKey(hkey);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
//      Get Registry Routines;  Does not modify output values if key does not exist
// -----------------------------------------------------------------------------
int GetRegStr(HKEY hkey,const char* keystr,char* str,unsigned strsize)
{
	int rc;
	DWORD dwType;
	DWORD dwDataSize = strsize;
 	rc = RegQueryValueEx(hkey,keystr,0,&dwType,(LPBYTE)str,&dwDataSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int GetRegInt(HKEY hkey,const char* keystr,int* pival)
{
	int rc;
	DWORD itemp;
	DWORD dwType;
	DWORD dwDataSize = sizeof(int);
 	rc = RegQueryValueEx(hkey,keystr,0,&dwType,(LPBYTE)&itemp,&dwDataSize);
	if (rc == ERROR_SUCCESS)
	{
		*pival = itemp;
		return(0);
	}
	return(1);
}

// -----------------------------------------------------------------------------
int GetRegLong(HKEY hkey,const char* keystr,long* plval)
{
	int rc;
	DWORD itemp;
	DWORD dwType;
	DWORD dwDataSize = sizeof(int);
 	rc = RegQueryValueEx(hkey,keystr,0,&dwType,(LPBYTE)&itemp,&dwDataSize);
	if (rc == ERROR_SUCCESS)
	{
		*plval = (long)itemp;
		return(0);
	}
	return(1);
}

// -----------------------------------------------------------------------------
int GetRegDouble(HKEY hkey,const char* keystr,double* pdval)
{
	double dtemp;
	char tempbuf[100];
	if (GetRegStr(hkey,keystr,tempbuf,sizeof(tempbuf))==0)
	{
		if (sscanf(tempbuf,"%lf",&dtemp)!=EOF)
		{
			*pdval = (double)dtemp;
			return(0);
		}
	}
	return(1);
}


// -----------------------------------------------------------------------------
//      Set Registry Routines;  Will create does not exist
// -----------------------------------------------------------------------------
int SetRegStr(HKEY hkey,const char* keystr,const char* str)
{
	int rc;
	DWORD dwDataSize = strlen(str);
	rc = RegSetValueEx(hkey,keystr,0,REG_SZ,(LPBYTE)str,dwDataSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int SetRegDouble(HKEY hkey,const char* keystr,double dval)
{
	int rc;
	DWORD dwDataSize;
	char tempbuf[20];
	sprintf(tempbuf,"%10.5f",dval);
	dwDataSize=strlen(tempbuf);
	rc = RegSetValueEx(hkey,keystr,0,REG_SZ,(LPBYTE)tempbuf,dwDataSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int SetRegInt(HKEY hkey,const char* keystr,int ival)
{
	int rc;
	DWORD dwDataSize = sizeof(ival);
	rc = RegSetValueEx(hkey,keystr,0,REG_DWORD,(LPBYTE)&ival,dwDataSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int SetRegLong(HKEY hkey,const char* keystr,long lval)
{
	int rc;
	DWORD dwDataSize = sizeof(lval);
	rc = RegSetValueEx(hkey,keystr,0,REG_DWORD,(LPBYTE)&lval,dwDataSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int EnumRegKey(HKEY hKey,int Index,char* sBuffer,int BufferSize)
{
	int rc;
	rc = RegEnumKey(hKey,(DWORD)Index,sBuffer,(DWORD)BufferSize);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int EnumRegValue(HKEY hKey,int Index,char* sBuffer,int BufferSize)
{
	int rc;
	rc = RegEnumValue(hKey,(DWORD)Index,sBuffer,(DWORD*)&BufferSize,NULL,NULL,NULL,NULL);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int DelRegKey(HKEY hkey,const char* keystr)
{
	int rc;
	rc = RegDeleteKey(hkey,keystr);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -----------------------------------------------------------------------------
int DelRegValue(HKEY hkey,const char* keystr)
{
	int rc;
	rc = RegDeleteValue(hkey,keystr);
	return( rc==ERROR_SUCCESS ? 0 : 1);
}

// -------------------  end WinPlotReg.CPP  ----------------------------
