// WinPlot3DZ.cpp : implementation of the WinPlot3DZ class.
// Concrete plotting class derived from Plot3DZ abstract class.
//

#include "stdafx.h"
#include "WinPlot3DZ.h"

// --------------------------------------------------------------
// The mathematical equation used to define the "color" of the surface.
long WinPlot3DZ::Color(double x,double y,double z)
{
	#define NCOLORS	6
	#define NSHADES	(NCOLORS*2)
	static long ColorValues[NCOLORS] = 
	{   //   R   G   B
		RGB(255,000,000),	// red
		RGB(255,128,000),	// orange
		RGB(200,200,000),	// yellow
		RGB(000,160,000),	// green
		RGB(000,000,200),	// blue
		RGB(128,000,128)	// violet
	};
	int iz;

	iz = abs((int)(2.*NSHADES*(z-m_zmin)/(m_zmax-m_zmin)));
	if ((iz & 1)==0) return( RGB(000,000,000) ); // black band between each color
	iz = iz % (NSHADES-1);
	return( ColorValues[iz] );
}

/*	<><><><><><><><><><><><><>  WinPlot3DZ.cpp  <><><><><><><><><><><><><><> */

