/* PhotoOrganizer 
 * Copyright (C) 1999-2000 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import java.awt.event.*;
import javax.swing.*;
import java.awt.BorderLayout;
import java.util.Enumeration;

import rogatkin.*;
import photoorganizer.*;

public class OptionsFrame extends JFrame implements ActionListener, Persistentable {
    public OptionsFrame(Controller controller) {
        super(Resources.TITLE_OPTIONS);
        this.controller = controller;
	setIconImage(controller.getMainIcon());
        JTabbedPane tabbedpane = new JTabbedPane(SwingConstants.TOP);
	// TODO: introduce new tabs
	// Directories
	// Workspace
	// Formats
	// Database
	// Web-publishing
	// TAB_MISCELLANEOUS
        tabbedpane.insertTab(Resources.TAB_RENAME, (Icon)null,
            new RenameOptionsTab(controller),
            Resources.TTIP_RULEFORRENAME,
            0);
        tabbedpane.insertTab(Resources.TAB_TRANSFORM, (Icon)null,
            new TransformOptionsTab(controller),
            Resources.TTIP_RULEFORTRANSFORM,
            1);
        tabbedpane.insertTab(Resources.TAB_THUMBNAILS, (Icon)null,
            new ThumbnailsOptionsTab(controller),
            Resources.TTIP_TUMBNAILSOPTION,
            2);
        tabbedpane.insertTab(Resources.TAB_MISCELLANEOUS, (Icon)null,
            new MiscellaneousOptionsTab(controller),
            Resources.TTIP_MISCELLANEOUS,
            3);
        tabbedpane.insertTab(Resources.TAB_ALBUM, (Icon)null,
            new AlbumOptionsTab(controller),
            Resources.TTIP_ALBUMOPTIONS,
            4);
        tabbedpane.insertTab(Resources.TAB_WEBPUBLISH, (Icon)null,
            new WebPublishOptionsTab(controller),
            Resources.TTIP_WEBPUBLISH,
            5);
        tabbedpane.insertTab(Resources.TAB_PLUGIN, (Icon)null,
            new PluginOptionsTab(controller),
            Resources.TTIP_PLUGINOPTIONS,
            6);
	// add tabs required by plug-ins
	Enumeration plugins = controller.names();
	int p = 7;
	while(plugins.hasMoreElements()) {
	    try {
		PhotoPlugin plugin = (PhotoPlugin)controller.component(plugins.nextElement());
		JPanel pp = plugin.getOptionsTab();
		if (pp != null)
		    tabbedpane.insertTab(plugin.getName(), (Icon)null,
		    pp, plugin.getName(), p++);
		
	    } catch(ClassCastException cce) {
	    }
	}
        /*tabbedpane.insertTab(Resources.TAB_COLLECTION, (Icon)null,
            new PhotoCollectionOptionsTab(controller),
            Resources.TTIP_TUMBNAILSOPTION,
            3);*/
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(tabbedpane, "Center");
        getContentPane().add(controller.createButtonPanel(this), "South");
        pack();
        setVisible(true);
        load();
    }

    public void actionPerformed(ActionEvent a) {
        String cmd = a.getActionCommand();
        if (cmd.equals(Resources.CMD_OK)) {
            save();
            setVisible(false);
        } else if (cmd.equals(Resources.CMD_APPLY)) {
            save();
        } else if (cmd.equals(Resources.CMD_CANCEL)) {
            setVisible(false);
        }
    }

    public void load() {
        JTabbedPane tabbedpane = (JTabbedPane)getContentPane().getComponent(0);
        for (int i=0; i<tabbedpane.getTabCount(); i++) {
            try {
                ((Persistentable)tabbedpane.getComponentAt(i)).load();
            } catch(ClassCastException e) {
            }
        }
    }
    
    public void save() {
        JTabbedPane tabbedpane = (JTabbedPane)getContentPane().getComponent(0);
        for (int i=0; i<tabbedpane.getTabCount(); i++) {
            try {
                ((Persistentable)tabbedpane.getComponentAt(i)).save();
            } catch(ClassCastException e) {
            }
        }
    }

    Controller controller;
}