/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.AppPreferenceInfo;
import palm.conduit.Card;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.DbGenInfo;
import palm.conduit.DbList;
import palm.conduit.FatalSyncException;
import palm.conduit.PositionInfo;
import palm.conduit.RawRecordInfo;
import palm.conduit.Record;
import palm.conduit.SyncDatabaseInfo;
import palm.conduit.SyncException;
import palm.conduit.SyncFindDbByNameParams;
import palm.conduit.SyncFindDbByTypeCreatorParams;
import palm.conduit.SyncProdCompInfo;
import palm.conduit.SyncProperties;
import palm.conduit.SyncReadOpenDbInfoParams;
import palm.conduit.SyncVersionException;
import palm.conduit.SystemInfo;
import palm.conduit.UserInfo;
import palm.conduit.dbCreateDB;

public class SyncManager {
    public static final int DB_RECORD = 0;
    public static final int DB_RESOURCE = 1;
    public static final int DB_READ_ONLY = 2;
    public static final int DB_INFO_DIRTY = 4;
    public static final int DB_BACKUP_DB = 8;
    public static final int DB_OK_TO_INSTALL_NEW = 16;
    public static final int DB_RESET_AFTER_INSTALL = 32;
    public static final int DB_OPEN_DB = 32768;
    public static final int OPEN_SECRET = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_WRITE = 64;
    public static final int OPEN_READ = 128;
    public static final byte DB_INFO_OPT_GET_ATTRIBUTES = -128;
    public static final byte DB_INFO_OPT_GET_SIZE = 64;
    public static final byte DB_INFO_OPT_GET_MAX_REC_SIZE = 32;
    public static final byte DB_SRCH_OPT_NEW_SEARCH = -128;
    public static final byte DB_SRCH_OPT_ONLY_LATEST = 64;
    public static final byte CLOSE_DB_OPT_UPDATE_BACKUP_DATE = -128;
    public static final byte CLOSE_DB_OPT_UPDATE_MOD_DATE = 64;
    private static final int READ_SIZE = 1024;
    private static final boolean haveCheckedVM = false;
    static int majorVersion;
    static int minorVersion;
    static /* synthetic */ Class class$palm$conduit$Log;

    private static void init() {
        Class clazz = class$palm$conduit$Log == null ? (class$palm$conduit$Log = SyncManager.class$("palm.conduit.Log")) : class$palm$conduit$Log;
        System.loadLibrary("jsync13");
        try {
            int[] nArray = SyncManager.getAPIVersion();
            majorVersion = nArray[0];
            minorVersion = nArray[1];
        }
        catch (SyncException syncException) {
            System.out.println("Uncaught exception: " + syncException.getMessage());
        }
    }

    private static void sync(SyncProperties syncProperties, String string) {
        SyncManager.init();
        try {
            Conduit conduit = (Conduit)Class.forName(string).newInstance();
            conduit.open(syncProperties);
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    private static int configure(ConfigureConduitInfo configureConduitInfo, String string) {
        int n = -1;
        SyncManager.init();
        try {
            Conduit conduit = (Conduit)Class.forName(string).newInstance();
            n = conduit.configure(configureConduitInfo);
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        return n;
    }

    public static void addLogEntry(String string) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncAddLogEntry(string), "Error Adding Log Entry");
    }

    public static UserInfo readUserID(int n) throws SyncException {
        UserInfo userInfo = new UserInfo(n);
        SyncManager.verifyResult(SyncManager.SyncReadUserID(userInfo), "Error Reading User");
        return userInfo;
    }

    public static int writeUserID(UserInfo userInfo) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncWriteUserID(userInfo), "Error Writing User Info");
        return userInfo.id;
    }

    public static void closeDB(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncCloseDB(n), "Error During Close of Database");
    }

    public static int createDB(int n, int n2, int n3, String string, int n4) throws SyncException {
        dbCreateDB dbCreateDB2 = new dbCreateDB(n, n2, n3, string, n4);
        SyncManager.verifyResult(SyncManager.SyncCreateDB(dbCreateDB2), "Error Creating Database");
        return dbCreateDB2.fileHandle;
    }

    public static void deleteDB(String string, int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncDeleteDB(string, n), "Error Deleting Database");
    }

    public static int openDB(String string, int n, int n2) throws SyncException {
        int[] nArray = new int[1];
        int n3 = SyncManager.SyncOpenDB(string, n, nArray, n2);
        SyncManager.verifyResult(n3, "Error Opening Database");
        return nArray[0];
    }

    public static byte[] readDBAppInfoBlock(int n, String string) throws SyncException {
        DbGenInfo dbGenInfo = new DbGenInfo(string, new byte[1024]);
        boolean bl = false;
        while (!bl) {
            SyncManager.verifyResult(SyncManager.SyncReadDBAppInfoBlock(n, dbGenInfo), "Error Reading AppInfoBlock");
            if (dbGenInfo.bytesRead <= dbGenInfo.totalBytes) {
                bl = true;
                continue;
            }
            dbGenInfo.setBytes(new byte[dbGenInfo.totalBytes * 2]);
        }
        return dbGenInfo.getBytes();
    }

    public static byte[] readDBSortInfoBlock(int n, String string) throws SyncException {
        DbGenInfo dbGenInfo = new DbGenInfo(string, new byte[1024]);
        boolean bl = false;
        while (!bl) {
            SyncManager.verifyResult(SyncManager.SyncReadDBSortInfoBlock(n, dbGenInfo), "Error Reading SortInfoBlock");
            if (dbGenInfo.bytesRead <= dbGenInfo.totalBytes) {
                bl = true;
                continue;
            }
            dbGenInfo.setBytes(new byte[dbGenInfo.totalBytes * 2]);
        }
        return dbGenInfo.getBytes();
    }

    public static void resetSyncFlags(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncResetSyncFlags(n), "Error Resetting Sync Flags");
    }

    public static void writeDBAppInfoBlock(int n, String string, byte[] byArray) throws SyncException {
        DbGenInfo dbGenInfo = new DbGenInfo(string, byArray);
        SyncManager.verifyResult(SyncManager.SyncWriteDBAppInfoBlock(n, dbGenInfo), "Error Writing Database App Info Block");
    }

    public static void writeDBSortInfoBlock(int n, String string, byte[] byArray) throws SyncException {
        DbGenInfo dbGenInfo = new DbGenInfo(string, byArray);
        SyncManager.verifyResult(SyncManager.SyncWriteDBSortInfoBlock(n, dbGenInfo), "Error Writing Database Sort Info Block");
    }

    public static void deleteAllResourceRec(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncDeleteAllResourceRec(n), "Error Deleting Resource Recs");
    }

    public static void deleteRecord(int n, Record record) throws SyncException {
        byte[] byArray = new byte[]{};
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, byArray);
        SyncManager.verifyResult(SyncManager.SyncDeleteRecord(rawRecordInfo), "Error Deleting Record");
    }

    public static void deleteResourceRec(int n, Record record) throws SyncException {
        byte[] byArray = new byte[]{};
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, byArray);
        SyncManager.verifyResult(SyncManager.SyncDeleteResourceRec(rawRecordInfo), "Error Deleting Resource Rec");
    }

    public static int getDBRecordCount(int n) throws SyncException {
        int[] nArray = new int[1];
        SyncManager.verifyResult(SyncManager.SyncGetDBRecordCount(n, nArray), "Error Getting Record Count");
        return nArray[0];
    }

    public static void purgeAllRecs(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeAllRecs(n), "Error Purging All Recs");
    }

    public static void purgeDeletedRecs(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeDeletedRecs(n), "Error Purging Deleted Recs");
    }

    public static void readNextModifiedRec(int n, Record record) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, byArray);
        SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRec(rawRecordInfo), "Error Reading Next Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordById(rawRecordInfo), "Error Reading Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
        record.setId(rawRecordInfo.recId);
    }

    public static void readRecordById(int n, Record record) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, byArray);
        SyncManager.verifyResult(SyncManager.SyncReadRecordById(rawRecordInfo), "Error Reading Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordById(rawRecordInfo), "Error Reading Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
    }

    public static void readRecordByIndex(int n, Record record) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, 0, record.getIndex(), byArray);
        SyncManager.verifyResult(SyncManager.SyncReadRecordByIndex(rawRecordInfo), "Error Reading Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordByIndex(rawRecordInfo), "Error Reading Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
        record.setId(rawRecordInfo.recId);
    }

    public static void readResRecordByIndex(int n, Record record, boolean bl) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, 0, record.getIndex(), byArray);
        SyncManager.verifyResult(SyncManager.SyncReadResRecordByIndex(rawRecordInfo, bl), "Error Reading Resource Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadResRecordByIndex(rawRecordInfo, bl), "Error Reading Resource Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
        record.setId(rawRecordInfo.recId);
    }

    public static void writeRec(int n, Record record) throws IOException {
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0);
        SyncManager.dataFromRec(rawRecordInfo, record);
        SyncManager.verifyResult(SyncManager.SyncWriteRec(rawRecordInfo), "Error Writing Record");
        record.setId(rawRecordInfo.recId);
    }

    public static void writeResourceRec(int n, Record record) throws IOException {
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), record.getIndex());
        SyncManager.dataFromRec(rawRecordInfo, record);
        SyncManager.verifyResult(SyncManager.SyncWriteResourceRec(rawRecordInfo), "Error Writing Resource Rec");
        record.setId(rawRecordInfo.recId);
    }

    public static DbList[] readDBList(int n, int n2, boolean bl) throws SyncException {
        int[] nArray = new int[1];
        Card card = new Card();
        card.cardNo = (byte)n;
        SyncManager.SyncReadSingleCardInfo(card);
        int n3 = (bl ? card.ramDbCount : card.romDbCount) - n2;
        DbList[] dbListArray = new DbList[n3];
        int n4 = 0;
        while (n4 < dbListArray.length) {
            dbListArray[n4] = new DbList();
            ++n4;
        }
        nArray[0] = n3;
        SyncManager.SyncReadDBList(n, n2, true, dbListArray, nArray);
        return dbListArray;
    }

    public static Card readSingleCardInfo(int n) throws SyncException {
        Card card = new Card();
        SyncManager.verifyResult(SyncManager.SyncReadSingleCardInfo(card), "Error Reading Card Information");
        return card;
    }

    public static SystemInfo readSystemInfo() throws SyncException {
        byte[] byArray = new byte[255];
        SystemInfo systemInfo = new SystemInfo(byArray);
        SyncManager.verifyResult(SyncManager.SyncReadSystemInfo(systemInfo), "Error Reading System Info");
        return systemInfo;
    }

    public static void rebootSystem() throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncRebootSystem(), "Error Rebooting System");
    }

    public static int readSysDateTime() throws SyncException {
        int[] nArray = new int[1];
        SyncManager.verifyResult(SyncManager.SyncReadSysDateTime(nArray), "Error Reading System Date/Time");
        return nArray[0];
    }

    public static void writeSysDateTime(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncWriteSysDateTime(n), "Error Writing System Date/Time");
    }

    public static void readNextRecInCategory(int n, Record record) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, (short)record.getCategoryIndex(), byArray);
        SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(rawRecordInfo), "Error Reading Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(rawRecordInfo), "Error Reading Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
    }

    public static void readNextModifiedRecInCategory(int n, Record record) throws IOException {
        byte[] byArray = new byte[1024];
        RawRecordInfo rawRecordInfo = new RawRecordInfo(n, record.getId(), 0, (short)record.getCategoryIndex(), byArray);
        SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRecInCategory(rawRecordInfo), "Error Reading Record");
        if (rawRecordInfo.recSize > rawRecordInfo.totalBytes) {
            rawRecordInfo.setBytes(new byte[rawRecordInfo.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRecInCategory(rawRecordInfo), "Error Reading Record");
        }
        SyncManager.dataToRec(record, rawRecordInfo);
    }

    public static AppPreferenceInfo readAppPreference(int n, short s, short s2, short s3, boolean bl, byte[] byArray) throws SyncException {
        AppPreferenceInfo appPreferenceInfo = new AppPreferenceInfo(n, s, s2, s3, bl, byArray);
        SyncManager.verifyResult(SyncManager.SyncReadAppPreference(appPreferenceInfo), "Error Reading Preference Info");
        return appPreferenceInfo;
    }

    public static AppPreferenceInfo writeAppPreference(short s, int n, short s2, boolean bl, byte[] byArray) throws SyncException {
        AppPreferenceInfo appPreferenceInfo = new AppPreferenceInfo(s, n, s2, bl, byArray);
        SyncManager.verifyResult(SyncManager.SyncWriteAppPreference(appPreferenceInfo), "Error Writing Preference Info");
        return appPreferenceInfo;
    }

    public static void resetRecordIndex(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncResetRecordIndex(n), "Error Resetting record Index");
    }

    public static void purgeAllRecsInCategory(int n, int n2) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeAllRecsInCategory(n, n2), "Error Purging All Records In Category");
    }

    public static int[] getAPIVersion() throws SyncException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[2];
        SyncManager.verifyResult(SyncManager.SyncGetAPIVersion(nArray, nArray2), "Error Getting API Version");
        nArray3[0] = nArray[0];
        nArray3[1] = nArray2[0];
        return nArray3;
    }

    public static void changeCategory(int n, int n2, int n3) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncChangeCategory(n, n2, n3), "Error Changing Category");
    }

    public static byte[] readPositionXMap(byte by, short s, short s2) throws SyncException {
        PositionInfo positionInfo = new PositionInfo(by, s, s2);
        byte[] byArray = new byte[1024];
        positionInfo.setBytes(byArray);
        boolean bl = false;
        while (!bl) {
            SyncManager.verifyResult(SyncManager.SyncReadPositionXMap(positionInfo), "Error Reading PositionXMap");
            if (positionInfo.numReadIn <= positionInfo.totalBytes) {
                bl = true;
                continue;
            }
            positionInfo.setBytes(new byte[positionInfo.totalBytes * 2]);
        }
        return positionInfo.getBytes();
    }

    public static void yieldCycles(int n) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncYieldCycles(n), "Error in YieldCycles");
    }

    public static int uint(short s) {
        return 0 | s & 0xFFFF;
    }

    public static int uint(byte by) {
        return 0 | by & 0xFF;
    }

    private static void dataToRec(Record record, RawRecordInfo rawRecordInfo) throws IOException {
        record.setId(rawRecordInfo.recId);
        record.setIndex(rawRecordInfo.recIndex);
        record.setCategoryIndex(rawRecordInfo.catId);
        record.setIsArchived((rawRecordInfo.attribs & 8) != 0);
        record.setIsPrivate((rawRecordInfo.attribs & 0x10) != 0);
        record.setIsDeleted((rawRecordInfo.attribs & 0x80) != 0);
        record.setIsModified((rawRecordInfo.attribs & 0x40) != 0);
        if (!record.isDeleted()) {
            byte[] byArray = rawRecordInfo.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, rawRecordInfo.recSize);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            record.readData(dataInputStream);
            dataInputStream.close();
        }
    }

    private static void verifyResult(int n, String string) throws SyncException {
        if ((n & 0x10000000) != 0) {
            throw new FatalSyncException(string, n);
        }
        if ((n & 0x4000) != 0) {
            throw new SyncException(string, n);
        }
    }

    private static void dataFromRec(RawRecordInfo rawRecordInfo, Record record) throws IOException {
        rawRecordInfo.recId = record.getId();
        rawRecordInfo.recIndex = (short)record.getIndex();
        rawRecordInfo.catId = (byte)record.getCategoryIndex();
        if (record.isArchived()) {
            rawRecordInfo.attribs = (byte)(rawRecordInfo.attribs | 8);
        }
        if (record.isPrivate()) {
            rawRecordInfo.attribs = (byte)(rawRecordInfo.attribs | 0x10);
        }
        if (record.isDeleted()) {
            rawRecordInfo.attribs = (byte)(rawRecordInfo.attribs | 0x80);
        }
        if (record.isModified() || record.isNew()) {
            rawRecordInfo.attribs = (byte)(rawRecordInfo.attribs | 0x40);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        record.writeData(dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        rawRecordInfo.setBytes(byteArrayOutputStream.toByteArray());
    }

    private static void verifyVersion(int n, int n2, String string) throws SyncVersionException {
        if (majorVersion < n || minorVersion < n2) {
            throw new SyncVersionException(string, n, n2);
        }
    }

    public static int readFeature(int n, short s) throws SyncException {
        int[] nArray = new int[1];
        SyncManager.verifyVersion(2, 1, "readFeature");
        SyncManager.verifyResult(SyncManager.SyncReadFeature(n, s, nArray), "Error readFeature");
        return nArray[0];
    }

    public static short[] getHHOSVersion() throws SyncException {
        short[] sArray = new short[2];
        SyncManager.verifyVersion(2, 1, "getHHOSVersion");
        short s = SyncManager.SyncGetHHOSVersion(sArray);
        sArray[1] = sArray[0];
        sArray[0] = s;
        return sArray;
    }

    public static SyncProdCompInfo readProdCompInfo() throws SyncException {
        throw new SyncException("readProdCompInfo deprecated", 16410);
    }

    public static int maxRemoteRecordSize() throws SyncException {
        int[] nArray = new int[1];
        SyncManager.verifyVersion(2, 2, "maxRemoteRecordSize");
        SyncManager.verifyResult(SyncManager.SyncMaxRemoteRecSize(nArray), "Error in maxRemoteRecordSize");
        return nArray[0];
    }

    public static SyncDatabaseInfo findDbByName(byte by, int n, String string) throws SyncException {
        SyncDatabaseInfo syncDatabaseInfo = new SyncDatabaseInfo();
        SyncFindDbByNameParams syncFindDbByNameParams = new SyncFindDbByNameParams();
        syncFindDbByNameParams.optFlags = by;
        syncFindDbByNameParams.cardNum = n;
        syncFindDbByNameParams.databaseName = string;
        SyncManager.verifyVersion(2, 2, "findDbByName");
        SyncManager.verifyResult(SyncManager.SyncFindDbByName(syncFindDbByNameParams, syncDatabaseInfo), "Error in findDbByName");
        return syncDatabaseInfo;
    }

    public static SyncDatabaseInfo findDbByTypeCreator(byte by, byte by2, int n, int n2) throws SyncException {
        SyncFindDbByTypeCreatorParams syncFindDbByTypeCreatorParams = new SyncFindDbByTypeCreatorParams();
        SyncDatabaseInfo syncDatabaseInfo = new SyncDatabaseInfo();
        syncFindDbByTypeCreatorParams.optFlags = by;
        syncFindDbByTypeCreatorParams.srchFlags = by2;
        syncFindDbByTypeCreatorParams.type = n;
        syncFindDbByTypeCreatorParams.creator = n2;
        SyncManager.verifyVersion(2, 2, "findDbByTypeCreator");
        SyncManager.verifyResult(SyncManager.SyncFindDbByTypeCreator(syncFindDbByTypeCreatorParams, syncDatabaseInfo), "Error findDbByTypeCreator");
        return syncDatabaseInfo;
    }

    public static SyncDatabaseInfo readOpenDbInfo(byte by, byte by2) throws SyncException {
        SyncReadOpenDbInfoParams syncReadOpenDbInfoParams = new SyncReadOpenDbInfoParams();
        syncReadOpenDbInfoParams.optFlags = by;
        syncReadOpenDbInfoParams.dbHandle = by2;
        SyncDatabaseInfo syncDatabaseInfo = new SyncDatabaseInfo();
        SyncManager.verifyVersion(2, 2, "readOpenDbInfo");
        SyncManager.verifyResult(SyncManager.SyncReadOpenDbInfo(syncReadOpenDbInfoParams, syncDatabaseInfo), "Error in readOpenDbInfo");
        return syncDatabaseInfo;
    }

    public static void closeDBEx(byte by, byte by2) throws SyncException {
        SyncManager.verifyVersion(2, 2, "closeDBEx");
        SyncManager.verifyResult(SyncManager.SyncCloseDBEx(by, by2), "Error in closeDBEx");
    }

    public static int swapBytes(int n) {
        return (0xFF000000 & n) >>> 24 | (0xFF0000 & n) >>> 8 | (0xFF00 & n) << 8 | (0xFF & n) << 24;
    }

    public static short swapBytes(short s) {
        return (short)(0xFFFF & ((0xFF & s) >>> 8 | (0xFF00 & s) << 8));
    }

    private static native int SyncAddLogEntry(String var0);

    private static native int SyncReadUserID(UserInfo var0);

    private static native int SyncWriteUserID(UserInfo var0);

    private static native int SyncCloseDB(int var0);

    private static native int SyncCreateDB(dbCreateDB var0);

    private static native int SyncDeleteDB(String var0, int var1);

    private static native int SyncOpenDB(String var0, int var1, int[] var2, int var3);

    private static native int SyncReadDBAppInfoBlock(int var0, DbGenInfo var1);

    private static native int SyncReadDBSortInfoBlock(int var0, DbGenInfo var1);

    private static native int SyncResetSyncFlags(int var0);

    private static native int SyncWriteDBAppInfoBlock(int var0, DbGenInfo var1);

    private static native int SyncWriteDBSortInfoBlock(int var0, DbGenInfo var1);

    private static native int SyncDeleteAllResourceRec(int var0);

    private static native int SyncDeleteRecord(RawRecordInfo var0);

    private static native int SyncDeleteResourceRec(RawRecordInfo var0);

    private static native int SyncGetDBRecordCount(int var0, int[] var1);

    private static native int SyncPurgeAllRecs(int var0);

    private static native int SyncPurgeDeletedRecs(int var0);

    private static native int SyncReadNextModifiedRec(RawRecordInfo var0);

    private static native int SyncReadRecordById(RawRecordInfo var0);

    private static native int SyncReadRecordByIndex(RawRecordInfo var0);

    private static native int SyncReadResRecordByIndex(RawRecordInfo var0, boolean var1);

    private static native int SyncWriteRec(RawRecordInfo var0);

    private static native int SyncWriteResourceRec(RawRecordInfo var0);

    private static native int SyncRebootSystem();

    private static native int SyncReadDBList(int var0, int var1, boolean var2, DbList[] var3, int[] var4);

    private static native int SyncReadDBList(int var0, int var1, boolean var2, int var3, int[] var4);

    private static native int SyncReadSingleCardInfo(Card var0);

    private static native int SyncReadSysDateTime(int[] var0);

    private static native int SyncWriteSysDateTime(int var0);

    private static native int SyncReadSystemInfo(SystemInfo var0);

    private static native int SyncChangeCategory(int var0, int var1, int var2);

    private static native int SyncReadPositionXMap(PositionInfo var0);

    private static native int SyncYieldCycles(int var0);

    private static native int SyncReadNextRecInCategory(RawRecordInfo var0);

    private static native int SyncReadNextModifiedRecInCategory(RawRecordInfo var0);

    private static native int SyncReadAppPreference(AppPreferenceInfo var0);

    private static native int SyncWriteAppPreference(AppPreferenceInfo var0);

    private static native int SyncResetRecordIndex(int var0);

    private static native int SyncPurgeAllRecsInCategory(int var0, int var1);

    private static native int SyncGetAPIVersion(int[] var0, int[] var1);

    private static native int SyncReadFeature(int var0, short var1, int[] var2);

    private static native short SyncGetHHOSVersion(short[] var0);

    private static native int SyncReadProdCompInfo(SyncProdCompInfo var0);

    private static native int SyncMaxRemoteRecSize(int[] var0);

    private static native int SyncFindDbByName(SyncFindDbByNameParams var0, SyncDatabaseInfo var1);

    private static native int SyncFindDbByTypeCreator(SyncFindDbByTypeCreatorParams var0, SyncDatabaseInfo var1);

    private static native int SyncReadOpenDbInfo(SyncReadOpenDbInfoParams var0, SyncDatabaseInfo var1);

    private static native int SyncCloseDBEx(byte var0, byte var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

