/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Hashtable;
import org.hsql.Trace;

class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int QUOTED_IDENTIFIER = 9;
    private static final int REMARK_LINE = 10;
    private static final int REMARK = 11;
    private String sCommand;
    private char[] cCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable();

    static {
        String[] stringArray = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "COUNT", "CASEWHEN", "DISTINCT", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "INTO", "IFNULL", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TRUE", "UNIQUE", "UNION", "VALUES", "WHERE", "CONVERT", "CAST", "CONCAT", "MINUS", "CALL"};
        int n = 0;
        while (n < stringArray.length) {
            hKeyword.put(stringArray[n], hKeyword);
            ++n;
        }
    }

    Tokenizer(String string) {
        this.sCommand = string;
        this.cCommand = string.toCharArray();
        this.iLength = this.cCommand.length;
        this.iIndex = 0;
    }

    void back() throws SQLException {
        Trace.assert(!this.bWait, "back");
        this.bWait = true;
    }

    Object getAsValue() throws SQLException {
        if (!this.wasValue()) {
            throw Trace.error(10, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken.substring(1);
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            if (this.sToken.length() > 9) {
                this.iType = 7;
                return new Long(this.sToken);
            }
            return new Integer(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        return this.sToken;
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getLongNameLast() {
        return this.sLongNameLast;
    }

    String getName() throws SQLException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(10, this.sToken);
        }
        return this.sToken;
    }

    String getPart(int n, int n2) {
        return this.sCommand.substring(n, n2);
    }

    int getPosition() {
        return this.iIndex;
    }

    String getString() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    String getStringToken() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.substring(1).toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 9) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(10, this.sToken);
    }

    void getThis(String string) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(string)) {
            throw Trace.error(10, this.sToken);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws SQLException {
        if (!this.bWait) ** GOTO lbl5
        this.bWait = false;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl5:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.cCommand[this.iIndex]))
        }
lbl6:
        // 1 sources

        this.sToken = "";
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        var1_1 = false;
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        var5_5 = false;
        var6_6 = this.cCommand[this.iIndex];
        var7_7 = '\u0000';
        var8_8 = new StringBuffer();
        if (Character.isJavaIdentifierStart(var6_6)) {
            this.iType = 1;
        } else {
            if ("(),*=;+%".indexOf(var6_6) >= 0) {
                this.iType = 3;
                ++this.iIndex;
                this.sToken = "" + var6_6;
                return;
            }
            if (Character.isDigit(var6_6)) {
                this.iType = 4;
                var2_2 = true;
            } else if ("!<>|/-".indexOf(var6_6) >= 0) {
                var7_7 = var6_6;
                this.iType = 3;
            } else if (var6_6 == '\"') {
                this.iType = 9;
            } else if (var6_6 == '\'') {
                this.iType = 6;
                var8_8.append('\'');
            } else if (var6_6 == '.') {
                this.iType = 5;
                var1_1 = true;
            } else {
                throw Trace.error(10, "" + var6_6);
            }
        }
        var9_9 = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                var6_6 = ' ';
                var5_5 = true;
                Trace.check(this.iType != 6 && this.iType != 9, 11);
            } else {
                var6_6 = this.cCommand[this.iIndex];
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(var6_6)) break;
                    this.sToken = this.sCommand.substring(var9_9, this.iIndex).toUpperCase();
                    if (var6_6 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = String.valueOf(this.sLongNameFirst) + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 9: {
                    if (var6_6 == '\"') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength) {
                            this.sToken = var8_8.toString();
                            return;
                        }
                        var6_6 = this.cCommand[this.iIndex];
                        if (var6_6 == '.') {
                            this.sLongNameFirst = var8_8.toString();
                            ++this.iIndex;
                            this.getToken();
                            this.sLongNameLast = this.sToken;
                            this.iType = 2;
                            this.sToken = String.valueOf(this.sLongNameFirst) + "." + this.sLongNameLast;
                            return;
                        }
                        if (var6_6 != '\"') {
                            this.sToken = var8_8.toString();
                            return;
                        }
                    }
                    var8_8.append(var6_6);
                    break;
                }
                case 6: {
                    if (var6_6 == '\'') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength || this.cCommand[this.iIndex] != '\'') {
                            this.sToken = var8_8.toString();
                            return;
                        }
                    }
                    var8_8.append(var6_6);
                    break;
                }
                case 11: {
                    if (var5_5) {
                        this.iType = 0;
                        return;
                    }
                    if (var6_6 != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.cCommand[this.iIndex] != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 10: {
                    if (var5_5) {
                        this.iType = 0;
                        return;
                    }
                    if (var6_6 != '\r' && var6_6 != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (var6_6 == '/' && var7_7 == '/') {
                        this.iType = 10;
                        break;
                    }
                    if (var6_6 == '-' && var7_7 == '-') {
                        this.iType = 10;
                        break;
                    }
                    if (var6_6 == '*' && var7_7 == '/') {
                        this.iType = 11;
                        break;
                    }
                    if (">=|".indexOf(var6_6) >= 0) break;
                    this.sToken = this.sCommand.substring(var9_9, this.iIndex);
                    return;
                }
                case 4: 
                case 5: {
                    if (Character.isDigit(var6_6)) {
                        var2_2 = true;
                        break;
                    }
                    if (var6_6 == '.') {
                        this.iType = 5;
                        if (var1_1) {
                            throw Trace.error(10, ".");
                        }
                        var1_1 = true;
                        break;
                    }
                    if (var6_6 == 'E' || var6_6 == 'e') {
                        if (var3_3) {
                            throw Trace.error(10, "E");
                        }
                        var4_4 = true;
                        var1_1 = true;
                        var3_3 = true;
                        break;
                    }
                    if (var6_6 == '-' && var4_4) {
                        var4_4 = false;
                        break;
                    }
                    if (var6_6 == '+' && var4_4) {
                        var4_4 = false;
                        break;
                    }
                    var4_4 = false;
                    if (!var2_2) {
                        if (var1_1 && var9_9 == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(10, "" + var6_6);
                    }
                    this.sToken = this.sCommand.substring(var9_9, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 7: {
                return -5;
            }
        }
        return 0;
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 9) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    boolean wasValue() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5) {
            return true;
        }
        if (this.sToken.equals("NULL")) {
            return true;
        }
        return this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }
}

