/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import com.l2fprod.contrib.freehep.PanelArtistUtilities;
import com.l2fprod.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class ImageUtils
implements SwingConstants {
    public static final Component producer = new 1();
    public static final int PAINT_NORMAL = 0;
    public static final int PAINT_STRETCH = 1;
    public static final int PAINT_TILE = 2;
    public static final int PAINT_CENTERED = 3;
    public static final int PAINT_NONE = 5;
    public static final int TRANSPARENT_RED = 255;
    public static final int TRANSPARENT_GREEN = 0;
    public static final int TRANSPARENT_BLUE = 255;
    public static final int TRANSPARENT_TO_REMOVE = new Color(255, 0, 255).getRGB();
    public static final int TRANSPARENT_PIXEL = new Color(255, 0, 0, 0).getRGB();

    private final Color decodeColor(String s) {
        int val = 0;
        try {
            val = s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : (s.startsWith("#") ? Integer.parseInt(s.substring(1), 16) : (s.startsWith("0") && s.length() > 1 ? Integer.parseInt(s.substring(1), 8) : Integer.parseInt(s, 10)));
            return new Color(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static ImageIcon getDisabledIcon(ImageIcon anIcon) {
        return ImageUtils.getDisabledIcon(anIcon.getImage());
    }

    public static ImageIcon getDisabledIcon(Image anImage) {
        return new ImageIcon(ImageUtils.getDisabledImage(anImage));
    }

    public static Image getDisabledImage(Image anImage) {
        if (anImage == null) {
            return null;
        }
        return ImageUtils.filterImage(new GrayFilter(true, 75), anImage);
    }

    public static Image filterImage(RGBImageFilter filter, Image image) {
        return producer.createImage(new FilteredImageSource(image.getSource(), filter));
    }

    public static Image rotateImage(Image anImage) {
        int w = anImage.getWidth(null);
        int h = anImage.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pixel = new PixelGrabber(anImage, 0, 0, w, h, pixels, 0, w);
        try {
            pixel.grabPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        int[] rot = new int[h * w];
        int pos = 0;
        int i = w;
        while (i > 0) {
            int j = 0;
            while (j < h) {
                rot[pos] = pixels[i + w * j - 1];
                ++pos;
                ++j;
            }
            --i;
        }
        return ImageUtils.convertBytesToImage(producer, rot, h, w);
    }

    public static Image rotateImage(Image anImage, double angle) {
        int width = anImage.getWidth(null);
        int height = anImage.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pixel = new PixelGrabber(anImage, 0, 0, width, height, pixels, 0, width);
        try {
            pixel.grabPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        int[] pixels2 = new int[width * height];
        int i = 0;
        double radians = -angle / 57.29577951308232;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int centerX = width >> 1;
        int centerY = height >> 1;
        int oldY = -centerY;
        while (oldY < centerY) {
            int oldX = -centerX;
            while (oldX < centerX) {
                int newX = centerX + (int)((double)oldX * cos - (double)oldY * sin);
                int newY = centerY + (int)((double)oldX * sin + (double)oldY * cos);
                pixels2[i++] = newX > 0 && newX < width && newY > 0 && newY < height ? pixels[width * newY + newX] : pixels[0];
                ++oldX;
            }
            ++oldY;
        }
        return producer.createImage(new MemoryImageSource(width, height, pixels2, 0, width));
    }

    public static Image convertBytesToImage(Component c, int[] pixels, int w, int h) {
        return c.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    public static void paint(Component c, Graphics g, Image image) {
        ImageUtils.paint(c, g, image, true);
    }

    public static void paint(Component c, Graphics g, Image image, int paintType) {
        ImageUtils.paint(c, g, image, true, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, boolean alignWithParent) {
        ImageUtils.paint(c, g, image, alignWithParent, 1);
    }

    public static void paint(Component c, Graphics g, Image image, boolean alignWithParent, int paintType) {
        ImageUtils.paint(c, g, image, 0, 0, ((JComponent)c).getWidth(), ((JComponent)c).getHeight(), alignWithParent, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height) {
        ImageUtils.paint(c, g, image, x, y, width, height, true, 1);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height, int paintType) {
        ImageUtils.paint(c, g, image, x, y, width, height, true, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height, boolean alignWithParent, int paintType) {
        if (image == null) {
            return;
        }
        switch (paintType) {
            case 0: {
                g.drawImage(image, x, y, c);
                break;
            }
            case 1: {
                g.drawImage(image, x, y, width, height, c);
                break;
            }
            case 2: {
                ImageUtils.paintTile(c, g, image, x, y, width, height, alignWithParent);
                break;
            }
            case 3: {
                g.drawImage(image, (width - image.getWidth(c)) / 2, (height - image.getHeight(c)) / 2, c);
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public static void paintTile(Component component, Graphics g, Image image, int x, int y, int width, int height) {
        ImageUtils.paintTile(component, g, image, x, y, width, height, true);
    }

    public static Image transparent(Image image) {
        return ImageUtils.toBufferedImage(image);
    }

    public static Image grab(Image image, int x, int y, int width, int height) {
        if (width * height <= 0) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getSubimage(x, y, width, height);
        }
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, x, y, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int pixel = pixels[j * width + i];
                int alpha = pixel >> 24 & 0xFF;
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if (red == 255 && green == 0 && blue == 255) {
                    pixels[j * width + i] = TRANSPARENT_PIXEL;
                }
                ++i;
            }
            ++j;
        }
        Image newImage = producer.createImage(new MemoryImageSource(width, height, pixels, 0, width));
        return ImageUtils.toBufferedImage(newImage);
    }

    public static Image buildTile(Image image, int factor) {
        int width = image.getWidth(producer);
        int height = image.getHeight(producer);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] zoomed = new int[pixels.length * factor];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < factor) {
                System.arraycopy(pixels, width * i, zoomed, width * factor * i + width * j, width);
                ++j;
            }
            ++i;
        }
        pixels = zoomed;
        int[] zoomed2 = new int[pixels.length * factor];
        int i2 = 0;
        while (i2 < factor) {
            System.arraycopy(pixels, 0, zoomed2, i2 * pixels.length, pixels.length);
            ++i2;
        }
        return producer.createImage(new MemoryImageSource(width * factor, height * factor, zoomed2, 0, width * factor));
    }

    public static BufferedImage toBufferedImage(Image image) {
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        DataBuffer db = bufferedImage.getRaster().getDataBuffer();
        int i = 0;
        int c = db.getSize();
        while (i < c) {
            if (db.getElem(i) == TRANSPARENT_TO_REMOVE) {
                db.setElem(i, TRANSPARENT_PIXEL);
            }
            ++i;
        }
        return bufferedImage;
    }

    public static Image flipHorizontally(Image image) {
        if (image == null) {
            return null;
        }
        AffineTransform transform = PanelArtistUtilities.getYFlipTransform(image.getHeight(producer));
        AffineTransformOp operation = new AffineTransformOp(transform, 2);
        return operation.filter((BufferedImage)image, null);
    }

    public static Image rotateLeft(Image anImage) {
        if (anImage == null) {
            return null;
        }
        AffineTransform transform = PanelArtistUtilities.getCCWRotateTransform(anImage.getWidth(producer), anImage.getHeight(producer));
        AffineTransformOp operation = new AffineTransformOp(transform, 2);
        return operation.filter((BufferedImage)anImage, null);
    }

    private static final void paintTile(Component component, Graphics g, Image image) {
        ImageUtils.paintTile(component, g, image, 0, 0, ((JComponent)component).getWidth(), ((JComponent)component).getHeight(), true);
    }

    private static final void paintTile(Component component, Graphics g, Image image, boolean alignWithParent) {
        ImageUtils.paintTile(component, g, image, 0, 0, ((JComponent)component).getWidth(), ((JComponent)component).getHeight(), alignWithParent);
    }

    private static final void paintTile(Component component, Graphics g, Image image, int x, int y, int width, int height, boolean alignWithParent) {
        if (image == null) {
            return;
        }
        int dx = image.getWidth(null);
        int dy = image.getHeight(null);
        if (dx <= 0 || dy <= 0) {
            return;
        }
        int xoff = 0;
        int yoff = 0;
        Shape oldClip = g.getClip();
        if (oldClip.contains(x, y, width, height) || width <= 0 || height <= 0) {
            g.setClip(x, y, width, height);
        } else if (oldClip.intersects(x, y, width, height)) {
            Rectangle currentRect = oldClip.getBounds();
            g.setClip(SwingUtilities.computeIntersection(x, y, width, height, (Rectangle)currentRect.clone()));
        }
        if (alignWithParent) {
            Container parent = component.getParent();
            xoff = component.getLocation().x;
            yoff = component.getLocation().y;
            while (parent != null && !(parent instanceof JInternalFrame)) {
                if (parent.getParent() != null) {
                    xoff += parent.getLocation().x;
                    yoff += parent.getLocation().y;
                }
                parent = parent.getParent();
            }
            x -= xoff % dx;
            y -= yoff % dy;
        }
        int maxX = x + width + dx;
        int maxY = y + height + dy;
        while (x <= maxX) {
            int j = y;
            while (j <= maxY) {
                g.drawImage(image, x, j, component);
                j += dy;
            }
            x += dx;
        }
        g.setClip(oldClip);
    }
}

