#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
#QWN
# index.cgi - portal page

use qwnui;
use session;
use config;
use encode;
use checksess;
use htmlgen;


require 'cgi-lib1.pl';
&ReadParse(*input);


&checksess::validsess;

print "Content-Type: text/html\n\n";

print <<HEADEND;
<html>
<head>
<title>QWN Portal</title>
<link href="style.css" typ=text/css rel=stylesheet>
</head>
<body>
HEADEND

qwnui::qwnheader;


$in=$input;

# print "\$in string: $in<br>";

# &config::loadconf("testproj");
# &config::savesession;

# print "<h1>Quick Website news</h1>";

# do actions from last time
if ($in eq "action=save"){
        &config::saveconf();
        print "<p class=info>Project successfully saved and closed.</p>";
}elsif($in =~ s/^action=load&//){
        @detail = split (/&/, $in);
        foreach $detail(@detail){
                %details=split(/=/,$detail);
                while (($name,$value)=each %details){
                        if ($name eq "filename"){$fname=$value;}
                        if ($name eq "password"){$passwd=$value;}
                }
        }
        $fname=&encode::unencode($fname);
        print "<p class=info>Loading project $fname... ";
        $l=&config::loadconf($fname,$passwd);
        if ($l==0){    print "Successful</p>";
        }elsif($l==1) {
                print "Failed - The password entered is incorrect.</p>";
        }elsif($l==2) { print "Failed - The project settings can't be found (filename config/$fname).</p>";
        }elsif($l==3) { print "Failed - The project settings are set up to not allow your host access to them.</p>";
        }elsif($l==4) { print "Failed - The project settings are set up to deny your host access to them.</p>";
        }else{
                print "Failed - Unknown reason.";
        }
}elsif($in =~ s/^action=deleteproject&password=//){
        if ($in eq $session::password){
                # need to do some more checks here.
               # "config/$session::filename", 0;
                # "config/$session::newsdb", 0;
                print "<p class=info>Project Deletion not yet implemented.</p>";
                &config::clearsess;
        }else{
                print "<p class=info>Unable to delete project -invalid password.<br>Project File Saved and Closed for Security.";
                &config::saveconf();
        }
}elsif($in =~ s/^action=new&projname=//){
        #Check for duplicate projects.
        $pn=$in;
        $pn =~ s/ /_/g;
        $pn .= ".qwn";
        if  (-e "config/$pn"){
                print "<p class=info>Unable to create new project: The name you have chosen has been taken by another project. Choose another name and try again.</p>"
        }else{
                &config::newsess($in);
                print "<p class=info>Successfully created a new project.<br>You should now edit the <a href=\"conf.cgi\">project settings</a>, especially the security settings including a security password (currently left blank).</p>";
        }

}elsif($in =~ s/^action=error&string=//){
        #Show an error message from some other page.
        $in=&encode::unencode($in);
        print "<p class=info>ERROR: $in</p>";

}elsif($in =~ s/^action=saveconf//){
# Save configuration settings
        @detail = split (/&/, $in);
        foreach $detail(@detail){
                %details=split(/=/,$detail);
                while (($name,$value)=each %details){
                        # print "<br>$name,&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   $value.";
                        if ($name eq "projname"){   $session::projname=$value;    }
                        elsif ($name eq "filename"){   $session::filename=$value;    }
                        elsif ($name eq "htmldir"){   $session::htmldir=$value;    }
                        elsif ($name eq "defauthor"){   $session::defauthor=$value;    }
                        elsif ($name eq "newsdb"){   $session::newsdb=$value;    }
                        elsif ($name eq "firstfile"){   $session::firstfile=$value;    }
                        elsif ($name eq "otherfiles"){   $session::otherfiles=$value;    }
                        elsif ($name eq "firstpagecount"){   $session::firstpagecount=$value;    }
                        elsif ($name eq "otherpagecount"){   $session::otherpagecount=$value;    }
                        elsif ($name eq "firsthtmlstart"){   $session::firsthtmlstart=$value;    }
                        elsif ($name eq "firsthtmlend"){   $session::firsthtmlend=$value;    }
                        elsif ($name eq "htmlstart"){   $session::htmlstart=$value;    }
                        elsif ($name eq "htmlend"){   $session::htmlend=$value;    }
                        elsif ($name eq "firstitemtemplate"){   $session::firstitemtemplate=$value;    }
                        elsif ($name eq "otheritemtemplate"){   $session::otheritemtemplate=$value;    }
                        elsif ($name eq "dateformat"){   $session::dateformat=$value;    }
                        elsif ($name eq "backupfrequency"){   $session::backupfrequency=$value;    }
                        elsif ($name eq "hostsallow"){   $session::hostsallow=$value;    }
                        elsif ($name eq "hostsdeny"){   $session::hostsdeny=$value;    }
                        elsif ($name eq "password"){   $session::password=$value;    }
                }
        }
        &config::savesession;
        print "<p class=info>Updated project settings.</p>";
        print "Regenerating Static HTML Pages:";
        &htmlgen::makehtml;
}else{
        print "<p>Welcome to the QWN interface.";
        print "<p>This is where you can add news items to your databases; alter configuration settings such as the look of your output HTML news files; regenerate html files; and create new news projects. For more information, please visit the online help.";
        print "<p>This is version 0.8. It is the first public release and so may contain bugs. I am particularly eager to recieve comments from all qwn users. Reporting bugs, sending suggestions, links to sites which use qwn, telling me to stop wasting my time - all comments will be much appreciated by email to mh at tildemh dot com (But please don't send spam).";
        print "<p>If anyone would like to help me develop QWN, please feel free to modify the source code and send changes to me. Also, if anyone wants to write some help documentation, this would also be much appreciated. You would of course be fully credited in all the documentation.";
}

print "<br><br><br><table width=100%><tr><td width=20%>&nbsp;<td width=30%>";
if ($session::projloaded &&$session::projloaded ne false ){
        $p=&encode::unencode($session::projname);
        print "<h2>Current Project:&nbsp;$p</h2>";

        print <<END;
        <ul>
        <li><a href="add.cgi">Add News Items</a>
        <li><a href="view.cgi">View / Edit News Items</a>
        <li><a href="conf.cgi">Edit Project Settings</a>
        <li><form action="index.cgi" method=post>
                <input type=hidden name="action" value="save">
                <input type=submit value="Save and close Project">
                </form>
        <li><a href="delete.cgi">Delete Project</a>
        </ul>
END

}else {         print "<h2>Projects</h2><p>No Project is Currently Loaded.";

        opendir CONFDIR, "config";
        rewinddir CONFDIR;
        @dir = readdir CONFDIR;
        closedir CONFDIR;
        print "<form action=\"index.cgi\" method=post><input type=hidden name=\"action\" value=\"load\">Load Existing Project: <br><select name=filename>";
        $projcount=0;
        foreach $file (@dir){
                if (index($file,".qwn")>=0){
                     #   print "\n<p>$file";
                        # Extract project name and use that instead?
                        $projname=&encode::unencode(&config::getprojname(&encode::unencode($file)));
                        print "\n<option value=$file label=\"$projname\">$projname";
                        $projcount++;
                }
        }
        if ($projcount==0){print "No Projects Available to Load";}
        print "</select><br>Password: <input type=password name=password><br><input type=submit value=\"Load\"></form>";

        print <<END;
        <hr><p>New Project:<br>
        <form name=newproj action="index.cgi" method=post>
        <input type=hidden name="action" value="new">
        Project Name:<input type=text name=projname value="New Project">
        <input type=submit value="Create">
        </form>
       
END
}

print "<td valign=top><h2>User Details</h2><p>Address: $ENV{REMOTE_ADDR}<br>";
print "Host Name: $ENV{REMOTE_HOST}<br>";
print "User Agent: $ENV{HTTP_USER_AGENT}";
print "</table>";


print "</body></html>";