/*
 * Decompiled with CFR 0.152.
 */
package hsplitter.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class Logger {
    int logFilterLevel = 2;
    public static final int LOGLEVEL_NONE = 0;
    public static final int LOGLEVEL_FAIL = 1;
    public static final int LOGLEVEL_ERR = 2;
    public static final int LOGLEVEL_WARN = 3;
    public static final int LOGLEVEL_INFO = 4;
    public static final int LOGLEVEL_VERBOSE = 5;
    private String[] msgHead = new String[]{"FATAL: ", "FAIL:  ", "ERR:   ", "WARN:  ", "INFO:  ", "VERBO: "};
    private File logFile = null;
    private PrintStream printStream = null;
    private FileOutputStream fos = null;
    private static Logger lgr;
    private boolean opened = false;
    private boolean dualStreamEnabled = true;
    private DateFormat df = DateFormat.getDateTimeInstance(2, 2);
    private static String sep;

    private Logger() {
    }

    public static Logger getLogger(File logFileNew, boolean adualStream) {
        if (logFileNew == null) {
            return lgr;
        }
        lgr = new Logger(logFileNew, adualStream);
        return lgr;
    }

    private Logger(File logFile, boolean dualStream) {
        this.logFile = logFile;
        this.dualStreamEnabled = dualStream;
    }

    public void open() {
        if (this.logFile != null) {
            try {
                if (this.logFile.exists()) {
                    this.logFile.delete();
                }
            }
            catch (Exception ee) {
                System.out.println("WARN: Cannot delete previous logger file = ".concat(String.valueOf(String.valueOf(this.logFile.getAbsolutePath()))));
            }
            try {
                this.fos = new FileOutputStream(this.logFile);
                this.printStream = new PrintStream(this.fos);
            }
            catch (Exception ee) {
                System.out.println("ERR: Logger failed to open for = ".concat(String.valueOf(String.valueOf(this.logFile.getAbsolutePath()))));
                System.err.println("ERR: Logger failed to open for = ".concat(String.valueOf(String.valueOf(this.logFile.getAbsolutePath()))));
                this.opened = false;
                try {
                    if (this.printStream != null) {
                        this.printStream.close();
                    }
                    if (this.fos != null) {
                        this.fos.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("INFO: Logger opened = ".concat(String.valueOf(String.valueOf(this.logFile.getAbsolutePath()))));
            if (this.dualStreamEnabled) {
                System.out.println("INFO: Logger opened = System.out");
            }
        } else {
            System.out.println("INFO: Logger opened = System.out");
        }
        this.opened = true;
    }

    public void close() {
        try {
            if (this.printStream != null) {
                this.printStream.close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.opened = false;
    }

    public int getLogLevel() {
        return this.logFilterLevel;
    }

    public void setLogLevel(int level) {
        this.logFilterLevel = level;
    }

    private static String makeMsgPrintable(String msg) {
        if (msg.equals("")) {
            return msg;
        }
        String retmsg = "";
        int prevpos = 0;
        int pos = msg.indexOf("\n");
        if (pos < 0) {
            return msg;
        }
        while (pos >= 0) {
            retmsg = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(retmsg))).append(msg.substring(prevpos, pos)).append(sep)));
            prevpos = pos + 1;
            pos = msg.indexOf("\n", prevpos);
        }
        retmsg = String.valueOf(String.valueOf(retmsg)).concat(String.valueOf(String.valueOf(msg.substring(prevpos))));
        return retmsg;
    }

    public void log(int logLevel, boolean timeStamp, String msg) {
        if (logLevel > this.logFilterLevel) {
            return;
        }
        if (!this.opened) {
            return;
        }
        String theTime = "";
        if (timeStamp) {
            theTime = String.valueOf(String.valueOf(this.df.format(new Date()))).concat("; ");
        }
        String msgToPrint = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.msgHead[logLevel]))).append(theTime).append(Logger.makeMsgPrintable(msg))));
        if (this.logFile == null) {
            System.out.println(msgToPrint);
        } else {
            if (this.dualStreamEnabled) {
                System.out.println(msgToPrint);
            }
            if (this.printStream != null) {
                this.printStream.print(String.valueOf(String.valueOf(msgToPrint)).concat(String.valueOf(String.valueOf(sep))));
            }
        }
    }

    public void logUrgent(String msg) {
        this.log(0, true, msg);
    }

    public void logFail(String msg) {
        this.log(1, true, msg);
    }

    public void logErr(String msg) {
        this.log(2, false, msg);
    }

    public void logWarn(String msg) {
        this.log(3, false, msg);
    }

    public void logInfo(String msg) {
        this.log(4, false, msg);
    }

    public void logTime(String msg) {
        this.log(4, true, msg);
    }

    public void logASpaceLine() {
        if (this.printStream != null) {
            this.printStream.print(sep);
        }
    }

    public static void main(String[] args) {
        Logger logger1 = new Logger();
    }

    static {
        LOGLEVEL_NONE = 0;
        LOGLEVEL_FAIL = 1;
        LOGLEVEL_ERR = 2;
        LOGLEVEL_WARN = 3;
        LOGLEVEL_INFO = 4;
        LOGLEVEL_VERBOSE = 5;
        lgr = null;
        sep = System.getProperty("line.separator");
    }
}

