/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import jms.graphics.Border;

public class BorderedPanel
extends Panel
implements Border {
    public static final int TITLE_SPACE = 5;
    private String title;
    private Font font;

    public BorderedPanel(String title) {
        this.title = title;
        this.font = new Font("Arial", 0, 12);
        this.setBackground(Color.lightGray);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        this.paintBorder(this, g, 0, 0, d.width - 1, d.height - 1);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.setFont(this.font);
        Dimension d = c.getSize();
        FontMetrics fm = this.getFontMetrics(this.font);
        int size_width = d.width;
        int size_height = d.height;
        int y_offset = (int)((double)fm.getHeight() / 2.0);
        int y_text = y_offset + (int)((double)fm.getAscent() / 2.0);
        int x_text = (int)((double)size_width * 0.1);
        int text_width = fm.stringWidth(this.title);
        g.setColor(Color.gray);
        g.drawLine(0, y_offset, 0, size_height - 1);
        g.drawLine(0, y_offset, size_width - 1, y_offset);
        g.drawLine(2, size_height - 2, size_width - 2, size_height - 2);
        g.drawLine(size_width - 2, size_height - 2, size_width - 2, y_offset + 3);
        g.setColor(Color.white);
        g.drawLine(1, y_offset + 1, 1, size_height - 1);
        g.drawLine(1, y_offset + 1, size_width - 1, y_offset + 1);
        g.drawLine(2, size_height - 1, size_width - 1, size_height - 1);
        g.drawLine(size_width - 1, size_height - 1, size_width - 1, y_offset + 3);
        if (this.title != null) {
            g.setColor(Color.white);
            g.setColor(c.getBackground());
            g.fillRect(5, 0, text_width + 5, fm.getHeight() + 2);
            g.setColor(Color.black);
            g.drawString(this.title, 10, fm.getAscent());
        }
    }

    public Insets getBorderInsets(Component c) {
        FontMetrics fm = this.getFontMetrics(this.font);
        Insets insets = new Insets(fm.getHeight() + 5, 5, 5, 5);
        return insets;
    }

    public final Insets getInsets() {
        return this.getBorderInsets(this);
    }

    public Rectangle getBounds() {
        Insets insets = this.getBorderInsets(this);
        Rectangle r = new Rectangle(insets.left, insets.top, insets.right, insets.bottom);
        return r;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

