/*
 * Decompiled with CFR 0.152.
 */
package komponens.tabpanel;

import freejava.FreeJava;
import freejava.Mindenes;
import freejava.Nyelv;
import futtatas.JavaThread;
import futtatas.JavaThreadPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import komponens.FelpattanoMenu;
import komponens.tabpanel.FreeJavaKimenet;

public class KimenetTabbedPane
extends JTabbedPane
implements ActionListener,
ChangeListener {
    FreeJava freeJava;
    JPopupMenu pMenu;
    JMenuItem miBezar = new JMenuItem();
    JMenuItem miTorles = new JMenuItem();
    JMenuItem miBezarOsszes = new JMenuItem();
    boolean plusz = false;

    public KimenetTabbedPane(FreeJava freeJava) {
        this.freeJava = freeJava;
        this.enableEvents(17L);
        this.setTabPlacement(3);
        this.setMinimumSize(new Dimension(0, 0));
        this.addChangeListener(this);
        this.miBezar.addActionListener(this);
        this.miTorles.addActionListener(this);
        this.miBezarOsszes.addActionListener(this);
        this.nyelvReset();
    }

    public void nyelvReset() {
        this.miBezar.setText(Nyelv.get("OutputsTabbedPane.Close"));
        this.miTorles.setText(Nyelv.get("OutputsTabbedPane.Clear"));
        this.miBezarOsszes.setText(Nyelv.get("OutputsTabbedPane.CloseAll"));
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof FreeJavaKimenet)) continue;
            ((FreeJavaKimenet)((Object)this.getComponentAt(i))).nyelvReset();
        }
        this.stateChanged(new ChangeEvent(new Object()));
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 500) {
            if (mouseEvent.getModifiers() == 16) {
                if (this.getTabCount() == 0 && mouseEvent.getX() < 5 && mouseEvent.getY() < 5) {
                    this.plusz = !this.plusz;
                    this.repaint();
                }
            } else if (mouseEvent.getModifiers() == 4 && this.getComponentCount() > 0) {
                this.createPopupMenu();
                this.pMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            this.freeJava.setKimenetPozicio();
        }
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getTabCount() == 0) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(new Color(200, 200, 255));
            graphics.fillRect(0, 0, 4, 4);
            if (this.plusz) {
                Font font = new Font(this.getFont().getName(), 1, 46);
                graphics.setFont(font);
                String string = "Belovai Tibor program";
                int n = ((Component)this).getFontMetrics(font).stringWidth(string);
                graphics.drawString(string, this.getWidth() / 2 - n / 2, this.getHeight() - ((Component)this).getFontMetrics(font).getDescent());
            } else {
                graphics.setColor(Color.black);
                graphics.setFont(this.getFont());
                String string = Nyelv.get("OutputsTabbedPane.NoMessages");
                int n = ((Component)this).getFontMetrics(this.getFont()).stringWidth(string);
                graphics.drawString(string, this.getWidth() / 2 - n / 2, this.getHeight() / 2 + this.getFont().getSize() / 2);
            }
        }
    }

    public Component add(String string, Component component) {
        super.add(string, component);
        this.setToolTipTextAt(this.indexOfComponent(component), ((FreeJavaKimenet)((Object)component)).getFileUtvonal());
        if (this.getTabCount() > 0 && !this.freeJava.isKimenetLathato()) {
            this.freeJava.setKimenetLathato(true);
        }
        return component;
    }

    public void remove(Component component) {
        super.remove(component);
        if (this.getTabCount() == 0) {
            this.freeJava.setKimenetLathato(false);
        }
    }

    public boolean isKimenetLathato() {
        return this.freeJava.isKimenetLathato();
    }

    public void setKimenetLathato(boolean bl) {
        this.freeJava.setKimenetLathato(bl);
    }

    private void createPopupMenu() {
        this.pMenu = new FelpattanoMenu();
        this.pMenu.add(this.miBezar);
        this.pMenu.add(this.miTorles);
        this.pMenu.add(this.miBezarOsszes);
        SwingUtilities.updateComponentTreeUI(this.pMenu);
        this.pMenu.pack();
    }

    private void menuSzinkronizacio(String string, FreeJavaKimenet freeJavaKimenet) {
        this.miBezar.setText(Mindenes.menuIdezojelAtalakit(this.miBezar.getText(), string));
        this.miBezar.setToolTipText(freeJavaKimenet.getFileUtvonal());
    }

    private boolean javaThreadBezar(JavaThread javaThread, Component component) {
        Object[] objectArray = new String[]{Nyelv.get("Yes"), Nyelv.get("No")};
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
        int n = JOptionPane.showOptionDialog(jPanel, Nyelv.get("OutputsTabbedPane.WarningCloseText", javaThread.getFileUtvonal()), Nyelv.get("OutputsTabbedPane.WarningCloseTitle"), -1, 3, null, objectArray, objectArray[0]);
        if (n == 1 || n == -1) {
            return false;
        }
        javaThread.megol();
        this.remove(component);
        return true;
    }

    public boolean bezar() {
        FreeJavaKimenet freeJavaKimenet = (FreeJavaKimenet)((Object)this.getSelectedComponent());
        Component component = this.getSelectedComponent();
        if (freeJavaKimenet.getJavaThread() != null) {
            if (freeJavaKimenet.getJavaThread().isFut()) {
                return this.javaThreadBezar(freeJavaKimenet.getJavaThread(), component);
            }
            this.remove(component);
        } else {
            this.remove(component);
        }
        return true;
    }

    public void bezarOsszes() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.setSelectedIndex(i);
            this.bezar();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miBezar) {
            this.bezar();
        } else if (object == this.miTorles) {
            ((FreeJavaKimenet)((Object)this.getSelectedComponent())).torles();
        } else if (object == this.miBezarOsszes) {
            this.bezarOsszes();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.menuSzinkronizacio(this.getTitleAt(n), (FreeJavaKimenet)((Object)this.getComponentAt(n)));
        Component component = this.getSelectedComponent();
        if (component instanceof JavaThreadPanel && ((JavaThreadPanel)component).isFut()) {
            ((JavaThreadPanel)component).requestFocus();
        }
    }
}

