/*
 * Decompiled with CFR 0.152.
 */
package com.javazine.components;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public final class ProgressBar
extends Canvas {
    private int Count;
    private int Max;
    private static final int FrameBottom = 24;
    private Dimension dsize;
    private int currPrecentComplete;
    private Font fFont;
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private String sTitle = "";
    private boolean bFinished = false;

    public void updateProgress() {
        int n;
        ++this.Count;
        if (this.Count > this.Max) {
            this.Count = 0;
            this.currPrecentComplete = 0;
        }
        if ((n = this.Count * 100 / this.Max) > this.currPrecentComplete) {
            this.currPrecentComplete = n;
            this.repaint();
        }
    }

    public void reset() {
        this.Count = 0;
        this.repaint();
    }

    public void finished() {
        this.bFinished = true;
        this.Count = this.Max;
        this.repaint();
    }

    public ProgressBar(String string, int n, Dimension dimension) {
        this.dsize = dimension;
        this.Count = 0;
        this.currPrecentComplete = 0;
        this.Max = n;
        this.fFont = new Font("Dialog", 0, 12);
        this.sTitle = string;
        this.setSize(this.dsize);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (graphics == null) {
            return;
        }
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.iImage == null) {
            this.iImage = this.createImage(n, n2);
            this.gImage = this.iImage.getGraphics();
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        this.gImage.setFont(this.fFont);
        Dimension dimension = this.getSize();
        double d = (double)this.Count * 100.0 / (double)this.Max;
        int n3 = dimension.width * this.Count / this.Max;
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, n, n2);
        this.gImage.setColor(Color.red);
        this.gImage.fillRect(0, 0, n3, dimension.height);
        String string = this.sTitle + String.valueOf((int)d) + " %";
        this.gImage.setColor(Color.black);
        int n4 = this.fMetrics.stringWidth(string);
        this.gImage.drawString(string, (dimension.width - n4) / 2, dimension.height / 2 + 5);
        this.gImage.drawRect(0, 0, n - 1, n2 - 1);
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
        graphics.setColor(Color.black);
    }

    public Dimension getPreferredSize() {
        return this.dsize;
    }
}

