package com.db4o.jgen;

import com.db4o.lib.*;

public class JClass
{
	private JPackage i_Package;
	private Collection i_Imports;
	private String i_name;
	private String i_extends;
	private Collection i_Implements;
	private	Collection i_Fields;
	private Collection i_Methods;

	private String i_templateFile = "JClass.jgt"; // jgt = JGen Temlate

	public JClass(
		String a_name,
		JPackage a_package,
		String a_extends
	){
		i_name = a_name;
		i_Package = a_package;
		i_extends = a_extends;
	}

	public void addField(JField a_Field){
		if (i_Fields == null){
			i_Fields = new Collection();
		}
		if (a_Field != null){
			i_Fields.add(a_Field);
		}
	}

	public void addImplements(String a_Implement){
		if (i_Implements == null){
			i_Implements = new Collection();
		}
		i_Implements.add(a_Implement);
	}

	public void addImports(String a_Import){
		if (i_Imports == null){
			i_Imports = new Collection();
		}
		i_Imports.add(a_Import);
	}


	public void addMethod(JMethod a_Method){
		if(i_Methods == null){
			i_Methods = new Collection();
		}
		i_Methods.add(a_Method);
	}

	public void compile() throws Exception{
		String fileName = getFileName() + ".java";
		File l_File = new File(fileName);
		int len = l_File.getAbsolutePath().length() - fileName.length();
		String rootPath = l_File.getAbsolutePath().substring(0,len - 1);

		String classPath =
			rootPath +
			";" +
			rootPath +
			l_File.separator +
			"db4o.jar";

		String cmd = "javac -classpath " + classPath + " " + l_File.getAbsolutePath();
		Runtime.getRuntime().exec(cmd).waitFor();
	}

	public static Class[] getClassHierarchy(Object a_object){
		Class[] classes = new Class[1];
		classes[0] = a_object.getClass();
		return getClassHierarchy(classes);
	}

	public static Class[] getClassHierarchy(Class[] a_classes){
		Class clazz = a_classes[a_classes.length -1].getSuperclass();
		if(clazz.equals(Object.class)){
			return a_classes;
		}
		Class[] classes = new Class[a_classes.length + 1];
		System.arraycopy(a_classes,0,classes,0,a_classes.length);
		classes[a_classes.length] = clazz;
		return getClassHierarchy(classes);
	}


	public String getFileName(){
		return i_Package.getPath() + i_name;
	}

	public String getName(){
		return i_name;
	}

	private String templatePath(){
		return JGen.templatePath() + i_templateFile;
	}

	public void write(){
		String l_s;
		Iterator i;
		File l_File = new File(templatePath());
		l_File = l_File.copy(getFileName() + ".java");

		i_Package.write(l_File);

		l_s = "";
		if(i_Imports != null){
			i = i_Imports.iterator();
			while(i.hasNext()){
				l_s = l_s + "import " + (String)i.next() + ".*;";
				if (i.hasNext()){
					l_s = l_s + System.getProperty("line.separator");
				}
			}
		}
		l_File.replace(JGen.IMPORT,l_s);

		l_s = i_name;
		if (i_extends != null){
			if (i_extends.length() > 0 ){
				l_s = l_s + " extends " + i_extends;
			}
		}
		if (i_Implements != null){
			i = i_Implements.iterator();
			if (i.hasNext()){
				l_s = l_s + " implements " + i.next();
				while (i.hasNext()){
					l_s = l_s + ", " + (String)i.next();
				}
			}
		}
		l_File.replace(JGen.CLASS,"public class " + l_s);

		if(i_Fields != null){
			l_s = "";
			i = i_Fields.iterator();
			while(i.hasNext()){
				l_s = l_s + ((JField)i.next()).write();
				if (i.hasNext()){
					l_s = l_s + JGen.CR;
				}
			}
			l_File.replace(JGen.FIELDS,l_s);
		}else{
			l_File.replace(JGen.FIELDS,"");
		}


		if(i_Methods != null){
			l_s = "";
			i = i_Methods.iterator();
			while(i.hasNext()){
				l_s = l_s + ((JMethod)i.next()).write();
				if (i.hasNext()){
					l_s = l_s + JGen.CR + JGen.CR;
				}
			}
			l_File.replace(JGen.METHODS,l_s);
		}else{
			l_File.replace(JGen.METHODS,"");
		}


	}

}

