package com.db4o.jgen;

public abstract class JMember
{
	private static String PUBLIC = "public ";
	private static String STATIC = "static ";
	private static String TRANSIENT = "transient ";
	
	private String i_scope = PUBLIC;
	private boolean i_static;
	private boolean i_array;
	private boolean i_transient;
	private String i_className;
	private String i_name;
	
	public JMember(String a_className, String a_name){
		i_className = a_className;
		i_name = a_name;
	}
	
	public void setArray(){
		i_array = true;
	}
	
	public void setStatic(){
		i_static = true;
	}
	
	public void setTransient(){
		i_transient = true;
	}
	

	public String write(){
		String l_s = "\t" + i_scope;
		if (i_static){
			l_s = l_s + STATIC;
		}
		if(i_transient){
			l_s = l_s + TRANSIENT;
		}
		l_s = l_s + i_className;
		if (i_array){
			l_s = l_s + "[]";	
		}
		l_s = l_s + " " + i_name;
		
		l_s = l_s + writeBody();
		
		return l_s;
	}
	
	protected abstract String writeBody();

}
