package  com.db4o.lib;

/**
 * linked list Collection implementation
 * There is one difference to be noted to the JDK Collections:
 * toArray(Object[])
 * the passed array has to be initialized to the right length
 */
public class Collection implements Cloneable {
    private CollectionObject i_first;		// First element of the linked list
    private int i_size = 0;		// Number of elements collected

    public final void add (Object a_object) {
        i_first = new CollectionObject(i_first,a_object);
        i_size++;
    }

    public void add (Object[] a_objects) {
        if (a_objects != null) {
            for (int i = 0; i < a_objects.length; i++) {
                add(a_objects[i]);
            }
        }
    }

    public void addAll (Collection a_Collection) {
        addAll(a_Collection.iterator());
    }

	public void addUnique (Object object){
		Iterator i = iterator();
		while(i.hasNext()){
			if(i.next().equals(object)){
				return;
			}
		}
	}

    public void addAll (Iterator a_Iterator) {
        a_Iterator.reset();
        while (a_Iterator.hasNext()) {
            add(a_Iterator.next());
        }
    }

	public void clear () {
        i_first = null;
        i_size = 0;
    }

    /**
     * deep clone
     */
    public Object clone () {
        Collection collection = new Collection();
        collection.i_size = i_size;
        if (i_first != null) {
            collection.i_first = ((CollectionObject)i_first)._clone();
        }
        return  collection;
    }

    public boolean contains (Object a_Object) {
        Iterator i = iterator();
        while (i.hasNext()) {
			if (a_Object.equals(i.next())){
				return true;
			}
        }
        return  false;
    }

    public boolean containsAll (Collection a_collection) {
        Iterator i = a_collection.iterator();
        while (i.hasNext()) {
            if (!(contains(i.next()))) {
                return  false;
            }
        }
        return  true;
    }

    Object getFirst () {
        return  i_first;
    }

    public boolean isEmpty () {
        return  !(size() > 0);
    }

    public Iterator iterator () {
		return new Iterator(this, i_first);
    }

    public void remove (Object a_Equals) {
        Iterator i = iterator();
        while (i.hasNext()) {
			if (a_Equals.equals(i.next())){
				i.remove();
			}
        }
    }

    void setFirst (CollectionObject a_object) {
        i_first = a_object;
    }

    public int size () {
        return  i_size;
    }

    void sizeDecrement () {
        i_size--;
    }

    public Object[] toArray () {
        // Backwards, because elements are added backwards
        int j = (int)i_size;
        Object[] l_Objects = new Object[j];
        Iterator i = iterator();
        while (i.hasNext()) {
            l_Objects[--j] = i.next();
        }
        return  l_Objects;
    }

    /**
	 * Copies all objects in the collection to the passed array and returns it.
	 * There is a difference to JDK 1.2 Collection here.
	 * To avoid the necessity for reflection, the passed array has to be created to
	 * the size of the collection.
     */
    public Object[] toArray (Object[] a_array) {
        // this is the non reflection version, in contrast to suns implementation
        // the passed array has to be initialized to the right length
        int j = (int)i_size;
        Iterator i = iterator();
        while (i.hasNext()) {
            a_array[--j] = i.next();
        }
        return  a_array;
    }
}

