/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import jdbees.JBeesClock;
import jdbees.JBeesClockEvent;
import jdbees.JBeesClockListener;
import jdbees.JBeesConfInfo;
import jdbees.JBeesLocalFile;
import jdbees.JBeesResumeFileInfo;
import jdbees.JBeesTeamStatus;
import jdbees.JBeesTeamStatusEvent;
import jdbees.JBeesTeamStatusListener;
import jdbees.JBeesUtils;

public abstract class JBeesTeam
implements Runnable,
JBeesClockListener {
    protected JBeesConfInfo jbcfi;
    protected JBeesResumeFileInfo jbrfi;
    protected JBeesTeamStatus jbts;
    protected URL url;
    protected JBeesLocalFile jblf;
    protected long fileLen;
    protected String lastModifiedDate;
    protected ThreadGroup tg;
    protected boolean stopDownloading = false;
    private long rate;
    private long realrate;
    private Vector listeners = new Vector();
    private int timeElapse = 0;
    private double percent;
    private boolean success;
    private boolean finished;
    private JBeesClock jbc;

    public JBeesTeam(URL url, String localFileName, JBeesConfInfo conf) throws IOException {
        this.url = url;
        this.jblf = new JBeesLocalFile(localFileName);
        this.jbcfi = conf;
        this.jbrfi = new JBeesResumeFileInfo();
        this.jbrfi.setOrgURL(url.toString());
        this.jbrfi.setLocalFileName(localFileName);
        this.initialStatus(localFileName);
    }

    public JBeesTeam(JBeesResumeFileInfo resume, JBeesConfInfo conf) throws IOException, MalformedURLException {
        this.jbrfi = resume;
        this.jbcfi = conf;
        this.url = new URL(resume.getOrgURL());
        this.jblf = new JBeesLocalFile(resume.getLocalFileName());
        this.percent = resume.getPercentage();
        this.initialStatus(resume.getLocalFileName());
    }

    void initialStatus(String localFileName) {
        this.jbts = new JBeesTeamStatus(this.url, localFileName);
        this.jbts.setUsedTimeStr("00:00:00");
        this.jbts.setRemainTimeStr("00:00:00");
        this.tg = new ThreadGroup(this.url.toString());
        this.jbc = new JBeesClock();
        this.jbc.addJBeesClockListener(this);
    }

    public synchronized void updateRate(long l) {
        this.rate += l;
    }

    public void updateStatus() {
        this.jbts.setBeesNum(this.tg.activeCount());
        this.jbts.setRate(this.realrate);
        if (this.fileLen > 0L && this.realrate > 0L) {
            this.percent += (double)this.realrate / (double)this.fileLen;
            this.jbts.setPercentage("" + (int)(100.0 * this.percent) + "%");
            int remTime = (int)((double)this.fileLen * (1.0 - this.percent) / (double)this.realrate);
            this.jbts.setRemainTimeStr(JBeesUtils.getTimeStr(remTime));
        }
    }

    protected void setPercent(double d) {
        this.percent = d;
    }

    public synchronized void updateResumeBegin(int index, long beg) {
        this.jbrfi.setRemoteBegin(index, beg);
    }

    public abstract void JBeesFlying() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block27: {
            block29: {
                block32: {
                    block30: {
                        block31: {
                            block28: {
                                block24: {
                                    isException = false;
                                    exc = null;
                                    this.JBeesFlying();
                                    if (this.tg.activeCount() <= 0) break block24;
                                    list = new Thread[this.tg.activeCount()];
                                    num = this.tg.enumerate(list);
                                    i = 0;
                                    while (i < num) {
                                        list[i].join();
                                        ++i;
                                    }
                                }
                                var7_7 = null;
                                try {
                                    this.jblf.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                this.finished = true;
                                if (!this.stopDownloading) {
                                    if (!isException) {
                                        segment = this.jbrfi.getRemoteBegin().length;
                                        sum = 0;
                                        i = 0;
                                        while (i < segment) {
                                            sum = (int)((long)sum + (this.jbrfi.getRemoteEnd(i) - this.jbrfi.getRemoteBegin(i) + 1L));
                                            ++i;
                                        }
                                        if (sum > 0) {
                                            this.fireJBeesTeamStatusEvent();
                                            JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " failed", "Error", 0);
                                        } else {
                                            this.success = true;
                                            this.fireJBeesTeamStatusEvent();
                                            if (!this.jbcfi.getPrompt4failure()) {
                                                JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " Succeeded", "Success", 1);
                                            }
                                        }
                                    } else {
                                        this.fireJBeesTeamStatusEvent();
                                        JOptionPane.showMessageDialog(null, exc + " Exceptions occured during downloading from " + this.url.toString(), "Exception", 0);
                                    }
                                    this.jbc.interrupt();
                                    this.fireJBeesTeamStatusEvent();
                                }
                                break block27;
                                {
                                    catch (Exception e) {
                                        this.jbc.interrupt();
                                        exc = e;
                                        isException = true;
                                        var7_8 = null;
                                        try {
                                            this.jblf.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        this.finished = true;
                                        if (this.stopDownloading) break block27;
                                        if (isException) break block28;
                                        segment = this.jbrfi.getRemoteBegin().length;
                                        sum = 0;
                                        i = 0;
                                        ** while (i < segment)
                                    }
                                }
lbl-1000:
                                // 1 sources

                                {
                                    sum = (int)((long)sum + (this.jbrfi.getRemoteEnd(i) - this.jbrfi.getRemoteBegin(i) + 1L));
                                    ++i;
                                    continue;
                                }
lbl68:
                                // 1 sources

                                if (sum > 0) {
                                    this.fireJBeesTeamStatusEvent();
                                    JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " failed", "Error", 0);
                                } else {
                                    this.success = true;
                                    this.fireJBeesTeamStatusEvent();
                                    if (!this.jbcfi.getPrompt4failure()) {
                                        JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " Succeeded", "Success", 1);
                                    }
                                }
                                break block31;
                            }
                            this.fireJBeesTeamStatusEvent();
                            JOptionPane.showMessageDialog(null, exc + " Exceptions occured during downloading from " + this.url.toString(), "Exception", 0);
                        }
                        this.jbc.interrupt();
                        this.fireJBeesTeamStatusEvent();
                        {
                            break block27;
                        }
                        catch (Throwable var6_22) {
                            var7_9 = null;
                            try {
                                this.jblf.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.finished = true;
                            if (this.stopDownloading) break block29;
                            if (isException) break block30;
                            segment = this.jbrfi.getRemoteBegin().length;
                            sum = 0;
                            i = 0;
                            ** while (i < segment)
                        }
lbl-1000:
                        // 1 sources

                        {
                            sum = (int)((long)sum + (this.jbrfi.getRemoteEnd(i) - this.jbrfi.getRemoteBegin(i) + 1L));
                            ++i;
                            continue;
                        }
lbl102:
                        // 1 sources

                        if (sum > 0) {
                            this.fireJBeesTeamStatusEvent();
                            JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " failed", "Error", 0);
                        } else {
                            this.success = true;
                            this.fireJBeesTeamStatusEvent();
                            if (!this.jbcfi.getPrompt4failure()) {
                                JOptionPane.showMessageDialog(null, "downloading from " + this.url.toString() + " Succeeded", "Success", 1);
                            }
                        }
                        break block32;
                    }
                    this.fireJBeesTeamStatusEvent();
                    JOptionPane.showMessageDialog(null, exc + " Exceptions occured during downloading from " + this.url.toString(), "Exception", 0);
                }
                this.jbc.interrupt();
                this.fireJBeesTeamStatusEvent();
            }
            throw var6_22;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockChanged(JBeesClockEvent jce) {
        JBeesTeam jBeesTeam = this;
        synchronized (jBeesTeam) {
            this.realrate = this.rate;
            this.rate = 0L;
        }
        ++this.timeElapse;
        this.jbts.setUsedTimeStr(JBeesUtils.getTimeStr(this.timeElapse));
        this.fireJBeesTeamStatusEvent();
    }

    public void addJBeesTeamStatusListener(JBeesTeamStatusListener l) {
        this.listeners.addElement(l);
    }

    public void removeJBeesTeamStatusListener(JBeesTeamStatusListener l) {
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJBeesTeamStatusEvent() {
        Vector v;
        JBeesTeam jBeesTeam = this;
        synchronized (jBeesTeam) {
            v = (Vector)this.listeners.clone();
        }
        JBeesTeamStatusEvent jbtse = new JBeesTeamStatusEvent(this);
        this.setStatus(jbtse);
        int i = 0;
        while (i < v.size()) {
            JBeesTeamStatusListener jbtsl = (JBeesTeamStatusListener)v.elementAt(i);
            jbtsl.JBeesTeamStatusChanged(jbtse);
            ++i;
        }
    }

    private void setStatus(JBeesTeamStatusEvent jbtse) {
        this.updateStatus();
        jbtse.setJBeesTeamStatus(this.jbts);
    }

    public JBeesResumeFileInfo getResumeFileInfo() {
        return this.jbrfi;
    }

    public void stopDownload() {
        this.setInterrupted();
        this.stopDownloading = true;
        this.jbc.interrupt();
    }

    public boolean getStopped() {
        return this.stopDownloading;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public abstract void setInterrupted();

    public boolean isSuccess() {
        return this.success;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }
}

