/*
 * Decompiled with CFR 0.152.
 */
package jdbees.web;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jdbees.web.JBeesWebDlg;

public class JBeesWebEditorPane
extends JEditorPane
implements HyperlinkListener,
MouseListener,
ActionListener {
    private Stack back;
    private Stack forward;
    private URL current;
    private JPopupMenu popmenu;
    private JMenuItem backItem;
    private JMenuItem forwardItem;
    private JMenuItem downloadItem;
    private JMenuItem downloadCurrentItem;
    private JBeesWebDlg dlg;
    private String hyperLink;

    public JBeesWebEditorPane(String url, JBeesWebDlg dlg) {
        this.dlg = dlg;
        try {
            if (url != null) {
                this.current = new URL(url);
                this.setPage(this.current);
            } else {
                this.current = null;
            }
            this.addHyperlinkListener(this);
            this.addMouseListener(this);
            this.setEditable(false);
            this.back = new Stack();
            this.forward = new Stack();
            this.popmenu = new JPopupMenu();
            this.backItem = new JMenuItem("Back");
            this.forwardItem = new JMenuItem("Forward");
            this.downloadItem = new JMenuItem("Download it");
            this.downloadCurrentItem = new JMenuItem("Download current page");
            this.backItem.addActionListener(this);
            this.forwardItem.addActionListener(this);
            this.downloadItem.addActionListener(this);
            this.downloadCurrentItem.addActionListener(this);
            this.popmenu.add(this.backItem);
            this.popmenu.add(this.forwardItem);
            this.popmenu.addSeparator();
            this.popmenu.add(this.downloadItem);
            this.popmenu.add(this.downloadCurrentItem);
            this.backItem.setEnabled(false);
            this.forwardItem.setEnabled(false);
            this.downloadItem.setEnabled(false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void setCurrentPage(URL url) {
        this.current = url;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                return;
            }
            try {
                this.hyperLink = e.getURL().toString();
                this.downloadItem.setEnabled(true);
                this.dlg.setStatus(this.hyperLink);
            }
            catch (Exception ex) {}
        } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.back.addElement(this.current);
                    this.current = e.getURL();
                    this.dlg.setStatus(this.current.toString());
                    pane.setPage(this.current);
                    this.backItem.setEnabled(true);
                    this.forwardItem.setEnabled(false);
                    this.forward.clear();
                    this.dlg.setAddress(this.current.toString());
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.hyperLink = null;
            this.downloadItem.setEnabled(false);
            this.dlg.setStatus(this.current.toString());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popmenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.backItem) {
            this.forwardItem.setEnabled(true);
            this.forward.push(this.current);
            this.current = (URL)this.back.pop();
            this.dlg.setStatus(this.current.toString());
            try {
                this.setPage(this.current);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.back.empty()) {
                this.backItem.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.forwardItem) {
            this.back.push(this.current);
            this.backItem.setEnabled(true);
            this.current = (URL)this.forward.pop();
            this.dlg.setStatus(this.current.toString());
            try {
                this.setPage(this.current);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.forward.empty()) {
                this.forwardItem.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.downloadItem) {
            this.dlg.download(this.hyperLink);
        } else {
            this.dlg.download(this.current.toString());
        }
        this.dlg.setAddress(this.current.toString());
    }
}

