/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.VersionInfo;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.samples.demo.HTMLText;
import com.jniwrapper.win32.samples.demo.LazyPanel;
import com.jniwrapper.win32.shell.TrayIcon;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

class TrayIconSample
extends LazyPanel
implements ActionListener {
    private static final String MENU_ITEM_SHOW_TRAY_ICON = "Show Tray Icon";
    private static final String MENU_ITEM_SHOW_STANDARD_ICON = "Show Stadard System Icon";
    private static final String MENU_ITEM_SHOW_CUSTOM_ICON = "Show Custom Icon";
    private static final String MENU_ITEM_SHOW_CALLOUT = "Show Tray Balloon";
    private static final String MENU_HIDE_TRAY_ICON = "Hide Tray Icon";
    private JLabel lblAdvisoryText;
    private JButton btnShowTrayIcon;
    private JButton btnShowStandardSystemIcon;
    private JButton btnShowCustomIcon;
    private JButton btnShowTrayBallon;
    private JButton btnHideTrayIcon;
    private TrayIcon _trayIcon;
    private PopupMenu _popupMenu;
    private Window _popupMenuInvoker;

    public TrayIconSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("This page demonstrates the Tray Icon abilities: misc. icons, menu, balloons.");
        this.btnShowTrayIcon = new JButton(MENU_ITEM_SHOW_TRAY_ICON);
        this.btnShowTrayIcon.setActionCommand(MENU_ITEM_SHOW_TRAY_ICON);
        this.btnShowTrayIcon.addActionListener(this);
        this.btnShowStandardSystemIcon = new JButton(MENU_ITEM_SHOW_STANDARD_ICON);
        this.btnShowStandardSystemIcon.setActionCommand(MENU_ITEM_SHOW_STANDARD_ICON);
        this.btnShowStandardSystemIcon.addActionListener(this);
        this.btnShowCustomIcon = new JButton(MENU_ITEM_SHOW_CUSTOM_ICON);
        this.btnShowCustomIcon.setActionCommand(MENU_ITEM_SHOW_CUSTOM_ICON);
        this.btnShowCustomIcon.addActionListener(this);
        this.btnShowTrayBallon = new JButton(MENU_ITEM_SHOW_CALLOUT);
        this.btnShowTrayBallon.setActionCommand(MENU_ITEM_SHOW_CALLOUT);
        this.btnShowTrayBallon.addActionListener(this);
        this.btnHideTrayIcon = new JButton(MENU_HIDE_TRAY_ICON);
        this.btnHideTrayIcon.setActionCommand(MENU_HIDE_TRAY_ICON);
        this.btnHideTrayIcon.addActionListener(this);
        Dimension buttonSize = this.btnShowStandardSystemIcon.getPreferredSize();
        this.btnShowTrayIcon.setPreferredSize(buttonSize);
        this.btnShowCustomIcon.setPreferredSize(buttonSize);
        this.btnShowTrayBallon.setPreferredSize(buttonSize);
        this.btnHideTrayIcon.setPreferredSize(buttonSize);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowTrayIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowStandardSystemIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowCustomIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowTrayBallon, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnHideTrayIcon, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._trayIcon = new TrayIcon(Icon.SystemIcon.BANG.getIcon());
        this._trayIcon.setToolTip("Tray Tooltip");
        this._trayIcon.addTrayListener(new TrayIconListener(){

            public void trayActionPerformed(long message, int x, int y) {
                if (message == 517L) {
                    TrayIconSample.this.showPopup(x, y);
                } else if (message == 515L) {
                    TrayIconSample.this._trayIcon.setIcon(Icon.SystemIcon.HAND.getIcon());
                }
            }
        });
        this._popupMenu = new PopupMenu();
        this._popupMenu.add(MENU_ITEM_SHOW_STANDARD_ICON);
        this._popupMenu.add(MENU_ITEM_SHOW_CUSTOM_ICON);
        this._popupMenu.addSeparator();
        this._popupMenu.add(MENU_ITEM_SHOW_CALLOUT);
        this._popupMenu.addSeparator();
        this._popupMenu.add(MENU_HIDE_TRAY_ICON);
        this._popupMenu.addActionListener(this);
        this._popupMenuInvoker = new JWindow(this.getParentWindow());
        this._popupMenuInvoker.add(this._popupMenu);
        this._popupMenuInvoker.setVisible(true);
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin9x()) {
            this.btnShowTrayBallon.setEnabled(false);
            this.btnHideTrayIcon.setEnabled(false);
        }
        super.initialize();
    }

    private void showPopup(int x, int y) {
        this._popupMenu.show(this._popupMenuInvoker, x, y);
    }

    private void changeIconToQuestion() {
        this._trayIcon.setIcon(Icon.SystemIcon.QUES.getIcon());
    }

    private void changeIconToCustom() {
        Icon customIcon = new Icon();
        customIcon.loadFromFile("jniwrapper.ico");
        this._trayIcon.setIcon(customIcon);
    }

    private void showCallout() {
        this._trayIcon.showMessage((TrayMessage)new TrayMessage.Warning("Tray Balloon", "This program demonstrates the WinPack for JNIWrapper library abilities:\n\t - tray icon\n\t - menu for tray icon\n\t - balloons from tray icon\netc."));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(MENU_ITEM_SHOW_TRAY_ICON)) {
            this._trayIcon.setVisible(true);
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_STANDARD_ICON)) {
            this.changeIconToQuestion();
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CUSTOM_ICON)) {
            this.changeIconToCustom();
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CALLOUT)) {
            this.showCallout();
        } else if (e.getActionCommand().equals(MENU_HIDE_TRAY_ICON)) {
            this._trayIcon.setVisible(false);
        }
    }

    public void deactivate() {
        this._trayIcon.setVisible(false);
    }

    public void activate() throws Exception {
        super.activate();
        this._trayIcon.setVisible(true);
    }

    static {
        MENU_ITEM_SHOW_TRAY_ICON = MENU_ITEM_SHOW_TRAY_ICON;
        MENU_ITEM_SHOW_STANDARD_ICON = MENU_ITEM_SHOW_STANDARD_ICON;
        MENU_ITEM_SHOW_CUSTOM_ICON = MENU_ITEM_SHOW_CUSTOM_ICON;
        MENU_ITEM_SHOW_CALLOUT = MENU_ITEM_SHOW_CALLOUT;
        MENU_HIDE_TRAY_ICON = MENU_HIDE_TRAY_ICON;
    }
}

